/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.property;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.property.ThingReportPropertyMessage;
import org.jetlinks.core.metadata.types.LongType;
import org.jetlinks.core.things.ThingProperty;
import org.jetlinks.core.utils.MapUtils;

public class ReportPropertyMessage
extends CommonDeviceMessage<ReportPropertyMessage>
implements ThingReportPropertyMessage {
    private Map<String, Object> properties;
    private Map<String, Long> propertySourceTimes;
    private Map<String, String> propertyStates;

    public static ReportPropertyMessage create() {
        return new ReportPropertyMessage();
    }

    @Override
    public ReportPropertyMessage success(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public ReportPropertyMessage propertySourceTimes(Map<String, Long> times) {
        this.propertySourceTimes = times;
        return this;
    }

    @Override
    public ReportPropertyMessage propertyStates(Map<String, String> states) {
        this.propertyStates = states;
        return this;
    }

    @Override
    public ReportPropertyMessage properties(Map<String, Object> properties) {
        return this.success((Map)properties);
    }

    @Override
    public ReportPropertyMessage success(List<ThingProperty> properties) {
        this.properties = Maps.newLinkedHashMapWithExpectedSize((int)properties.size());
        this.propertySourceTimes = Maps.newLinkedHashMapWithExpectedSize((int)properties.size());
        this.propertyStates = Maps.newLinkedHashMapWithExpectedSize((int)properties.size());
        for (ThingProperty property : properties) {
            this.properties.put(property.getProperty(), property.getValue());
            this.propertySourceTimes.put(property.getProperty(), property.getTimestamp());
            this.propertyStates.put(property.getProperty(), property.getState());
        }
        return this;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.properties = jsonObject.getJSONObject("properties");
        this.propertySourceTimes = MapUtils.convertKeyValue(jsonObject.getJSONObject("propertySourceTimes"), String::valueOf, LongType.GLOBAL::convert);
        this.propertyStates = MapUtils.convertKeyValue(jsonObject.getJSONObject("propertyStates"), String::valueOf, String::valueOf);
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.REPORT_PROPERTY;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, Long> getPropertySourceTimes() {
        return this.propertySourceTimes;
    }

    @Override
    public Map<String, String> getPropertyStates() {
        return this.propertyStates;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setPropertySourceTimes(Map<String, Long> propertySourceTimes) {
        this.propertySourceTimes = propertySourceTimes;
    }

    public void setPropertyStates(Map<String, String> propertyStates) {
        this.propertyStates = propertyStates;
    }
}

