/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.property;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Maps;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.message.property.Property;
import org.jetlinks.core.message.property.SimplePropertyValue;
import org.jetlinks.core.utils.SerializeUtils;
import org.springframework.util.CollectionUtils;

public interface PropertyMessage
extends Externalizable {
    @Nullable
    public Map<String, Object> getProperties();

    @Nullable
    public Map<String, Long> getPropertySourceTimes();

    @Nullable
    public Map<String, String> getPropertyStates();

    public long getTimestamp();

    default public Optional<Long> getPropertySourceTime(@Nonnull String property) {
        Map<String, Long> sourceTime = this.getPropertySourceTimes();
        if (CollectionUtils.isEmpty(sourceTime)) {
            return Optional.empty();
        }
        return Optional.ofNullable(sourceTime.get(property));
    }

    default public Optional<String> getPropertyState(@Nonnull String property) {
        Map<String, String> states = this.getPropertyStates();
        if (CollectionUtils.isEmpty(states)) {
            return Optional.empty();
        }
        return Optional.ofNullable(states.get(property));
    }

    default public Optional<Object> getProperty(String property) {
        return Optional.ofNullable(this.getProperties()).map(props -> props.get(property));
    }

    default public Optional<Property> getCompleteProperty(String property) {
        return this.getProperty(property).map(value -> {
            long ts = this.getPropertySourceTime(property).orElse(this.getTimestamp());
            String state = this.getPropertyState(property).orElse(null);
            return SimplePropertyValue.of(property, value, ts, state);
        });
    }

    default public Property getCompletePropertyOrNull(String property) {
        return this.getCompleteProperty(property).orElse(null);
    }

    @JsonIgnore
    @JSONField(serialize=false)
    default public List<Property> getCompleteProperties() {
        Map<String, Object> properties = this.getProperties();
        if (CollectionUtils.isEmpty(properties)) {
            return Collections.emptyList();
        }
        ArrayList<Property> list = new ArrayList<Property>(properties.size());
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            long ts = this.getPropertySourceTime(entry.getKey()).orElse(this.getTimestamp());
            String state = this.getPropertyState(entry.getKey()).orElse(null);
            list.add(SimplePropertyValue.of(entry.getKey(), entry.getValue(), ts, state));
        }
        return list;
    }

    public PropertyMessage properties(Map<String, Object> var1);

    public PropertyMessage propertySourceTimes(Map<String, Long> var1);

    public PropertyMessage propertyStates(Map<String, String> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public PropertyMessage mergeProperties(Map<String, Object> properties) {
        PropertyMessage propertyMessage = this;
        synchronized (propertyMessage) {
            Map<String, Object> old = this.getProperties();
            if (old == null) {
                return this.properties(properties);
            }
            if (old instanceof HashMap || old instanceof ConcurrentHashMap || old instanceof TreeMap || old instanceof Hashtable) {
                old.putAll(properties);
                return this;
            }
            HashMap<String, Object> copy = new HashMap<String, Object>(old);
            copy.putAll(properties);
            return this.properties(copy);
        }
    }

    @Override
    default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.properties(SerializeUtils.readMap(in, Maps::newLinkedHashMapWithExpectedSize));
        this.propertySourceTimes(SerializeUtils.readMap(in, Maps::newLinkedHashMapWithExpectedSize));
        this.propertyStates(SerializeUtils.readMap(in, Maps::newLinkedHashMapWithExpectedSize));
    }

    @Override
    default public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeKeyValue(this.getProperties(), out);
        SerializeUtils.writeKeyValue(this.getPropertySourceTimes(), out);
        SerializeUtils.writeKeyValue(this.getPropertyStates(), out);
    }
}

