/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.property;

import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.message.CommonThingMessageReply;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.property.ReadThingPropertyMessageReply;
import org.jetlinks.core.things.ThingProperty;

public class DefaultReadPropertyMessageReply
extends CommonThingMessageReply<DefaultReadPropertyMessageReply>
implements ReadThingPropertyMessageReply {
    private Map<String, Object> properties;
    private Map<String, Long> propertySourceTimes;
    private Map<String, String> propertyStates;

    public static DefaultReadPropertyMessageReply create() {
        DefaultReadPropertyMessageReply reply = new DefaultReadPropertyMessageReply();
        reply.setTimestamp(System.currentTimeMillis());
        return reply;
    }

    @Override
    public DefaultReadPropertyMessageReply success(Map<String, Object> properties) {
        this.properties = properties;
        super.setSuccess(true);
        return this;
    }

    @Override
    public DefaultReadPropertyMessageReply success(List<ThingProperty> properties) {
        this.properties = new LinkedHashMap<String, Object>();
        this.propertySourceTimes = new LinkedHashMap<String, Long>();
        this.propertyStates = new LinkedHashMap<String, String>();
        for (ThingProperty property : properties) {
            this.properties.put(property.getProperty(), property.getValue());
            this.propertySourceTimes.put(property.getProperty(), property.getTimestamp());
            this.propertyStates.put(property.getProperty(), property.getState());
        }
        return this;
    }

    @Override
    public DefaultReadPropertyMessageReply propertySourceTimes(Map<String, Long> times) {
        this.propertySourceTimes = times;
        return this;
    }

    @Override
    public DefaultReadPropertyMessageReply propertyStates(Map<String, String> states) {
        this.propertyStates = states;
        return this;
    }

    @Override
    public DefaultReadPropertyMessageReply properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.properties = jsonObject.getJSONObject("properties");
        this.propertySourceTimes = jsonObject.getJSONObject("propertySourceTimes");
        this.propertyStates = jsonObject.getJSONObject("propertyStates");
    }

    @Override
    public MessageType getMessageType() {
        return MessageType.READ_PROPERTY_REPLY;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Map<String, Long> getPropertySourceTimes() {
        return this.propertySourceTimes;
    }

    @Override
    public Map<String, String> getPropertyStates() {
        return this.propertyStates;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setPropertySourceTimes(Map<String, Long> propertySourceTimes) {
        this.propertySourceTimes = propertySourceTimes;
    }

    public void setPropertyStates(Map<String, String> propertyStates) {
        this.propertyStates = propertyStates;
    }
}

