/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.function;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetlinks.core.message.CommonThingMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.function.DefaultFunctionInvokeMessageReply;
import org.jetlinks.core.message.function.FunctionParameter;
import org.jetlinks.core.message.function.ThingFunctionInvokeMessage;

public class DefaultFunctionInvokeMessage
extends CommonThingMessage<DefaultFunctionInvokeMessage>
implements ThingFunctionInvokeMessage<DefaultFunctionInvokeMessageReply> {
    private String functionId;
    private List<FunctionParameter> inputs = new ArrayList<FunctionParameter>();

    @Override
    public MessageType getMessageType() {
        return ThingFunctionInvokeMessage.super.getMessageType();
    }

    public DefaultFunctionInvokeMessage addInput(FunctionParameter parameter) {
        this.inputs.add(parameter);
        return this;
    }

    public DefaultFunctionInvokeMessage functionId(String id) {
        this.functionId = id;
        return this;
    }

    public DefaultFunctionInvokeMessage addInput(String name, Object value) {
        ThingFunctionInvokeMessage.super.addInput(name, value);
        return this;
    }

    public DefaultFunctionInvokeMessage addInputs(Map<String, Object> parameters) {
        ThingFunctionInvokeMessage.super.addInputs(parameters);
        return this;
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        Object inputs = jsonObject.get((Object)"inputs");
        if (inputs instanceof Map) {
            super.fromJson(new JSONObject(Maps.filterKeys((Map)jsonObject, key -> !"inputs".equals(key))));
            Map inputMap = (Map)inputs;
            inputMap.forEach(this::addInput);
            return;
        }
        super.fromJson(jsonObject);
    }

    @Override
    public DefaultFunctionInvokeMessageReply newReply() {
        DefaultFunctionInvokeMessageReply reply = (DefaultFunctionInvokeMessageReply)new DefaultFunctionInvokeMessageReply().from(this);
        reply.setFunctionId(this.functionId);
        return reply;
    }

    @Override
    public String getFunctionId() {
        return this.functionId;
    }

    @Override
    public List<FunctionParameter> getInputs() {
        return this.inputs;
    }

    public void setFunctionId(String functionId) {
        this.functionId = functionId;
    }

    public void setInputs(List<FunctionParameter> inputs) {
        this.inputs = inputs;
    }
}

