/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.collector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.jetlinks.core.message.CommonDeviceMessageReply;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.collector.CollectorDataReply;
import org.springframework.util.CollectionUtils;

public final class WriteCollectorDataMessageReply
extends CommonDeviceMessageReply<WriteCollectorDataMessageReply> {
    private List<CollectorDataReply> data;

    @Override
    public MessageType getMessageType() {
        return MessageType.WRITE_COLLECTOR_DATA_REPLY;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (CollectionUtils.isEmpty(this.data)) {
            out.writeInt(0);
        } else {
            out.writeInt(this.data.size());
            for (CollectorDataReply datum : this.data) {
                datum.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int size = in.readInt();
        this.data = new ArrayList<CollectorDataReply>(size);
        for (int i = 0; i < size; ++i) {
            CollectorDataReply data = new CollectorDataReply();
            data.readExternal(in);
            this.data.add(data);
        }
    }

    public List<CollectorDataReply> getData() {
        return this.data;
    }

    public void setData(List<CollectorDataReply> data) {
        this.data = data;
    }
}

