/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.collector;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.jetlinks.core.message.CommonDeviceMessage;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.collector.CollectorData;
import org.springframework.util.CollectionUtils;

public final class ReportCollectorDataMessage
extends CommonDeviceMessage<ReportCollectorDataMessage> {
    public static final HeaderKey<String> ADDRESS = HeaderKey.of("_address", null, String.class);
    private List<CollectorData> data;

    @Override
    public MessageType getMessageType() {
        return MessageType.REPORT_COLLECTOR;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (CollectionUtils.isEmpty(this.data)) {
            out.writeInt(0);
        } else {
            out.writeInt(this.data.size());
            for (CollectorData datum : this.data) {
                datum.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int size = in.readInt();
        this.data = new ArrayList<CollectorData>(size);
        for (int i = 0; i < size; ++i) {
            CollectorData data = new CollectorData();
            data.readExternal(in);
            this.data.add(data);
        }
    }

    public List<CollectorData> getData() {
        return this.data;
    }

    public void setData(List<CollectorData> data) {
        this.data = data;
    }
}

