/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http.websocket;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.http.Header;
import org.jetlinks.core.message.codec.http.HttpUtils;
import org.jetlinks.core.message.codec.http.websocket.WebSocketMessage;
import org.jetlinks.core.server.ClientConnection;
import org.springframework.http.HttpStatus;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface WebSocketSession
extends ClientConnection {
    public Optional<InetSocketAddress> getRemoteAddress();

    default public String getPath() {
        return HttpUtils.getUrlPath(this.getUri());
    }

    default public Map<String, String> getQueryParameters() {
        String uri = this.getUri();
        int indexOf = uri.indexOf(63);
        if (indexOf < 0) {
            return Collections.emptyMap();
        }
        return HttpUtils.parseEncodedUrlParams(uri);
    }

    public String getUri();

    @Nonnull
    public List<Header> getHeaders();

    public Optional<Header> getHeader(String var1);

    public Mono<Void> close();

    public Mono<Void> close(int var1);

    default public Mono<Void> close(HttpStatus status) {
        return this.close(1014, status.getReasonPhrase());
    }

    default public Mono<Void> close(int status, String reason) {
        return this.close(status);
    }

    public Map<String, Object> getAttributes();

    public Optional<Object> getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public Flux<WebSocketMessage> receive();

    public Mono<Void> send(WebSocketMessage var1);

    public WebSocketMessage textMessage(String var1);

    public WebSocketMessage binaryMessage(ByteBuf var1);

    public WebSocketMessage pingMessage(ByteBuf var1);

    public WebSocketMessage pongMessage(ByteBuf var1);

    @Override
    default public InetSocketAddress address() {
        return this.getRemoteAddress().orElse(null);
    }

    @Override
    default public Mono<Void> sendMessage(EncodedMessage message) {
        if (message instanceof WebSocketMessage) {
            return this.send((WebSocketMessage)message);
        }
        return this.send(this.binaryMessage(message.getPayload()));
    }

    @Override
    default public Flux<EncodedMessage> receiveMessage() {
        return this.receive().cast(EncodedMessage.class);
    }

    @Override
    default public void disconnect() {
        this.close().subscribe();
    }

    @Override
    default public void onDisconnect(Runnable callback) {
        ClientConnection.super.onDisconnect(callback);
    }
}

