/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec.http;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.message.codec.http.Header;
import org.jetlinks.core.message.codec.http.HttpExchangeMessage;
import org.jetlinks.core.message.codec.http.HttpRequestMessage;
import org.jetlinks.core.message.codec.http.HttpResponseMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;

class SimpleHttpExchangeMessage
implements HttpExchangeMessage {
    public final HttpRequestMessage request;
    private final Function<HttpResponseMessage, Mono<Void>> responseHandler;

    @Override
    @Nonnull
    public ByteBuf getPayload() {
        return this.request.getPayload();
    }

    @Override
    @Nonnull
    public Mono<Void> response(@Nonnull HttpResponseMessage message) {
        return this.responseHandler.apply(message);
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.request.getPath();
    }

    @Override
    @Nonnull
    public String getUrl() {
        return this.request.getUrl();
    }

    @Override
    @Nonnull
    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    @Override
    @Nullable
    public MediaType getContentType() {
        return this.request.getContentType();
    }

    @Override
    @Nonnull
    public List<Header> getHeaders() {
        return this.request.getHeaders();
    }

    @Override
    @Nullable
    public Map<String, String> getQueryParameters() {
        return this.request.getQueryParameters();
    }

    public SimpleHttpExchangeMessage(HttpRequestMessage request, Function<HttpResponseMessage, Mono<Void>> responseHandler) {
        this.request = request;
        this.responseHandler = responseHandler;
    }
}

