/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.message.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttProperties;
import org.jetlinks.core.message.codec.MessagePayloadType;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.message.codec.TextMessageParser;

public class SimpleMqttMessage
implements MqttMessage {
    private String topic;
    private String clientId;
    private int qosLevel;
    private ByteBuf payload;
    private int messageId;
    private boolean will;
    private boolean dup;
    private boolean retain;
    @Deprecated
    private MessagePayloadType payloadType;
    private MqttProperties properties;

    public SimpleMqttMessage(String topic, String clientId, int qosLevel, ByteBuf payload, int messageId, boolean will, boolean dup, boolean retain, MessagePayloadType payloadType) {
        this.topic = topic;
        this.clientId = clientId;
        this.qosLevel = qosLevel;
        this.payload = payload;
        this.messageId = messageId;
        this.will = will;
        this.dup = dup;
        this.retain = retain;
        this.payloadType = payloadType;
        this.properties = MqttProperties.NO_PROPERTIES;
    }

    public SimpleMqttMessage() {
    }

    public static SimpleMqttMessageBuilder builder() {
        return new SimpleMqttMessageBuilder();
    }

    public static SimpleMqttMessageBuilder builder(MqttMessage message) {
        return new SimpleMqttMessageBuilder().topic(message.getTopic()).messageId(message.getMessageId()).clientId(message.getClientId()).qosLevel(message.getQosLevel()).payload(message.getPayload()).properties(message.getProperties()).retain(message.isRetain()).dup(message.isDup()).will(message.isWill());
    }

    public String toString() {
        return this.print();
    }

    public static SimpleMqttMessage of(String str) {
        SimpleMqttMessage mqttMessage = new SimpleMqttMessage();
        TextMessageParser.of(start -> {
            String[] qosAndTopic = start.split("[ ]");
            if (qosAndTopic.length == 1) {
                mqttMessage.setTopic(qosAndTopic[0]);
            } else {
                mqttMessage.setTopic(qosAndTopic[1]);
                String qos = qosAndTopic[0].toLowerCase();
                if (qos.length() == 1) {
                    mqttMessage.setQosLevel(Integer.parseInt(qos));
                } else {
                    mqttMessage.setQosLevel(Integer.parseInt(qos.substring(qos.length() - 1)));
                }
            }
        }, (header, value) -> {}, body -> {
            mqttMessage.setPayload(Unpooled.wrappedBuffer((byte[])body.getBody()));
            mqttMessage.setPayloadType(body.getType());
        }, () -> mqttMessage.setPayload(Unpooled.wrappedBuffer((byte[])new byte[0]))).parse(str);
        return mqttMessage;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public int getQosLevel() {
        return this.qosLevel;
    }

    @Override
    public ByteBuf getPayload() {
        return this.payload;
    }

    @Override
    public int getMessageId() {
        return this.messageId;
    }

    @Override
    public boolean isWill() {
        return this.will;
    }

    @Override
    public boolean isDup() {
        return this.dup;
    }

    @Override
    public boolean isRetain() {
        return this.retain;
    }

    @Override
    @Deprecated
    public MessagePayloadType getPayloadType() {
        return this.payloadType;
    }

    @Override
    public MqttProperties getProperties() {
        return this.properties;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setQosLevel(int qosLevel) {
        this.qosLevel = qosLevel;
    }

    public void setPayload(ByteBuf payload) {
        this.payload = payload;
    }

    public void setMessageId(int messageId) {
        this.messageId = messageId;
    }

    public void setWill(boolean will) {
        this.will = will;
    }

    public void setDup(boolean dup) {
        this.dup = dup;
    }

    public void setRetain(boolean retain) {
        this.retain = retain;
    }

    @Deprecated
    public void setPayloadType(MessagePayloadType payloadType) {
        this.payloadType = payloadType;
    }

    public void setProperties(MqttProperties properties) {
        this.properties = properties;
    }

    public SimpleMqttMessage(String topic, String clientId, int qosLevel, ByteBuf payload, int messageId, boolean will, boolean dup, boolean retain, MessagePayloadType payloadType, MqttProperties properties) {
        this.topic = topic;
        this.clientId = clientId;
        this.qosLevel = qosLevel;
        this.payload = payload;
        this.messageId = messageId;
        this.will = will;
        this.dup = dup;
        this.retain = retain;
        this.payloadType = payloadType;
        this.properties = properties;
    }

    public static class SimpleMqttMessageBuilder {
        private String topic;
        private String clientId;
        private int qosLevel;
        private ByteBuf payload;
        private int messageId;
        private boolean will;
        private boolean dup;
        private boolean retain;
        private MessagePayloadType payloadType;
        private MqttProperties properties;

        SimpleMqttMessageBuilder() {
        }

        public SimpleMqttMessageBuilder body(String payload) {
            return this.payload(payload.getBytes());
        }

        public SimpleMqttMessageBuilder body(byte[] payload) {
            return this.payload(Unpooled.wrappedBuffer((byte[])payload));
        }

        public SimpleMqttMessageBuilder payload(String payload) {
            return this.payload(payload.getBytes());
        }

        public SimpleMqttMessageBuilder payload(byte[] payload) {
            return this.payload(Unpooled.wrappedBuffer((byte[])payload));
        }

        public SimpleMqttMessageBuilder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public SimpleMqttMessageBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public SimpleMqttMessageBuilder qosLevel(int qosLevel) {
            this.qosLevel = qosLevel;
            return this;
        }

        public SimpleMqttMessageBuilder payload(ByteBuf payload) {
            this.payload = payload;
            return this;
        }

        public SimpleMqttMessageBuilder messageId(int messageId) {
            this.messageId = messageId;
            return this;
        }

        public SimpleMqttMessageBuilder will(boolean will) {
            this.will = will;
            return this;
        }

        public SimpleMqttMessageBuilder dup(boolean dup) {
            this.dup = dup;
            return this;
        }

        public SimpleMqttMessageBuilder retain(boolean retain) {
            this.retain = retain;
            return this;
        }

        @Deprecated
        public SimpleMqttMessageBuilder payloadType(MessagePayloadType payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        public SimpleMqttMessageBuilder properties(MqttProperties mqttProperties) {
            this.properties = mqttProperties;
            return this;
        }

        public SimpleMqttMessage build() {
            return new SimpleMqttMessage(this.topic, this.clientId, this.qosLevel, this.payload, this.messageId, this.will, this.dup, this.retain, this.payloadType, this.properties == null ? MqttProperties.NO_PROPERTIES : this.properties);
        }

        public String toString() {
            return "SimpleMqttMessage.SimpleMqttMessageBuilder(topic=" + this.topic + ", clientId=" + this.clientId + ", qosLevel=" + this.qosLevel + ", payload=" + this.payload + ", messageId=" + this.messageId + ", will=" + this.will + ", dup=" + this.dup + ", retain=" + this.retain + ", payloadType=" + (Object)((Object)this.payloadType) + ")";
        }
    }
}

