/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.lang;

import java.util.Objects;
import javax.annotation.Nonnull;
import org.jetlinks.core.lang.AbstractSeparatedCharSequence;
import org.jetlinks.core.utils.StringBuilderUtils;

class SeparatedString2
extends AbstractSeparatedCharSequence {
    private final char separator;
    private final CharSequence s1;
    private final CharSequence s2;

    @Override
    public char separator() {
        return this.separator;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public CharSequence get(int index) {
        if (index == 0) {
            return this.s1;
        }
        if (index == 1) {
            return this.s2;
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    @Override
    public int length() {
        return this.s1.length() + this.s2.length() + 1;
    }

    @Override
    public char charAt(int index) {
        int s1Length = this.s1.length();
        if (index < s1Length) {
            return this.s1.charAt(index);
        }
        if (index == s1Length) {
            return this.separator;
        }
        int idx = index - s1Length - 1;
        int s2Length = this.s2.length();
        if (idx < s2Length) {
            return this.s2.charAt(idx);
        }
        throw new StringIndexOutOfBoundsException(index);
    }

    @Override
    @Nonnull
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    @Nonnull
    public String toString() {
        return StringBuilderUtils.buildString(this.s1, Character.valueOf(this.separator), this.s2, (a, b, c, bd) -> bd.append((CharSequence)a).append(b).append((CharSequence)c));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SeparatedString2)) {
            return false;
        }
        SeparatedString2 another = (SeparatedString2)obj;
        if (another.separator() != this.separator()) {
            return false;
        }
        return Objects.equals(this.s2, another.s2) && Objects.equals(this.s1, another.s1);
    }

    public SeparatedString2(char separator, CharSequence s1, CharSequence s2) {
        this.separator = separator;
        this.s1 = s1;
        this.s2 = s2;
    }
}

