/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.lang;

import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

public interface SeparatedCharSequence
extends CharSequence,
Comparable<SeparatedCharSequence>,
Iterable<CharSequence>,
Appendable {
    public char separator();

    public int size();

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public CharSequence get(int var1);

    public SeparatedCharSequence replace(int var1, CharSequence var2);

    @Override
    public SeparatedCharSequence append(char var1);

    @Override
    public SeparatedCharSequence append(CharSequence var1);

    public SeparatedCharSequence append(CharSequence ... var1);

    @Override
    public SeparatedCharSequence append(CharSequence var1, int var2, int var3);

    public SeparatedCharSequence range(int var1, int var2);

    public SeparatedCharSequence intern();

    default public SeparatedCharSequence internInner() {
        return this;
    }

    @Override
    @Nonnull
    default public Iterator<CharSequence> iterator() {
        return new Iterator<CharSequence>(){
            private int index = 0;
            private final int size = SeparatedCharSequence.this.size();

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public CharSequence next() {
                return SeparatedCharSequence.this.get(this.index++);
            }
        };
    }

    @Override
    default public void forEach(Consumer<? super CharSequence> action) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            action.accept(this.get(i));
        }
    }

    default public String[] asStringArray() {
        String[] arr = new String[this.size()];
        for (int i = 0; i < arr.length; ++i) {
            CharSequence c = this.get(i);
            arr[i] = c == null ? null : this.get(i).toString();
        }
        return arr;
    }

    default public boolean contentEquals(CharSequence target) {
        int selfLen;
        if (target instanceof SeparatedCharSequence) {
            int selfSize;
            SeparatedCharSequence t = (SeparatedCharSequence)target;
            if (this.separator() != ((SeparatedCharSequence)target).separator()) {
                return false;
            }
            int targetSize = ((SeparatedCharSequence)target).size();
            if (targetSize != (selfSize = this.size())) {
                return false;
            }
            for (int i = 0; i < targetSize; ++i) {
                if (t.get(i).equals(this.get(i))) continue;
                return false;
            }
            return true;
        }
        int targetLen = target.length();
        if (targetLen != (selfLen = this.length())) {
            return false;
        }
        for (int i = 0; i < targetLen; ++i) {
            if (target.charAt(i) == this.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public String toString();
}

