/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.event;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.netty.buffer.ByteBuf;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.jetlinks.core.NativePayload;
import org.jetlinks.core.Payload;
import org.jetlinks.core.Routable;
import org.jetlinks.core.codec.Decoder;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.core.utils.TopicUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicPayload
implements Payload,
Routable,
Externalizable {
    private static final Logger log = LoggerFactory.getLogger(TopicPayload.class);
    private CharSequence topic;
    private Payload payload;
    private Map<String, Object> headers;

    public TopicPayload() {
    }

    public String getTopic() {
        return this.topic.toString();
    }

    public CharSequence getTopic0() {
        return this.topic;
    }

    public static TopicPayload of(CharSequence topic, Payload payload) {
        return TopicPayload.of(topic, payload, null);
    }

    public static TopicPayload of(String topic, Payload payload) {
        return TopicPayload.of(topic, payload, null);
    }

    private Map<String, Object> getOrCreateHeader() {
        return this.headers != null ? this.headers : (this.headers = new ConcurrentHashMap<String, Object>());
    }

    public Map<String, Object> writableHeaders() {
        return this.getOrCreateHeader();
    }

    public TopicPayload addHeader(String key, Object value) {
        if (key == null || value == null) {
            return this;
        }
        this.getOrCreateHeader().put(key, value);
        return this;
    }

    public TopicPayload addHeader(Map<String, ?> headers) {
        this.getOrCreateHeader().putAll(headers);
        return this;
    }

    public Object getHeader(String key) {
        return this.headers == null ? null : this.headers.get(key);
    }

    public Object removeHeader(String key) {
        return this.headers == null ? null : this.headers.remove(key);
    }

    @Override
    @Nonnull
    public ByteBuf getBody() {
        return this.payload.getBody();
    }

    @Override
    public TopicPayload slice() {
        return TopicPayload.of(this.topic, this.payload.slice());
    }

    @Override
    public boolean release() {
        return true;
    }

    @Override
    public boolean release(int dec) {
        return true;
    }

    protected boolean handleRelease(boolean success) {
        return success;
    }

    protected void deallocate() {
    }

    @Override
    public TopicPayload retain() {
        return this;
    }

    @Override
    public TopicPayload retain(int inc) {
        return this;
    }

    @Override
    public TopicPayload touch(Object o) {
        return this;
    }

    @Override
    public TopicPayload touch() {
        return this;
    }

    @Override
    public int refCnt() {
        return 0;
    }

    public String toString() {
        return "{topic='" + this.topic + '\'' + ", payload=" + this.payload + '}';
    }

    @Override
    public JSONObject bodyToJson(boolean release) {
        return this.payload.bodyToJson(release);
    }

    @Override
    public JSONArray bodyToJsonArray(boolean release) {
        return this.payload.bodyToJsonArray(release);
    }

    @Override
    public String bodyToString() {
        return this.payload.bodyToString();
    }

    @Override
    public String bodyToString(boolean release) {
        return this.payload.bodyToString(release);
    }

    @Override
    public Object decode() {
        return this.payload.decode();
    }

    @Override
    public Object decode(boolean release) {
        return this.payload.decode(release);
    }

    @Override
    public <T> T decode(Class<T> decoder) {
        return this.payload.decode(decoder);
    }

    @Override
    public <T> T decode(Class<T> decoder, boolean release) {
        return this.payload.decode(decoder, release);
    }

    @Override
    public <T> T decode(Decoder<T> decoder) {
        return this.payload.decode(decoder);
    }

    @Override
    public <T> T decode(Decoder<T> decoder, boolean release) {
        return this.payload.decode(decoder, release);
    }

    public Map<String, String> getTopicVars(String pattern) {
        return TopicUtils.getPathVariables(pattern, this.getTopic());
    }

    @Override
    public long hash(Object ... objects) {
        if (this.payload instanceof NativePayload && ((NativePayload)this.payload).getNativeObject() instanceof Routable) {
            return ((Routable)((NativePayload)this.payload).getNativeObject()).hash(objects);
        }
        return Routable.super.hash(objects);
    }

    public void copyRouteKeyToHeader() {
        if (this.payload instanceof NativePayload && ((NativePayload)this.payload).getNativeObject() instanceof Routable) {
            this.addHeader(Headers.routeKey.getKey(), ((Routable)((NativePayload)this.payload).getNativeObject()).routeKey());
        }
    }

    @Override
    public Object routeKey() {
        if (this.payload instanceof NativePayload && ((NativePayload)this.payload).getNativeObject() instanceof Routable) {
            return ((Routable)((NativePayload)this.payload).getNativeObject()).routeKey();
        }
        return this.headers.get(Headers.routeKey.getKey());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeObject(this.topic, out);
        SerializeUtils.writeObject(this.payload, out);
        SerializeUtils.writeKeyValue(this.headers, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.topic = (CharSequence)SerializeUtils.readObjectAs(in);
        this.payload = (Payload)SerializeUtils.readObjectAs(in);
        SerializeUtils.readKeyValue(in, this::addHeader);
    }

    public Payload getPayload() {
        return this.payload;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    private TopicPayload(CharSequence topic, Payload payload, Map<String, Object> headers) {
        this.topic = topic;
        this.payload = payload;
        this.headers = headers;
    }

    public static TopicPayload of(CharSequence topic, Payload payload, Map<String, Object> headers) {
        return new TopicPayload(topic, payload, headers);
    }
}

