/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.config.ConfigStorageManager;
import org.jetlinks.core.defaults.DefaultThing;
import org.jetlinks.core.defaults.DefaultThingTemplate;
import org.jetlinks.core.things.Thing;
import org.jetlinks.core.things.ThingInfo;
import org.jetlinks.core.things.ThingMetadataCodec;
import org.jetlinks.core.things.ThingRpcSupport;
import org.jetlinks.core.things.ThingTemplate;
import org.jetlinks.core.things.ThingTemplateInfo;
import org.jetlinks.core.things.ThingType;
import org.jetlinks.core.things.ThingsConfigKeys;
import org.jetlinks.core.things.ThingsRegistry;
import org.jetlinks.core.things.ThingsRegistrySupport;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleThingsRegistrySupport
implements ThingsRegistrySupport {
    private final ThingType thingType;
    private final Map<String, DefaultThing> thingCache = new ConcurrentHashMap<String, DefaultThing>();
    private final Map<String, DefaultThingTemplate> templateCache = new ConcurrentHashMap<String, DefaultThingTemplate>();
    private final Mono<ConfigStorage> registryInfo;
    private final Mono<ConfigStorage> templateRegistryInfo;
    private final ConfigStorageManager manager;
    private final ThingMetadataCodec metadataCodec;
    private final Function<Thing, ThingRpcSupport> rpcSupportFactory;

    public SimpleThingsRegistrySupport(ThingType thingType, ConfigStorageManager manager, ThingMetadataCodec metadataCodec, Function<Thing, ThingRpcSupport> rpcSupportFactory) {
        this.thingType = thingType;
        this.manager = manager;
        this.metadataCodec = metadataCodec;
        this.rpcSupportFactory = rpcSupportFactory;
        this.registryInfo = manager.getStorage("thing_reg:" + thingType.getId());
        this.templateRegistryInfo = manager.getStorage("thing_temp_reg:" + thingType.getId());
    }

    @Override
    public boolean isSupported(String thingType) {
        return this.thingType.getId().equals(thingType);
    }

    public void checkThingType(String thingType) {
        if (!this.isSupported(thingType)) {
            throw new UnsupportedOperationException("unsupported thing type : " + thingType);
        }
    }

    @Override
    public Mono<Thing> getThing(@Nonnull String thingType, @Nonnull String thingId) {
        this.checkThingType(thingType);
        return this.registryInfo.flatMap(storage -> storage.getConfig(thingId)).switchIfEmpty(Mono.fromRunnable(() -> this.thingCache.remove(thingId))).map(ignore -> this.thingCache.computeIfAbsent(thingId, this::createThing));
    }

    protected DefaultThing createThing(String id) {
        return new DefaultThing(this.thingType, id, this.manager, this.metadataCodec, (ThingsRegistry)this, this.rpcSupportFactory);
    }

    protected DefaultThingTemplate createTemplate(String id) {
        return new DefaultThingTemplate(this.thingType, id, this.manager, this.metadataCodec);
    }

    @Override
    public Mono<Thing> register(@Nonnull String thingType, @Nonnull ThingInfo info) {
        this.checkThingType(thingType);
        DefaultThing thing = this.createThing(info.getId());
        HashMap configs = Maps.newHashMap();
        Optional.ofNullable(info.getConfiguration()).ifPresent(configs::putAll);
        Optional.ofNullable(info.getMetadata()).ifPresent(conf -> configs.put(ThingsConfigKeys.metadata.getKey(), conf));
        Optional.ofNullable(info.getVersion()).ifPresent(conf -> configs.put(ThingsConfigKeys.version.getKey(), conf));
        Optional.ofNullable(info.getTemplateId()).ifPresent(conf -> configs.put(ThingsConfigKeys.templateId.getKey(), conf));
        Optional.ofNullable(info.getName()).ifPresent(conf -> configs.put(ThingsConfigKeys.name.getKey(), conf));
        return this.registryInfo.flatMap(storage -> storage.setConfig(info.getId(), System.currentTimeMillis())).then(thing.setConfigs(configs)).thenReturn((Object)thing);
    }

    @Override
    public Mono<ThingTemplate> getTemplate(@Nonnull String thingType, @Nonnull String templateId) {
        this.checkThingType(thingType);
        return this.templateRegistryInfo.flatMap(storage -> storage.getConfig(templateId)).switchIfEmpty(Mono.fromRunnable(() -> this.templateCache.remove(templateId))).map(ignore -> this.templateCache.computeIfAbsent(templateId, this::createTemplate));
    }

    @Override
    public Mono<Void> unregisterThing(@Nonnull String thingType, @Nonnull String thingId) {
        this.checkThingType(thingType);
        return Flux.merge((Publisher[])new Publisher[]{this.getThing(thingType, thingId).flatMap(thing -> {
            this.thingCache.remove(thingId);
            if (thing.isWrapperFor(DefaultThing.class)) {
                return thing.unwrap(DefaultThing.class).getReactiveStorage().flatMap(ConfigStorage::clear);
            }
            return Mono.empty();
        }), this.registryInfo.flatMap(storage -> storage.remove(thingId))}).then();
    }

    @Override
    public Mono<ThingTemplate> register(@Nonnull String thingType, @Nonnull ThingTemplateInfo info) {
        this.checkThingType(thingType);
        DefaultThingTemplate thing = this.createTemplate(info.getId());
        HashMap<String, Object> configs = new HashMap<String, Object>();
        Optional.ofNullable(info.getConfiguration()).ifPresent(configs::putAll);
        Optional.ofNullable(info.getMetadata()).ifPresent(conf -> configs.put(ThingsConfigKeys.metadata.getKey(), conf));
        Optional.ofNullable(info.getVersion()).ifPresent(conf -> configs.put(ThingsConfigKeys.version.getKey(), conf));
        Optional.ofNullable(info.getType()).ifPresent(conf -> configs.put(ThingsConfigKeys.type.getKey(), conf));
        Optional.ofNullable(info.getName()).ifPresent(conf -> configs.put(ThingsConfigKeys.name.getKey(), conf));
        return this.templateRegistryInfo.flatMap(storage -> storage.setConfig(info.getId(), System.currentTimeMillis())).then(thing.setConfigs(configs)).thenReturn((Object)thing);
    }

    @Override
    public Mono<Void> unregisterTemplate(@Nonnull String thingType, @Nonnull String thingId) {
        this.checkThingType(thingType);
        return Flux.merge((Publisher[])new Publisher[]{Mono.justOrEmpty((Object)this.templateCache.remove(thingId)).flatMap(DefaultThingTemplate::getReactiveStorage).flatMap(ConfigStorage::clear), this.templateRegistryInfo.flatMap(storage -> storage.remove(thingId))}).then();
    }
}

