/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.defaults;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.Value;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.config.ConfigStorage;
import org.jetlinks.core.config.ConfigStorageManager;
import org.jetlinks.core.config.StorageConfigurable;
import org.jetlinks.core.defaults.DefaultDeviceMessageSender;
import org.jetlinks.core.device.AuthenticationRequest;
import org.jetlinks.core.device.AuthenticationResponse;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceMessageSender;
import org.jetlinks.core.device.DeviceOperationBroker;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.DeviceStateChecker;
import org.jetlinks.core.device.DeviceStateInfo;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.exception.ProductNotActivatedException;
import org.jetlinks.core.message.ChildDeviceMessage;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.DisconnectDeviceMessage;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.message.interceptor.DeviceMessageSenderInterceptor;
import org.jetlinks.core.message.state.DeviceStateCheckMessage;
import org.jetlinks.core.message.state.DeviceStateCheckMessageReply;
import org.jetlinks.core.metadata.CompositeDeviceMetadata;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.SimpleDeviceMetadata;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingRpcSupport;
import org.jetlinks.core.things.ThingRpcSupportChain;
import org.jetlinks.core.utils.IdUtils;
import org.jetlinks.core.utils.Reactors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class DefaultDeviceOperator
implements DeviceOperator,
StorageConfigurable {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeviceOperator.class);
    public static final DeviceStateChecker DEFAULT_STATE_CHECKER = device -> DefaultDeviceOperator.checkState0((DefaultDeviceOperator)device);
    private static final ConfigKey<Long> lastMetadataTimeKey = ConfigKey.of("lst_metadata_time", "\u6700\u540e\u7269\u6a21\u578b\u66f4\u65b0\u65f6\u95f4", Long.class);
    private static final ConfigKey<Byte> stateKey = ConfigKey.of("state", "\u72b6\u6001", Byte.class);
    private static final ConfigKey<Long> onlineTimeKey = ConfigKey.of("onlineTime", "\u4e0a\u7ebf\u65f6\u95f4", Long.class);
    private static final ConfigKey<Long> offlineTimeKey = ConfigKey.of("offlineTime", "\u79bb\u7ebf\u65f6\u95f4", Long.class);
    static final List<String> productIdAndVersionKey = Arrays.asList(DeviceConfigKey.productId.getKey(), DeviceConfigKey.productVersion.getKey());
    private static final AtomicReferenceFieldUpdater<DefaultDeviceOperator, DeviceMetadata> METADATA_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultDeviceOperator.class, DeviceMetadata.class, "metadataCache");
    private static final AtomicLongFieldUpdater<DefaultDeviceOperator> METADATA_TIME_UPDATER = AtomicLongFieldUpdater.newUpdater(DefaultDeviceOperator.class, "lastMetadataTime");
    private static final DeviceMetadata NON_METADATA = new SimpleDeviceMetadata();
    private static final boolean FORCE_CHECK_STATE_PARENT = Boolean.getBoolean("jetlinks.device.force-check-state-from-parent");
    private final String id;
    private final DeviceOperationBroker handler;
    private final DeviceRegistry registry;
    private final DeviceMessageSender messageSender;
    private final Mono<ConfigStorage> storageMono;
    private final Mono<ProtocolSupport> protocolSupportMono;
    private final Mono<DeviceMetadata> metadataMono;
    private final DeviceStateChecker stateChecker;
    private final Mono<DeviceProductOperator> parent;
    private volatile long lastMetadataTime = -1L;
    private volatile DeviceMetadata metadataCache;
    private ThingRpcSupportChain rpcChain;
    private static final List<String> stateCacheKeys = Arrays.asList(stateKey.getKey(), DeviceConfigKey.parentGatewayId.getKey(), DeviceConfigKey.selfManageState.getKey(), DeviceConfigKey.connectionServerId.getKey());

    public DefaultDeviceOperator(String id, ProtocolSupports supports, ConfigStorageManager storageManager, DeviceOperationBroker handler, DeviceRegistry registry) {
        this(id, supports, storageManager, handler, registry, DeviceMessageSenderInterceptor.DO_NOTING);
    }

    public DefaultDeviceOperator(String id, ProtocolSupports supports, ConfigStorageManager storageManager, DeviceOperationBroker handler, DeviceRegistry registry, DeviceMessageSenderInterceptor interceptor) {
        this(id, supports, storageManager, handler, registry, interceptor, DEFAULT_STATE_CHECKER);
    }

    public DefaultDeviceOperator(String id, ProtocolSupports supports, ConfigStorageManager storageManager, DeviceOperationBroker handler, DeviceRegistry registry, DeviceMessageSenderInterceptor interceptor, DeviceStateChecker deviceStateChecker) {
        this.id = id;
        this.registry = registry;
        this.handler = handler;
        this.messageSender = new DefaultDeviceMessageSender(handler, this, registry, interceptor);
        this.storageMono = storageManager.getStorage("device:" + id);
        this.parent = this.getReactiveStorage().flatMap(store -> store.getConfigs(productIdAndVersionKey)).flatMap(productIdAndVersion -> {
            String _productId = productIdAndVersion.getString(DeviceConfigKey.productId.getKey(), (String)null);
            String _version = productIdAndVersion.getString(DeviceConfigKey.productVersion.getKey(), (String)null);
            return registry.getProduct(_productId, _version);
        });
        this.protocolSupportMono = this.getSelfConfig(DeviceConfigKey.protocol).flatMap(supports::getProtocol).switchIfEmpty(this.parent.flatMap(DeviceProductOperator::getProtocol));
        this.stateChecker = deviceStateChecker;
        this.metadataMono = Mono.zip(this.productMetadata(), (Mono)this.selfMetadata().defaultIfEmpty((Object)NON_METADATA), (product, self) -> {
            if (self == NON_METADATA) {
                return product;
            }
            return new CompositeDeviceMetadata((ThingMetadata)product, (ThingMetadata)self);
        });
    }

    private Mono<DeviceMetadata> selfMetadata() {
        return this.getSelfConfig(lastMetadataTimeKey).flatMap(i -> {
            if (i.equals(this.lastMetadataTime) && this.metadataCache != null) {
                return Mono.just((Object)this.metadataCache);
            }
            METADATA_TIME_UPDATER.set(this, (long)i);
            return Mono.zip(this.getSelfConfig(DeviceConfigKey.metadata), this.protocolSupportMono).flatMap(tp2 -> ((ProtocolSupport)tp2.getT2()).getMetadataCodec().decode((String)tp2.getT1()).doOnNext(metadata -> METADATA_UPDATER.set(this, (DeviceMetadata)metadata)));
        });
    }

    private Mono<DeviceMetadata> productMetadata() {
        return this.getParent().switchIfEmpty(Mono.defer(this::onProductNonexistent)).flatMap(DeviceProductOperator::getMetadata);
    }

    private Mono<DeviceProductOperator> onProductNonexistent() {
        return this.getReactiveStorage().flatMap(store -> store.getConfig(DeviceConfigKey.productId.getKey())).map(Value::asString).flatMap(productId -> Mono.error((Throwable)((Object)new ProductNotActivatedException((String)productId))));
    }

    @Override
    public Mono<ConfigStorage> getReactiveStorage() {
        return this.storageMono;
    }

    @Override
    public String getDeviceId() {
        return this.id;
    }

    @Override
    public Mono<String> getConnectionServerId() {
        return this.getSelfConfig(DeviceConfigKey.connectionServerId.getKey()).map(Value::asString);
    }

    @Override
    public Mono<String> getSessionId() {
        return this.getSelfConfig(DeviceConfigKey.sessionId.getKey()).map(Value::asString);
    }

    @Override
    public Mono<String> getAddress() {
        return this.getSelfConfig("address").map(Value::asString);
    }

    @Override
    public Mono<Void> setAddress(String address) {
        return this.setConfig("address", address).then();
    }

    @Override
    public Mono<Boolean> putState(byte state) {
        return this.setConfig("state", (Object)state);
    }

    @Override
    public Mono<Byte> getState() {
        return this.getSelfConfig(stateKey).defaultIfEmpty((Object)0);
    }

    private Mono<Byte> doCheckState() {
        return Mono.defer(() -> this.getSelfConfigs(stateCacheKeys).flatMap(values -> {
            String server = values.getValue(DeviceConfigKey.connectionServerId).orElse(null);
            Byte state = values.getValue(stateKey).orElse((byte)0);
            Mono checker = this.handler.getDeviceState(server, Collections.singletonList(this.id)).map(DeviceStateInfo::getState).singleOrEmpty().defaultIfEmpty((Object)state);
            if (!StringUtils.hasText((String)server)) {
                String parentGatewayId = values.getValue(DeviceConfigKey.parentGatewayId).orElse(null);
                if (this.getDeviceId().equals(parentGatewayId)) {
                    log.warn(LocaleUtils.resolveMessage((String)"validation.parent_id_and_id_can_not_be_same", (String)parentGatewayId, (Object[])new Object[0]));
                    return checker;
                }
                boolean isSelfManageState = values.getValue(DeviceConfigKey.selfManageState).orElse(false);
                if (StringUtils.hasText((String)parentGatewayId) && isSelfManageState) {
                    return this.registry.getDevice(parentGatewayId).filterWhen(parent -> FORCE_CHECK_STATE_PARENT ? Reactors.ALWAYS_TRUE : parent.isOnline()).flatMap(parent -> this.checkStateFromParent((DeviceOperator)parent, (Mono<Byte>)checker)).switchIfEmpty(checker);
                }
            }
            return checker;
        }));
    }

    private Mono<Byte> checkStateFromParent(DeviceOperator parentDevice, Mono<Byte> defaultState) {
        return parentDevice.messageSender().send((DeviceMessage)((Object)ChildDeviceMessage.create(parentDevice.getDeviceId(), DeviceStateCheckMessage.create(this.getDeviceId())).addHeader((HeaderKey)Headers.timeout, (Object)5000L))).singleOrEmpty().map(msg -> {
            if (msg.getChildDeviceMessage() instanceof DeviceStateCheckMessageReply) {
                return ((DeviceStateCheckMessageReply)msg.getChildDeviceMessage()).getState();
            }
            log.warn("State check return error {}", msg);
            return (byte)1;
        }).onErrorResume(err -> {
            if (err instanceof DeviceOperationException) {
                ErrorCode code = ((DeviceOperationException)err).getCode();
                if (code == ErrorCode.CLIENT_OFFLINE) {
                    return Mono.just((Object)-1);
                }
                if (code == ErrorCode.UNSUPPORTED_MESSAGE) {
                    return Mono.just((Object)1);
                }
            }
            return defaultState;
        });
    }

    @Override
    public Mono<Byte> checkState() {
        return Mono.zip((Mono)this.stateChecker.checkState(this).switchIfEmpty(Mono.defer(() -> DEFAULT_STATE_CHECKER.checkState(this))).defaultIfEmpty((Object)1), this.getState()).flatMap(tp2 -> {
            byte old;
            byte newer = (Byte)tp2.getT1();
            if (newer != (old = ((Byte)tp2.getT2()).byteValue())) {
                log.info("device[{}] state changed from {} to {}", new Object[]{this.getDeviceId(), old, newer});
                HashMap<String, Object> configs = new HashMap<String, Object>();
                configs.put("state", newer);
                if (newer == 1) {
                    configs.put("onlineTime", System.currentTimeMillis());
                } else if (newer == -1) {
                    configs.put("offlineTime", System.currentTimeMillis());
                }
                return this.setConfigs(configs).thenReturn((Object)newer);
            }
            return Mono.just((Object)newer);
        }).doOnError(err -> log.warn("check device [{}] state error", (Object)this.getDeviceId(), err));
    }

    @Override
    public Mono<Long> getOnlineTime() {
        return this.getSelfConfig(onlineTimeKey).switchIfEmpty(Mono.defer(() -> this.getSelfConfig(DeviceConfigKey.parentGatewayId).flatMap(this.registry::getDevice).flatMap(DeviceOperator::getOnlineTime)));
    }

    @Override
    public Mono<Long> getOfflineTime() {
        return this.getSelfConfig(offlineTimeKey).switchIfEmpty(Mono.defer(() -> this.getSelfConfig(DeviceConfigKey.parentGatewayId).flatMap(this.registry::getDevice).flatMap(DeviceOperator::getOfflineTime)));
    }

    @Override
    public Mono<Boolean> offline() {
        return this.setConfigs(DeviceConfigKey.connectionServerId.value(""), DeviceConfigKey.sessionId.value(""), ConfigKey.of("offlineTime").value(System.currentTimeMillis()), stateKey.value((byte)-1)).doOnError(err -> log.error("offline device error", err));
    }

    @Override
    public Mono<Boolean> online(String serverId, String sessionId, String address) {
        return this.setConfigs(DeviceConfigKey.connectionServerId.value(serverId), DeviceConfigKey.sessionId.value(sessionId), ConfigKey.of("address").value(address), ConfigKey.of("onlineTime").value(System.currentTimeMillis()), stateKey.value((byte)1)).doOnError(err -> log.error("online device error", err));
    }

    @Override
    public Mono<Boolean> online(String serverId, String address, long onlineTime) {
        HashMap configs = Maps.newHashMapWithExpectedSize((int)4);
        configs.put(DeviceConfigKey.connectionServerId.getKey(), serverId);
        configs.put(stateKey.getKey(), (byte)1);
        if (null != address) {
            configs.put("address", address);
        }
        if (onlineTime > 0L) {
            configs.put("onlineTime", onlineTime);
        }
        return this.setConfigs(configs).doOnError(err -> log.error("online device error", err));
    }

    @Override
    public Mono<Value> getSelfConfig(String key) {
        return this.getConfig(key, false);
    }

    @Override
    public Mono<Values> getSelfConfigs(Collection<String> keys) {
        return this.getConfigs(keys, false);
    }

    @Override
    public Mono<Boolean> disconnect() {
        DisconnectDeviceMessage disconnect = new DisconnectDeviceMessage();
        disconnect.setDeviceId(this.getDeviceId());
        disconnect.setMessageId(IdUtils.newUUID());
        return this.messageSender().send(Mono.just((Object)disconnect)).next().map(DeviceMessageReply::isSuccess);
    }

    @Override
    public Mono<AuthenticationResponse> authenticate(AuthenticationRequest request) {
        return this.getProtocol().flatMap(protocolSupport -> protocolSupport.authenticate(request, this));
    }

    @Override
    public Mono<DeviceMetadata> getMetadata() {
        return this.metadataMono;
    }

    public Mono<DeviceProductOperator> getParent() {
        return this.parent;
    }

    @Override
    public Mono<ProtocolSupport> getProtocol() {
        return this.protocolSupportMono;
    }

    @Override
    public Mono<DeviceProductOperator> getProduct() {
        return this.getParent();
    }

    @Override
    public DeviceMessageSender messageSender() {
        return this.messageSender;
    }

    @Override
    public Mono<Boolean> updateMetadata(String metadata) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(DeviceConfigKey.metadata.getKey(), metadata);
        return this.setConfigs(configs);
    }

    @Override
    public Mono<Void> resetMetadata() {
        METADATA_UPDATER.set(this, null);
        METADATA_TIME_UPDATER.set(this, -1L);
        return this.removeConfigs(DeviceConfigKey.metadata, lastMetadataTimeKey).then(this.getProtocol().flatMap(support -> support.onDeviceMetadataChanged(this)));
    }

    @Override
    public Mono<Boolean> updateMetadata(ThingMetadata metadata) {
        if (metadata instanceof DeviceMetadata) {
            return this.getProtocol().flatMap(protocol -> protocol.getMetadataCodec().encode((DeviceMetadata)metadata)).flatMap(this::updateMetadata);
        }
        return Mono.just((Object)false);
    }

    @Override
    public Mono<Boolean> setConfigs(Map<String, Object> conf) {
        HashMap<String, Object> configs = new HashMap<String, Object>(conf);
        if (conf.containsKey(DeviceConfigKey.metadata.getKey())) {
            this.lastMetadataTime = System.currentTimeMillis();
            configs.put(lastMetadataTimeKey.getKey(), this.lastMetadataTime);
            return StorageConfigurable.super.setConfigs(configs).doOnNext(suc -> {
                this.metadataCache = null;
            }).then(this.getProtocol().flatMap(support -> support.onDeviceMetadataChanged(this))).thenReturn((Object)true);
        }
        return StorageConfigurable.super.setConfigs(configs);
    }

    private static Mono<Byte> checkState0(DefaultDeviceOperator operator) {
        return operator.getProtocol().flatMap(ProtocolSupport::getStateChecker).flatMap(deviceStateChecker -> deviceStateChecker.checkState(operator)).switchIfEmpty(operator.doCheckState());
    }

    @Override
    public ThingRpcSupport rpc() {
        return msg -> this.getProtocol().flatMapMany(support -> {
            ThingRpcSupport ftemp;
            ThingRpcSupport temp = m -> this.messageSender.send(this.convertToDeviceMessage(msg));
            ThingRpcSupportChain chain = support.getRpcChain();
            if (chain != null) {
                ftemp = temp;
                temp = m -> chain.call(m, ftemp);
            }
            if (this.rpcChain != null) {
                ftemp = temp;
                temp = m -> this.rpcChain.call(msg, ftemp);
            }
            return temp.call(msg);
        });
    }

    private DeviceMessage convertToDeviceMessage(ThingMessage message) {
        if (message instanceof DeviceMessage) {
            return (DeviceMessage)message;
        }
        JSONObject msg = message.toJson();
        msg.remove((Object)"thingId");
        msg.remove((Object)"thingType");
        msg.put("deviceId", (Object)message.getThingId());
        return MessageType.convertMessage((Map<String, Object>)msg).filter(DeviceMessage.class::isInstance).map(DeviceMessage.class::cast).orElseThrow(() -> new UnsupportedOperationException("unsupported message type " + (Object)((Object)message.getMessageType())));
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setRpcChain(ThingRpcSupportChain rpcChain) {
        this.rpcChain = rpcChain;
    }
}

