/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.command;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.metadata.FunctionMetadata;

class LambdaCommandHandler<C extends Command<R>, R>
implements CommandHandler<C, R> {
    private final Supplier<FunctionMetadata> description;
    private final BiFunction<C, CommandSupport, R> handler;
    private final Supplier<C> commandBuilder;

    @Override
    public R handle(@Nonnull C command, @Nonnull CommandSupport support) {
        return this.handler.apply(command, support);
    }

    @Override
    @Nonnull
    public C createCommand() {
        return (C)((Command)this.commandBuilder.get());
    }

    @Override
    public FunctionMetadata getMetadata() {
        return this.description.get();
    }

    public String toString() {
        return String.valueOf(this.description.get());
    }

    public LambdaCommandHandler(Supplier<FunctionMetadata> description, BiFunction<C, CommandSupport, R> handler, Supplier<C> commandBuilder) {
        this.description = description;
        this.handler = handler;
        this.commandBuilder = commandBuilder;
    }
}

