/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.command;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.MapUtils;
import org.jetlinks.core.Wrapper;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandException;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.command.StreamCommand;
import org.jetlinks.core.metadata.FunctionMetadata;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface CommandSupport
extends Wrapper {
    @Nonnull
    public <R> R execute(@Nonnull Command<R> var1);

    default public Flux<Object> executeToFlux(Command<?> command) {
        return CommandUtils.convertResponseToFlux(this.execute(command), command);
    }

    default public Flux<Object> executeToFlux(String commandId, Map<String, Object> parameters) {
        return this.createCommandAsync(commandId).flatMapMany(cmd -> this.executeToFlux(cmd.with(parameters)));
    }

    default public Flux<Object> executeToFlux(String commandId, Map<String, Object> parameters, Flux<Object> stream) {
        return this.createCommandAsync(commandId).flatMapMany(cmd -> {
            if (!cmd.isWrapperFor(StreamCommand.class)) {
                return Flux.error((Throwable)((Object)new CommandException.NoStackTrace(this, (Command<?>)cmd, "error.unsupported_command", null, cmd.getCommandId())));
            }
            StreamCommand command = cmd.unwrap(StreamCommand.class);
            command.withStream(stream.mapNotNull(command::convertStreamValue));
            return this.executeToFlux(cmd.with(parameters));
        });
    }

    default public Mono<Object> executeToMono(Command<?> command) {
        return CommandUtils.convertResponseToMono(this.execute(command), command);
    }

    default public Mono<Object> executeToMono(String commandId, Map<String, Object> parameters) {
        return this.createCommandAsync(commandId).flatMap(cmd -> this.executeToMono(cmd.with(parameters)));
    }

    default public <R, C extends Command<R>> C createCommand(String commandId) {
        throw new CommandException.NoStackTrace(this, null, "error.unsupported_command", null, commandId);
    }

    default public <R, C extends Command<R>> Mono<C> createCommandAsync(String commandId) {
        return Mono.fromSupplier(() -> this.createCommand(commandId));
    }

    default public Flux<FunctionMetadata> getCommandMetadata() {
        return Flux.empty();
    }

    default public Mono<FunctionMetadata> getCommandMetadata(String commandId) {
        return this.getCommandMetadata().filter(cmd -> Objects.equals(cmd.getId(), commandId)).singleOrEmpty();
    }

    default public Mono<FunctionMetadata> getCommandMetadata(@Nonnull String commandId, @Nullable Map<String, Object> parameters) {
        if (MapUtils.isEmpty(parameters)) {
            return this.getCommandMetadata(commandId);
        }
        return this.createCommandAsync(commandId).flatMap(cmd -> this.getCommandMetadata(cmd.with(parameters)));
    }

    default public Mono<FunctionMetadata> getCommandMetadata(Command<?> command) {
        return this.getCommandMetadata(command.getCommandId());
    }

    default public Mono<Boolean> commandIsSupported(Command<?> cmd) {
        return this.commandIsSupported(cmd.getCommandId());
    }

    default public Mono<Boolean> commandIsSupported(Class<? extends Command<?>> cmd) {
        return this.commandIsSupported(CommandUtils.getCommandIdByType(cmd));
    }

    default public Mono<Boolean> commandIsSupported(String commandId) {
        return this.getCommandMetadata(commandId).hasElement();
    }
}

