/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.command;

import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetlinks.core.command.AbstractCommand;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.command.GenericInputCommand;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimpleFunctionMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.utils.MetadataUtils;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class CommandMetadataResolver {
    public static List<PropertyMetadata> resolveInputs(ResolvableType type) {
        DataType objectType;
        Class clazz = type.toClass();
        if (Command.class.isAssignableFrom(clazz)) {
            Class<?> inputSpec = CommandMetadataResolver.findInputSpec(clazz);
            if (inputSpec != null) {
                ResolvableType inputType;
                if (GenericInputCommand.class.isAssignableFrom(clazz) && GenericInputCommand.InputSpec.class.isAssignableFrom(inputSpec) && (inputType = ResolvableType.forClass(inputSpec)).getGenerics().length > 0) {
                    return CommandMetadataResolver.resolveInputs(ResolvableType.forClassWithGenerics(inputSpec, (ResolvableType[])new ResolvableType[]{type.as(GenericInputCommand.class).getGeneric(new int[]{0})}));
                }
                return CommandMetadataResolver.resolveInputs(ResolvableType.forClass(inputSpec));
            }
            if (GenericInputCommand.class.isAssignableFrom(clazz)) {
                return CommandMetadataResolver.resolveInputs(type.as(GenericInputCommand.class).getGeneric(new int[]{0}));
            }
            if (AbstractCommand.class.isAssignableFrom(clazz)) {
                LinkedHashMap inputsMap = new LinkedHashMap();
                HashMap indexMap = new HashMap();
                ReflectionUtils.doWithMethods((Class)clazz, method -> {
                    PropertyMetadata prop = CommandMetadataResolver.tryResolveProperty(clazz, method);
                    if (prop != null) {
                        Order order = (Order)AnnotationUtils.findAnnotation((Method)method, Order.class);
                        if (order != null) {
                            indexMap.put(prop.getId(), order.value());
                        }
                        inputsMap.putIfAbsent(method.getName(), prop);
                    }
                });
                ArrayList list = Lists.newArrayList(inputsMap.values());
                list.sort(Comparator.comparingLong(m -> indexMap.getOrDefault(m.getId(), Integer.MAX_VALUE).intValue()));
                return list;
            }
        }
        if ((objectType = MetadataUtils.parseType(type)) instanceof ObjectType) {
            return ((ObjectType)objectType).getProperties();
        }
        return Collections.emptyList();
    }

    public static DataType resolveOutput(ResolvableType type) {
        Class clazz = type.toClass();
        if (Command.class.isAssignableFrom(clazz)) {
            return MetadataUtils.parseType(CommandUtils.getCommandResponseDataType(type.as(Command.class).getGeneric(new int[]{0})));
        }
        return MetadataUtils.parseType(CommandUtils.getCommandResponseDataType(type));
    }

    public static FunctionMetadata resolve(Class<?> commandClazz) {
        return CommandMetadataResolver.resolve(ResolvableType.forClass(commandClazz));
    }

    public static FunctionMetadata resolve(Class<?> commandClazz, Class<?> outputClazz) {
        return CommandMetadataResolver.resolve(ResolvableType.forClass(commandClazz), ResolvableType.forClass(outputClazz));
    }

    public static FunctionMetadata resolve(ResolvableType commandClazz) {
        return CommandMetadataResolver.resolve(commandClazz, commandClazz);
    }

    public static FunctionMetadata resolve(ResolvableType commandClazz, ResolvableType outClazz) {
        SimpleFunctionMetadata metadata = new SimpleFunctionMetadata();
        Class clazz = commandClazz.toClass();
        metadata.setId(CommandUtils.getCommandIdByType(clazz));
        Schema schema = (Schema)AnnotationUtils.findAnnotation((Class)clazz, Schema.class);
        if (schema != null) {
            metadata.setName(StringUtils.hasText((String)schema.title()) ? schema.title() : schema.description());
            metadata.setDescription(schema.description());
        } else {
            metadata.setName(metadata.getId());
        }
        metadata.setInputs(CommandMetadataResolver.resolveInputs(commandClazz));
        metadata.setOutput(CommandMetadataResolver.resolveOutput(outClazz));
        metadata.setExpands(MetadataUtils.parseExpands(clazz));
        return metadata;
    }

    static PropertyMetadata tryResolveProperty(Class<?> clazz, Method method) {
        String name;
        Schema schema = (Schema)AnnotationUtils.findAnnotation((Method)method, Schema.class);
        if (null == schema) {
            return null;
        }
        if (method.getReturnType() == Void.class || method.getParameterCount() != 0) {
            return null;
        }
        if (StringUtils.hasText((String)schema.name())) {
            name = schema.name();
        } else {
            String methodName = method.getName();
            int nameIndex = 0;
            if (methodName.startsWith("get")) {
                nameIndex = 3;
            }
            char[] propertyName = methodName.substring(nameIndex).toCharArray();
            propertyName[0] = Character.toLowerCase(propertyName[0]);
            name = new String(propertyName);
        }
        SimplePropertyMetadata prop = new SimplePropertyMetadata();
        prop.setId(name);
        prop.setDescription(schema.description());
        prop.setName(StringUtils.hasText((String)schema.title()) ? schema.title() : prop.getDescription());
        prop.setValueType(MetadataUtils.parseType(ResolvableType.forMethodReturnType((Method)method, clazz)));
        prop.setExpands(MetadataUtils.parseExpands(method));
        prop.expand("hidden", (Object)schema.hidden());
        return prop;
    }

    private static Class<?> findInputSpec(Class<?> owner) {
        while (Command.class.isAssignableFrom(owner)) {
            try {
                return owner.getClassLoader().loadClass(owner.getName() + "$InputSpec");
            }
            catch (ClassNotFoundException e) {
                owner = owner.getSuperclass();
            }
        }
        return null;
    }
}

