/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.command;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.Wrapper;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.utils.ConverterUtils;

public interface Command<Response>
extends Wrapper,
Serializable {
    default public String getCommandId() {
        return CommandUtils.getCommandIdByType(this.getClass());
    }

    default public Command<Response> with(String key, Object value) {
        return this.with(Collections.singletonMap(key, value));
    }

    default public Command<Response> with(Map<String, Object> parameters) {
        if (null != parameters) {
            return (Command)FastBeanCopier.copy(parameters, (Object)this, (String[])new String[0]);
        }
        return this;
    }

    default public Command<Response> with(Object parameterObject) {
        if (parameterObject instanceof Map) {
            return this.with((Map)parameterObject);
        }
        if (parameterObject instanceof Command) {
            return this.with(((Command)parameterObject).asMap());
        }
        if (parameterObject instanceof Jsonable) {
            return this.with((Map<String, Object>)((Jsonable)parameterObject).toJson());
        }
        if (parameterObject != null) {
            return (Command)FastBeanCopier.copy((Object)parameterObject, (Object)this, (String[])new String[0]);
        }
        return this;
    }

    default public <T> T getOrNull(String key, Type type) {
        return ConverterUtils.convert(FastBeanCopier.getProperty((Object)this, (String)key), type);
    }

    default public <T> T getOrNull(String key, Class<T> type) {
        return this.getOrNull(key, (Type)type);
    }

    default public void validate() {
    }

    default public Object createResponseData() {
        return CommandUtils.getCommandResponseDataType(this).toClass().newInstance();
    }

    default public Object createResponseData(Object value) {
        return CommandUtils.convertData(CommandUtils.getCommandResponseDataType(this), value);
    }

    default public Map<String, Object> asMap() {
        return (Map)FastBeanCopier.copy((Object)this, new HashMap(), (String[])new String[0]);
    }

    default public <T> T as(Type type) {
        return ConverterUtils.convert((Object)this, type);
    }
}

