/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.command;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandException;
import org.jetlinks.core.command.CommandHandler;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.command.CommandUtils;
import org.jetlinks.core.command.ExecutableCommand;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.utils.Reactors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractCommandSupport
implements CommandSupport {
    protected final Map<Object, CommandHandler<Command<?>, ?>> handlers = new ConcurrentHashMap();

    protected <C extends Command<R>, R> void registerHandler(CommandHandler<C, R> handler) {
        this.registerHandler(handler.createCommand().getCommandId(), handler);
    }

    protected <C extends Command<R>, R> void registerHandler(Class<C> type, CommandHandler<C, R> handler) {
        FunctionMetadata metadata = handler.getMetadata();
        this.handlers.put(type, handler);
        if (null != metadata) {
            this.registerHandler(metadata.getId(), handler);
        }
    }

    protected <C extends Command<R>, R> void registerHandler(String id, CommandHandler<C, R> handler) {
        this.handlers.put(id, handler);
    }

    @Override
    @Nonnull
    public <R> R execute(@Nonnull Command<R> command) {
        if (command instanceof ExecutableCommand) {
            return (R)((ExecutableCommand)command).execute(this);
        }
        CommandHandler<Command<?>, ?> handler = this.handlers.get(command.getCommandId());
        if (null != handler) {
            Object response = handler.handle(command, this);
            return (R)response;
        }
        return this.executeUndefinedCommand(command);
    }

    @Override
    public <R, C extends Command<R>> C createCommand(String commandId) {
        CommandHandler<Command<?>, ?> handler = this.handlers.get(commandId);
        if (null != handler) {
            Command<?> cmd = handler.createCommand();
            return (C)cmd;
        }
        return this.createUndefinedCommand(commandId);
    }

    @Override
    public Flux<FunctionMetadata> getCommandMetadata() {
        return Flux.fromIterable(this.handlers.values()).distinct().mapNotNull(handler -> Optional.ofNullable(handler.getMetadata()).map(m -> CommandUtils.wrapMetadata(handler.createCommand(), m)).orElse(null));
    }

    @Override
    public Mono<FunctionMetadata> getCommandMetadata(String commandId) {
        return Mono.justOrEmpty(this.getRegisteredMetadata(commandId));
    }

    @Override
    public Mono<FunctionMetadata> getCommandMetadata(Command<?> command) {
        CommandHandler<Command<?>, ?> handler = this.handlers.get(command.getCommandId());
        if (handler != null) {
            return handler.getMetadata(command).map(m -> CommandUtils.wrapMetadata(handler.createCommand(), m));
        }
        return Mono.empty();
    }

    @Override
    public Mono<FunctionMetadata> getCommandMetadata(@Nonnull String commandId, @Nullable Map<String, Object> parameters) {
        CommandHandler<Command<?>, ?> handler = this.handlers.get(commandId);
        if (handler != null) {
            return handler.getMetadata(handler.createCommand().with(parameters)).map(m -> CommandUtils.wrapMetadata(handler.createCommand(), m));
        }
        return Mono.empty();
    }

    public Optional<FunctionMetadata> getRegisteredMetadata(String commandId) {
        CommandHandler<Command<?>, ?> handler = this.handlers.get(commandId);
        if (handler != null) {
            return Optional.ofNullable(handler.getMetadata()).map(m -> CommandUtils.wrapMetadata(handler.createCommand(), m));
        }
        return Optional.empty();
    }

    @Override
    public Mono<Boolean> commandIsSupported(String commandId) {
        return this.commandIsSupported0(commandId) ? Reactors.ALWAYS_TRUE : Reactors.ALWAYS_FALSE;
    }

    boolean commandIsSupported0(String commandId) {
        return this.handlers.containsKey(commandId);
    }

    protected <R, C extends Command<R>> C createUndefinedCommand(String commandId) {
        throw new CommandException.NoStackTrace(this, null, "error.unsupported_create_command", null, commandId);
    }

    protected <R> R executeUndefinedCommand(@Nonnull Command<R> command) {
        CommandException.NoStackTrace error = new CommandException.NoStackTrace(this, command, "error.unsupported_execute_command", null, CommandUtils.getCommandIdByType(command.getClass()));
        if (CommandUtils.commandResponseFlux(command)) {
            return (R)Flux.error((Throwable)((Object)error));
        }
        if (CommandUtils.commandResponseMono(command)) {
            return (R)Mono.error((Throwable)((Object)error));
        }
        throw error;
    }
}

