/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.command;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.metadata.Jsonable;
import org.jetlinks.core.utils.ConverterUtils;
import org.jetlinks.core.utils.SerializeUtils;

public abstract class AbstractCommand<Response, Self extends AbstractCommand<Response, Self>>
implements Command<Response>,
Jsonable,
Externalizable {
    private Map<String, Object> properties;

    @JsonAnySetter
    public final Self with(String key, Object value) {
        this.writable().put(key, value);
        return this.castSelf();
    }

    public final Self with(Map<String, Object> properties) {
        this.writable().putAll(properties);
        return this.castSelf();
    }

    @Override
    public Command<Response> with(Object parameterObject) {
        if (parameterObject == null) {
            return this.castSelf();
        }
        if (parameterObject instanceof Map) {
            return this.with((Map)parameterObject);
        }
        if (parameterObject instanceof Command) {
            return this.with((Map)((Command)parameterObject).asMap());
        }
        if (parameterObject instanceof Jsonable) {
            return this.with((Map)((Jsonable)parameterObject).toJson());
        }
        return this.with((Map)FastBeanCopier.copy((Object)parameterObject, new HashMap(), (String[])new String[0]));
    }

    @Override
    public <T> T getOrNull(String key, Type type) {
        return ConverterUtils.convert(this.readable().get(key), type);
    }

    @JsonAnyGetter
    public Map<String, Object> readable() {
        return this.properties == null ? Collections.emptyMap() : this.properties;
    }

    public Map<String, Object> writable() {
        return this.properties == null ? (this.properties = new HashMap<String, Object>()) : this.properties;
    }

    protected Self castSelf() {
        return (Self)this;
    }

    @Override
    public Map<String, Object> asMap() {
        return this.readable();
    }

    @Override
    public <T> T as(Type type) {
        return ConverterUtils.convert(this.readable(), type);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeKeyValue(this.properties, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        SerializeUtils.readKeyValue(in, this.writable()::put);
    }

    @Override
    public JSONObject toJson() {
        return new JSONObject(this.readable());
    }

    @Override
    public void fromJson(JSONObject json) {
        this.writable().putAll((Map<String, Object>)json);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractCommand)) {
            return false;
        }
        AbstractCommand other = (AbstractCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$properties = this.properties;
        Map<String, Object> other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }
}

