/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.cluster.load;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadLocalRandom;
import org.jetlinks.core.cluster.load.LoadBalancer;

class DefaultLoadBalancer<S>
implements LoadBalancer<S> {
    private final HashFunction hashFunction = Hashing.murmur3_128();
    private final NavigableMap<Long, S> circle = new ConcurrentSkipListMap<Long, S>();
    private final int vnode = 64;

    protected long hash(Object key) {
        long hashCode = key instanceof Number ? this.hashFunction.hashLong(((Number)key).longValue()).asLong() : this.hashFunction.hashString((CharSequence)String.valueOf(key), StandardCharsets.UTF_8).asLong();
        return hashCode;
    }

    @Override
    public void register(S server) {
        this.circle.put(this.hash(server), server);
        for (int i = 0; i < 64; ++i) {
            this.circle.put(this.hash(server + "&VN=" + i), server);
        }
    }

    @Override
    public void deregister(S server) {
        this.circle.remove(this.hash(server), server);
        for (int i = 0; i < 64; ++i) {
            this.circle.remove(this.hash(server + "&VN=" + i), server);
        }
    }

    @Override
    public S choose() {
        return this.choose(ThreadLocalRandom.current().nextLong());
    }

    @Override
    public S choose(Object key) {
        long hash = this.hash(key);
        if (this.circle.isEmpty()) {
            return null;
        }
        Object fast = this.circle.get(hash);
        if (fast != null) {
            return (S)fast;
        }
        Map.Entry<Long, S> entry = this.circle.tailMap(hash, true).firstEntry();
        if (entry == null) {
            entry = this.circle.firstEntry();
        }
        return entry.getValue();
    }
}

