/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.cache;

import java.nio.file.Path;
import java.util.Map;
import java.util.Queue;
import org.jetlinks.core.cache.FileQueueProxy;
import org.jetlinks.core.cache.SPIFileQueueBuilder;
import org.jetlinks.core.codec.Codec;
import org.jetlinks.core.config.ConfigKey;
import reactor.core.publisher.Sinks;

public interface FileQueue<T>
extends Queue<T> {
    public static <T> Builder<T> builder() {
        return new SPIFileQueueBuilder();
    }

    public void close();

    public void flush();

    public T removeFirst();

    public T removeLast();

    public static interface Builder<T> {
        public Builder<T> name(String var1);

        @Deprecated
        public Builder<T> codec(Codec<T> var1);

        public Builder<T> path(Path var1);

        public Builder<T> options(Map<String, Object> var1);

        public Builder<T> option(String var1, Object var2);

        public <V> Builder<T> option(ConfigKey<V> var1, V var2);

        public FileQueue<T> build();

        default public Sinks.Many<T> buildFluxProcessor(boolean clearWhenDispose) {
            FileQueue queue = !clearWhenDispose ? new FileQueueProxy<T>(this.build()){

                @Override
                public void clear() {
                    super.flush();
                }
            } : this.build();
            return Sinks.unsafe().many().unicast().onBackpressureBuffer((Queue)queue, queue::close);
        }
    }
}

