/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetlinks.core.utils.SerializeUtils;

public class LazyConverter<V, T>
implements Supplier<T>,
Externalizable {
    private final transient V source;
    private final transient Function<V, T> converter;
    private T value;
    private volatile boolean resolved;

    public LazyConverter() {
        this.source = null;
        this.converter = null;
    }

    @Override
    public T get() {
        if (this.resolved || this.source == null) {
            return this.value;
        }
        this.value = this.converter.apply(this.source);
        this.resolved = true;
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeObject(this.get(), out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = SerializeUtils.readObject(in);
        this.resolved = true;
    }

    private LazyConverter(V source, Function<V, T> converter) {
        this.source = source;
        this.converter = converter;
    }

    public static <V, T> LazyConverter<V, T> of(V source, Function<V, T> converter) {
        return new LazyConverter<V, T>(source, converter);
    }
}

