/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.function.Supplier;
import org.jetlinks.core.utils.SerializeUtils;

public class Lazy<T>
implements Supplier<T>,
Externalizable {
    private final transient Supplier<? extends T> supplier;
    private T value;
    private volatile boolean resolved;

    public Lazy() {
        this.supplier = null;
    }

    @Override
    public T get() {
        if (this.resolved || this.supplier == null) {
            return this.value;
        }
        this.value = this.supplier.get();
        this.resolved = true;
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SerializeUtils.writeObject(this.get(), out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = SerializeUtils.readObject(in);
        this.resolved = true;
    }

    private Lazy(Supplier<? extends T> supplier) {
        this.supplier = supplier;
    }

    public static <T> Lazy<T> of(Supplier<? extends T> supplier) {
        return new Lazy<T>(supplier);
    }
}

