/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.HeaderSupport;
import org.jetlinks.core.message.HeaderKey;

public class GenericHeaderSupport<SELF extends GenericHeaderSupport<SELF>>
implements HeaderSupport<SELF> {
    private volatile Map<String, Object> headers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> safeGetHeader() {
        if (this.headers == null) {
            GenericHeaderSupport genericHeaderSupport = this;
            synchronized (genericHeaderSupport) {
                if (this.headers == null) {
                    this.headers = new ConcurrentHashMap<String, Object>(64);
                }
            }
        }
        return this.headers;
    }

    public final void setHeaders(Map<String, Object> headers) {
        if (headers != null && !(headers instanceof ConcurrentHashMap)) {
            headers = new ConcurrentHashMap<String, Object>(headers);
        }
        this.headers = headers;
    }

    @Override
    @Nullable
    public final Map<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public final SELF addHeader(@Nonnull String header, @Nonnull Object value) {
        if (header == null || value == null) {
            return (SELF)((GenericHeaderSupport)this.castSelf());
        }
        this.safeGetHeader().put(header, value);
        return (SELF)((GenericHeaderSupport)this.castSelf());
    }

    @Override
    public final SELF addHeaderIfAbsent(String header, Object value) {
        if (header == null || value == null) {
            return (SELF)((GenericHeaderSupport)this.castSelf());
        }
        this.safeGetHeader().putIfAbsent(header, value);
        return (SELF)((GenericHeaderSupport)this.castSelf());
    }

    @Override
    public <T> SELF addHeaderIfAbsent(HeaderKey<T> header, T value) {
        return (SELF)((GenericHeaderSupport)HeaderSupport.super.addHeaderIfAbsent(header, value));
    }

    @Override
    public final SELF removeHeader(String header) {
        if (null != header) {
            this.safeGetHeader().remove(header);
        }
        return (SELF)((GenericHeaderSupport)this.castSelf());
    }

    @Override
    public final Object computeHeader(String key, BiFunction<String, Object, Object> computer) {
        return this.safeGetHeader().compute(key, computer);
    }

    @Override
    public Object getHeaderOrElse(String header, @Nullable Supplier<Object> orElse) {
        return HeaderSupport.super.getHeaderOrElse(header, orElse);
    }

    @Override
    public Optional<Object> getHeader(String header) {
        return HeaderSupport.super.getHeader(header);
    }

    @Override
    public <T> Optional<T> getHeader(HeaderKey<T> key) {
        return HeaderSupport.super.getHeader(key);
    }

    @Override
    public <T> T getHeaderOrDefault(HeaderKey<T> key) {
        return HeaderSupport.super.getHeaderOrDefault(key);
    }

    @Override
    public <T> T getHeaderOrElse(HeaderKey<T> header, @Nullable Supplier<T> orElse) {
        return HeaderSupport.super.getHeaderOrElse(header, orElse);
    }

    @Override
    public <T> T getOrAddHeader(HeaderKey<T> header, Supplier<T> value) {
        return HeaderSupport.super.getOrAddHeader(header, value);
    }

    @Override
    public <T> T getOrAddHeaderDefault(HeaderKey<T> header) {
        return HeaderSupport.super.getOrAddHeaderDefault(header);
    }

    @Override
    public <T> T computeHeader(HeaderKey<T> key, BiFunction<String, T, T> computer) {
        return HeaderSupport.super.computeHeader(key, computer);
    }

    @Override
    public <T> SELF addHeader(@Nonnull HeaderKey<T> header, @Nonnull T value) {
        return (SELF)((GenericHeaderSupport)HeaderSupport.super.addHeader(header, value));
    }
}

