/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.constraints;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.intellij.markdown.lexer.Compat;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.providers.HorizontalRuleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 &2\u00020\u0001:\u0002&'B'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00002\f\u0010\u0016\u001a\b\u0018\u00010\u0017R\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0018\u00010\u0017R\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\tH\u0016J(\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\n\u0010\u0016\u001a\u00060\u0017R\u00020\u0018H\u0014J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\u0001H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0016\u0010$\u001a\u0004\u0018\u00010\u00002\n\u0010\u0016\u001a\u00060\u0017R\u00020\u0018H\u0002J\u0016\u0010%\u001a\u0004\u0018\u00010\u00002\n\u0010\u0016\u001a\u00060\u0017R\u00020\u0018H\u0002R\u0014\u0010\u000b\u001a\u00020\u00008TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "indents", "", "types", "", "isExplicit", "", "charsEaten", "", "([I[C[ZI)V", "base", "getBase", "()Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "getCharsEaten", "()I", "indent", "getIndent", "()[Z", "getTypes", "()[C", "addModifierIfNeeded", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "applyToNextLine", "containsListMarkers", "", "upToIndex", "createNewConstraints", "fetchListMarker", "Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints$ListMarkerInfo;", "startsWith", "other", "toString", "", "tryAddBlockQuote", "tryAddListItem", "Companion", "ListMarkerInfo", "markdown"})
public class CommonMarkdownConstraints
implements MarkdownConstraints {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final int[] indents;
    @NotNull
    private final char[] types;
    @NotNull
    private final boolean[] isExplicit;
    private final int charsEaten;
    @NotNull
    private static final CommonMarkdownConstraints BASE = new CommonMarkdownConstraints(new int[0], new char[0], new boolean[0], 0);
    public static final char BQ_CHAR = '>';

    protected CommonMarkdownConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkNotNullParameter((Object)indents, (String)"indents");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)isExplicit, (String)"isExplicit");
        this.indents = indents;
        this.types = types;
        this.isExplicit = isExplicit;
        this.charsEaten = charsEaten;
    }

    @Override
    @NotNull
    public char[] getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public boolean[] isExplicit() {
        return this.isExplicit;
    }

    @Override
    public int getCharsEaten() {
        return this.charsEaten;
    }

    @NotNull
    protected CommonMarkdownConstraints getBase() {
        return BASE;
    }

    @NotNull
    protected CommonMarkdownConstraints createNewConstraints(@NotNull int[] indents, @NotNull char[] types, @NotNull boolean[] isExplicit, int charsEaten) {
        Intrinsics.checkNotNullParameter((Object)indents, (String)"indents");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)isExplicit, (String)"isExplicit");
        return new CommonMarkdownConstraints(indents, types, isExplicit, charsEaten);
    }

    @Override
    public int getIndent() {
        Integer n = ArraysKt.lastOrNull((int[])this.indents);
        return n == null ? 0 : n;
    }

    @Override
    public boolean startsWith(@NotNull MarkdownConstraints other) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!(other instanceof CommonMarkdownConstraints)) {
                return false;
            }
            int n = this.indents.length;
            int m = ((CommonMarkdownConstraints)other).indents.length;
            if (n < m) {
                return false;
            }
            Iterable $this$none$iv = (Iterable)RangesKt.until((int)0, (int)m);
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$none$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(this.getTypes()[it] != other.getTypes()[it])) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean containsListMarkers(int upToIndex) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = (Iterable)RangesKt.until((int)0, (int)upToIndex);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator).nextInt();
                    boolean bl2 = false;
                    if (!(this.getTypes()[it] != '>' && this.isExplicit()[it])) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @Nullable
    public CommonMarkdownConstraints addModifierIfNeeded(@Nullable LookaheadText.Position pos) {
        if (pos == null || pos.getOffsetInCurrentLine() == -1) {
            return null;
        }
        if (HorizontalRuleProvider.Companion.isHorizontalRule(pos.getCurrentLine(), pos.getOffsetInCurrentLine())) {
            return null;
        }
        CommonMarkdownConstraints commonMarkdownConstraints = this.tryAddListItem(pos);
        return commonMarkdownConstraints == null ? this.tryAddBlockQuote(pos) : commonMarkdownConstraints;
    }

    @Override
    @NotNull
    public CommonMarkdownConstraints applyToNextLine(@Nullable LookaheadText.Position pos) {
        if (pos == null) {
            return this.getBase();
        }
        Compat compat = Compat.INSTANCE;
        boolean condition$iv = pos.getOffsetInCurrentLine() == -1;
        boolean $i$f$assert = false;
        if (!condition$iv) {
            String string;
            boolean bl = false;
            String string2 = string = Intrinsics.stringPlus((String)"given ", (Object)pos);
            throw new AssertionError((Object)string2);
        }
        String line = pos.getCurrentLine();
        int prevN = this.indents.length;
        Ref.IntRef indexPrev = new Ref.IntRef();
        Function1 getBlockQuoteIndent2 = (Function1)new Function1<Integer, Integer>(line){
            final /* synthetic */ String $line;
            {
                this.$line = $line;
                super(1);
            }

            @Nullable
            public final Integer invoke(int startOffset) {
                int offset = startOffset;
                int blockQuoteIndent = 0;
                while (blockQuoteIndent < 3 && offset < this.$line.length() && this.$line.charAt(offset) == ' ') {
                    int n = blockQuoteIndent;
                    blockQuoteIndent = n + 1;
                    n = offset;
                    offset = n + 1;
                }
                return offset < this.$line.length() && this.$line.charAt(offset) == '>' ? Integer.valueOf(blockQuoteIndent + 1) : (Integer)null;
            }
        };
        Function1 fillMaybeBlockquoteAndListIndents2 = (Function1)new Function1<CommonMarkdownConstraints, CommonMarkdownConstraints>(indexPrev, prevN, line, this, (Function1<? super Integer, Integer>)getBlockQuoteIndent2){
            final /* synthetic */ Ref.IntRef $indexPrev;
            final /* synthetic */ int $prevN;
            final /* synthetic */ String $line;
            final /* synthetic */ CommonMarkdownConstraints this$0;
            final /* synthetic */ Function1<Integer, Integer> $getBlockQuoteIndent;
            {
                this.$indexPrev = $indexPrev;
                this.$prevN = $prevN;
                this.$line = $line;
                this.this$0 = $receiver;
                this.$getBlockQuoteIndent = $getBlockQuoteIndent;
                super(1);
            }

            @NotNull
            public final CommonMarkdownConstraints invoke(@NotNull CommonMarkdownConstraints constraints) {
                int n;
                int deltaIndent;
                Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
                if (this.$indexPrev.element >= this.$prevN) {
                    return constraints;
                }
                Ref.IntRef offset = new Ref.IntRef();
                offset.element = MarkdownConstraintsKt.getCharsEaten(constraints, this.$line);
                Ref.IntRef totalSpaces = new Ref.IntRef();
                Ref.IntRef spacesSeen = new Ref.IntRef();
                Function1 hasKMoreSpaces2 = (Function1)new Function1<Integer, Boolean>(spacesSeen, offset, this.$line, totalSpaces){
                    final /* synthetic */ Ref.IntRef $spacesSeen;
                    final /* synthetic */ Ref.IntRef $offset;
                    final /* synthetic */ String $line;
                    final /* synthetic */ Ref.IntRef $totalSpaces;
                    {
                        this.$spacesSeen = $spacesSeen;
                        this.$offset = $offset;
                        this.$line = $line;
                        this.$totalSpaces = $totalSpaces;
                        super(1);
                    }

                    public final boolean invoke(int k) {
                        boolean bl;
                        int oldSpacesSeen = this.$spacesSeen.element;
                        int oldOffset = this.$offset.element;
                        while (this.$spacesSeen.element < k && this.$offset.element < this.$line.length()) {
                            int n;
                            int n2 = this.$line.charAt(this.$offset.element);
                            if (n2 == 32) {
                                n = 1;
                            } else {
                                if (n2 != 9) break;
                                n = 4 - this.$totalSpaces.element % 4;
                            }
                            int deltaSpaces = n;
                            this.$spacesSeen.element += deltaSpaces;
                            this.$totalSpaces.element += deltaSpaces;
                            n2 = this.$offset.element;
                            this.$offset.element = n2 + 1;
                        }
                        if (this.$offset.element == this.$line.length()) {
                            this.$spacesSeen.element = Integer.MAX_VALUE;
                        }
                        if (k <= this.$spacesSeen.element) {
                            this.$spacesSeen.element -= k;
                            bl = true;
                        } else {
                            this.$offset.element = oldOffset;
                            this.$spacesSeen.element = oldSpacesSeen;
                            bl = false;
                        }
                        return bl;
                    }
                };
                Integer bqIndent = null;
                if (this.this$0.getTypes()[this.$indexPrev.element] == '>') {
                    Integer n2 = (Integer)this.$getBlockQuoteIndent.invoke((Object)offset.element);
                    if (n2 == null) {
                        return constraints;
                    }
                    bqIndent = n2;
                    offset.element += bqIndent.intValue();
                    int n3 = this.$indexPrev.element;
                    this.$indexPrev.element = n3 + 1;
                } else {
                    bqIndent = null;
                }
                int oldIndexPrev = this.$indexPrev.element;
                while (this.$indexPrev.element < this.$prevN && this.this$0.getTypes()[this.$indexPrev.element] != '>' && ((Boolean)hasKMoreSpaces2.invoke((Object)(deltaIndent = CommonMarkdownConstraints.access$getIndents$p(this.this$0)[this.$indexPrev.element] - (this.$indexPrev.element == 0 ? 0 : CommonMarkdownConstraints.access$getIndents$p(this.this$0)[this.$indexPrev.element - 1])))).booleanValue()) {
                    n = this.$indexPrev.element;
                    this.$indexPrev.element = n + 1;
                }
                CommonMarkdownConstraints result = constraints;
                if (bqIndent != null) {
                    int bonusForTheBlockquote = (Boolean)hasKMoreSpaces2.invoke((Object)1) != false ? 1 : 0;
                    result = org.intellij.markdown.parser.constraints.CommonMarkdownConstraints$Companion.access$create(CommonMarkdownConstraints.Companion, result, bqIndent + bonusForTheBlockquote, '>', true, offset.element);
                }
                if ((n = oldIndexPrev) < this.$indexPrev.element) {
                    do {
                        int index = n++;
                        int deltaIndent2 = CommonMarkdownConstraints.access$getIndents$p(this.this$0)[index] - (index == 0 ? 0 : CommonMarkdownConstraints.access$getIndents$p(this.this$0)[index - 1]);
                        result = org.intellij.markdown.parser.constraints.CommonMarkdownConstraints$Companion.access$create(CommonMarkdownConstraints.Companion, result, deltaIndent2, this.this$0.getTypes()[index], false, offset.element);
                    } while (n < this.$indexPrev.element);
                }
                return result;
            }
        };
        CommonMarkdownConstraints result = this.getBase();
        CommonMarkdownConstraints nextConstraints;
        while (!Intrinsics.areEqual((Object)(nextConstraints = (CommonMarkdownConstraints)fillMaybeBlockquoteAndListIndents2.invoke((Object)result)), (Object)result)) {
            result = nextConstraints;
        }
        return result;
    }

    @Nullable
    protected ListMarkerInfo fetchListMarker(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        char c = pos.getChar();
        if (c == '*' || c == '-' || c == '+') {
            return new ListMarkerInfo(1, c, 1);
        }
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        while (offset < line.length()) {
            int n = line.charAt(offset);
            boolean bl = 48 <= n ? n <= 57 : false;
            if (!bl) break;
            n = offset;
            offset = n + 1;
        }
        return offset > pos.getOffsetInCurrentLine() && offset - pos.getOffsetInCurrentLine() <= 9 && offset < line.length() && (line.charAt(offset) == '.' || line.charAt(offset) == ')') ? new ListMarkerInfo(offset + 1 - pos.getOffsetInCurrentLine(), line.charAt(offset), offset + 1 - pos.getOffsetInCurrentLine()) : (ListMarkerInfo)null;
    }

    private final CommonMarkdownConstraints tryAddListItem(LookaheadText.Position pos) {
        int n;
        int n2;
        int spacesBefore;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        int n3 = spacesBefore = offset > 0 && line.charAt(offset - 1) == '\t' ? (4 - this.getIndent() % 4) % 4 : 0;
        while (offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3) {
            int n4 = spacesBefore;
            spacesBefore = n4 + 1;
            n4 = offset;
            offset = n4 + 1;
        }
        if (offset == line.length()) {
            return null;
        }
        LookaheadText.Position position = pos.nextPosition(offset - pos.getOffsetInCurrentLine());
        Intrinsics.checkNotNull((Object)position);
        ListMarkerInfo listMarkerInfo = this.fetchListMarker(position);
        if (listMarkerInfo == null) {
            return null;
        }
        ListMarkerInfo markerInfo = listMarkerInfo;
        int spacesAfter = 0;
        int markerEndOffset = offset += markerInfo.getMarkerLength();
        while (offset < line.length()) {
            n2 = line.charAt(offset);
            if (n2 == 32) {
                n = spacesAfter;
                spacesAfter = n + 1;
            } else {
                if (n2 != 9) break;
                spacesAfter += 4 - spacesAfter % 4;
            }
            n2 = offset;
            offset = n2 + 1;
        }
        boolean bl = 1 <= spacesAfter ? spacesAfter <= 4 : false;
        if (bl && offset < line.length()) {
            return CommonMarkdownConstraints.Companion.create(this, spacesBefore + markerInfo.getMarkerIndent() + spacesAfter, markerInfo.getMarkerType(), true, offset);
        }
        if (spacesAfter >= 5 && offset < line.length() || offset == line.length()) {
            n2 = markerEndOffset + 1;
            n = 0;
            return CommonMarkdownConstraints.Companion.create(this, spacesBefore + markerInfo.getMarkerIndent() + 1, markerInfo.getMarkerType(), true, Math.min(offset, n2));
        }
        return null;
    }

    private final CommonMarkdownConstraints tryAddBlockQuote(LookaheadText.Position pos) {
        int n;
        String line = pos.getCurrentLine();
        int offset = pos.getOffsetInCurrentLine();
        int spacesBefore = 0;
        while (offset < line.length() && line.charAt(offset) == ' ' && spacesBefore < 3) {
            n = spacesBefore;
            spacesBefore = n + 1;
            n = offset;
            offset = n + 1;
        }
        if (offset == line.length() || line.charAt(offset) != '>') {
            return null;
        }
        n = offset;
        offset = n + 1;
        int spacesAfter = 0;
        if (offset >= line.length() || line.charAt(offset) == ' ' || line.charAt(offset) == '\t') {
            spacesAfter = 1;
            if (offset < line.length()) {
                int n2 = offset;
                offset = n2 + 1;
            }
        }
        return CommonMarkdownConstraints.Companion.create(this, spacesBefore + 1 + spacesAfter, '>', true, offset);
    }

    @NotNull
    public String toString() {
        return "MdConstraints: " + StringsKt.concatToString((char[])this.getTypes()) + '(' + this.getIndent() + ')';
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints$ListMarkerInfo;", "", "markerLength", "", "markerType", "", "markerIndent", "(ICI)V", "getMarkerIndent", "()I", "getMarkerLength", "getMarkerType", "()C", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "markdown"})
    protected static final class ListMarkerInfo {
        private final int markerLength;
        private final char markerType;
        private final int markerIndent;

        public ListMarkerInfo(int markerLength, char markerType, int markerIndent) {
            this.markerLength = markerLength;
            this.markerType = markerType;
            this.markerIndent = markerIndent;
        }

        public final int getMarkerLength() {
            return this.markerLength;
        }

        public final char getMarkerType() {
            return this.markerType;
        }

        public final int getMarkerIndent() {
            return this.markerIndent;
        }

        public final int component1() {
            return this.markerLength;
        }

        public final char component2() {
            return this.markerType;
        }

        public final int component3() {
            return this.markerIndent;
        }

        @NotNull
        public final ListMarkerInfo copy(int markerLength, char markerType, int markerIndent) {
            return new ListMarkerInfo(markerLength, markerType, markerIndent);
        }

        public static /* synthetic */ ListMarkerInfo copy$default(ListMarkerInfo listMarkerInfo, int n, char c, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = listMarkerInfo.markerLength;
            }
            if ((n3 & 2) != 0) {
                c = listMarkerInfo.markerType;
            }
            if ((n3 & 4) != 0) {
                n2 = listMarkerInfo.markerIndent;
            }
            return listMarkerInfo.copy(n, c, n2);
        }

        @NotNull
        public String toString() {
            return "ListMarkerInfo(markerLength=" + this.markerLength + ", markerType=" + this.markerType + ", markerIndent=" + this.markerIndent + ')';
        }

        public int hashCode() {
            int result = this.markerLength;
            result = result * 31 + this.markerType;
            result = result * 31 + this.markerIndent;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ListMarkerInfo)) {
                return false;
            }
            ListMarkerInfo listMarkerInfo = (ListMarkerInfo)other;
            if (this.markerLength != listMarkerInfo.markerLength) {
                return false;
            }
            if (this.markerType != listMarkerInfo.markerType) {
                return false;
            }
            return this.markerIndent == listMarkerInfo.markerIndent;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints$Companion;", "", "()V", "BASE", "Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "getBASE", "()Lorg/intellij/markdown/parser/constraints/CommonMarkdownConstraints;", "BQ_CHAR", "", "create", "parent", "newIndentDelta", "", "newType", "newExplicit", "", "newOffset", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CommonMarkdownConstraints getBASE() {
            return BASE;
        }

        private final CommonMarkdownConstraints create(CommonMarkdownConstraints parent, int newIndentDelta, char newType, boolean newExplicit, int newOffset) {
            int n = parent.indents.length;
            int[] nArray = parent.indents;
            int n2 = n + 1;
            int n3 = 0;
            int[] nArray2 = Arrays.copyOf(nArray, n2);
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            int[] indents = nArray2;
            char[] cArray = parent.getTypes();
            n3 = n + 1;
            int n4 = 0;
            char[] cArray2 = Arrays.copyOf(cArray, n3);
            Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            char[] types = cArray2;
            boolean[] blArray = parent.isExplicit();
            n4 = n + 1;
            boolean bl = false;
            boolean[] blArray2 = Arrays.copyOf(blArray, n4);
            Intrinsics.checkNotNullExpressionValue((Object)blArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            boolean[] isExplicit = blArray2;
            indents[n] = parent.getIndent() + newIndentDelta;
            types[n] = newType;
            isExplicit[n] = newExplicit;
            return parent.createNewConstraints(indents, types, isExplicit, newOffset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

