/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.html.CommonDefsImplJvmKt;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.lexer.Compat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/intellij/markdown/parser/LinkMap;", "", "map", "", "", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "(Ljava/util/Map;)V", "getLinkInfo", "label", "Builder", "LinkInfo", "markdown"})
public final class LinkMap {
    @NotNull
    public static final Builder Builder = new Builder(null);
    @NotNull
    private final Map<CharSequence, LinkInfo> map;
    @NotNull
    private static final Regex SPACES_REGEX = new Regex("\\s+");

    public LinkMap(@NotNull Map<CharSequence, LinkInfo> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.map = map;
    }

    @Nullable
    public final LinkInfo getLinkInfo(@NotNull CharSequence label) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        return this.map.get(Builder.normalizeLabel(label));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ)\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e\"\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/intellij/markdown/parser/LinkMap$Builder;", "", "()V", "SPACES_REGEX", "Lkotlin/text/Regex;", "buildLinkMap", "Lorg/intellij/markdown/parser/LinkMap;", "root", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "clearBounding", "s", "boundQuotes", "", "", "(Ljava/lang/CharSequence;[Ljava/lang/String;)Ljava/lang/CharSequence;", "normalizeDestination", "processEscapes", "", "normalizeLabel", "label", "normalizeTitle", "markdown"})
    public static final class Builder {
        private Builder() {
        }

        @NotNull
        public final CharSequence normalizeLabel(@NotNull CharSequence label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            String string = SPACES_REGEX.replace(label, " ");
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
            return string3;
        }

        @NotNull
        public final LinkMap buildLinkMap(@NotNull ASTNode root, @NotNull CharSequence text) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            HashMap<CharSequence, LinkInfo> map = new HashMap<CharSequence, LinkInfo>();
            ASTNodeKt.accept(root, new RecursiveVisitor(text, map){
                final /* synthetic */ CharSequence $text;
                final /* synthetic */ HashMap<CharSequence, LinkInfo> $map;
                {
                    this.$text = $text;
                    this.$map = $map;
                }

                /*
                 * WARNING - void declaration
                 */
                public void visitNode(@NotNull ASTNode node) {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.LINK_DEFINITION)) {
                        T element$iv2;
                        Builder builder;
                        Object object;
                        block4: {
                            void $this$first$iv;
                            object = node.getChildren();
                            builder = LinkMap.Builder;
                            boolean $i$f$first = false;
                            for (T element$iv2 : $this$first$iv) {
                                ASTNode it = (ASTNode)element$iv2;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_LABEL)) continue;
                                break block4;
                            }
                            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                        }
                        T t = element$iv2;
                        CharSequence linkLabel = builder.normalizeLabel(ASTUtilKt.getTextInNode((ASTNode)t, this.$text));
                        if (!this.$map.containsKey(linkLabel)) {
                            object = this.$map;
                            LinkInfo linkInfo = LinkInfo.Companion.create(node, this.$text);
                            boolean bl = false;
                            object.put(linkLabel, linkInfo);
                        }
                    } else {
                        super.visitNode(node);
                    }
                }
            });
            return new LinkMap((Map<CharSequence, LinkInfo>)map);
        }

        @NotNull
        public final CharSequence normalizeDestination(@NotNull CharSequence s, boolean processEscapes) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            String[] stringArray = new String[]{"<>"};
            String destination = EntityConverter.INSTANCE.replaceEntities(this.clearBounding(s, stringArray), true, processEscapes);
            StringBuilder sb = new StringBuilder();
            Compat.INSTANCE.forEachCodePoint(destination, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(sb){
                final /* synthetic */ StringBuilder $sb;
                {
                    this.$sb = $sb;
                    super(1);
                }

                public final void invoke(int code) {
                    char c = (char)code;
                    if (code == 32) {
                        this.$sb.append("%20");
                    } else if (code < 32 || code >= 128 || StringsKt.contains$default((CharSequence)"\".<>\\^_`{|}", (char)c, (boolean)false, (int)2, null)) {
                        this.$sb.append(CommonDefsImplJvmKt.urlEncode(Compat.INSTANCE.codePointToString(code)));
                    } else {
                        this.$sb.append(c);
                    }
                }
            }));
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        @NotNull
        public final CharSequence normalizeTitle(@NotNull CharSequence s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            String[] stringArray = new String[]{"\"\"", "''", "()"};
            return EntityConverter.INSTANCE.replaceEntities(this.clearBounding(s, stringArray), true, true);
        }

        private final CharSequence clearBounding(CharSequence s, String ... boundQuotes) {
            String[] stringArray = s;
            int n = 0;
            if (stringArray.length() == 0) {
                return s;
            }
            for (String quotePair : boundQuotes) {
                if (s.charAt(0) != quotePair.charAt(0) || s.charAt(s.length() - 1) != quotePair.charAt(1)) continue;
                return s.subSequence(1, s.length() - 1);
            }
            return s;
        }

        public /* synthetic */ Builder(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "destination", "", "title", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;Ljava/lang/CharSequence;)V", "getDestination", "()Ljava/lang/CharSequence;", "getNode", "()Lorg/intellij/markdown/ast/ASTNode;", "getTitle", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "markdown"})
    public static final class LinkInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ASTNode node;
        @NotNull
        private final CharSequence destination;
        @Nullable
        private final CharSequence title;

        public LinkInfo(@NotNull ASTNode node, @NotNull CharSequence destination, @Nullable CharSequence title) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            this.node = node;
            this.destination = destination;
            this.title = title;
        }

        @NotNull
        public final ASTNode getNode() {
            return this.node;
        }

        @NotNull
        public final CharSequence getDestination() {
            return this.destination;
        }

        @Nullable
        public final CharSequence getTitle() {
            return this.title;
        }

        @NotNull
        public final ASTNode component1() {
            return this.node;
        }

        @NotNull
        public final CharSequence component2() {
            return this.destination;
        }

        @Nullable
        public final CharSequence component3() {
            return this.title;
        }

        @NotNull
        public final LinkInfo copy(@NotNull ASTNode node, @NotNull CharSequence destination, @Nullable CharSequence title) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            return new LinkInfo(node, destination, title);
        }

        public static /* synthetic */ LinkInfo copy$default(LinkInfo linkInfo, ASTNode aSTNode, CharSequence charSequence, CharSequence charSequence2, int n, Object object) {
            if ((n & 1) != 0) {
                aSTNode = linkInfo.node;
            }
            if ((n & 2) != 0) {
                charSequence = linkInfo.destination;
            }
            if ((n & 4) != 0) {
                charSequence2 = linkInfo.title;
            }
            return linkInfo.copy(aSTNode, charSequence, charSequence2);
        }

        @NotNull
        public String toString() {
            return "LinkInfo(node=" + this.node + ", destination=" + this.destination + ", title=" + this.title + ')';
        }

        public int hashCode() {
            int result = this.node.hashCode();
            result = result * 31 + this.destination.hashCode();
            result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LinkInfo)) {
                return false;
            }
            LinkInfo linkInfo = (LinkInfo)other;
            if (!Intrinsics.areEqual((Object)this.node, (Object)linkInfo.node)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.destination, (Object)linkInfo.destination)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.title, (Object)linkInfo.title);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/intellij/markdown/parser/LinkMap$LinkInfo$Companion;", "", "()V", "create", "Lorg/intellij/markdown/parser/LinkMap$LinkInfo;", "node", "Lorg/intellij/markdown/ast/ASTNode;", "fileText", "", "markdown"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final LinkInfo create(@NotNull ASTNode node, @NotNull CharSequence fileText) {
                CharSequence charSequence;
                Object v0;
                Object it;
                CharSequence destination;
                block7: {
                    Object element$iv2;
                    Builder builder;
                    block6: {
                        void $this$first$iv;
                        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
                        Iterable iterable = node.getChildren();
                        builder = Builder;
                        boolean $i$f$first = false;
                        for (Object element$iv2 : $this$first$iv) {
                            ASTNode it2 = (ASTNode)element$iv2;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it2.getType(), (Object)MarkdownElementTypes.LINK_DESTINATION)) continue;
                            break block6;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Object t = element$iv2;
                    destination = builder.normalizeDestination(ASTUtilKt.getTextInNode((ASTNode)t, fileText), true);
                    Iterable $this$firstOrNull$iv = node.getChildren();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv3 : $this$firstOrNull$iv) {
                        it = (ASTNode)element$iv3;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getType(), (Object)MarkdownElementTypes.LINK_TITLE)) continue;
                        v0 = element$iv3;
                        break block7;
                    }
                    v0 = null;
                }
                ASTNode aSTNode = v0;
                if (aSTNode == null) {
                    charSequence = null;
                } else {
                    CharSequence charSequence2 = ASTUtilKt.getTextInNode(aSTNode, fileText);
                    if (charSequence2 == null) {
                        charSequence = null;
                    } else {
                        Object object = charSequence2;
                        boolean bl = false;
                        boolean bl2 = false;
                        it = object;
                        boolean bl3 = false;
                        charSequence = Builder.normalizeTitle((CharSequence)it);
                    }
                }
                CharSequence title = charSequence;
                return new LinkInfo(node, destination, title);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

