/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.scale;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.ContinuousTransform;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.Transform;
import jetbrains.datalore.plot.base.scale.ContinuousScale;
import jetbrains.datalore.plot.base.scale.MapperUtil;
import jetbrains.datalore.plot.base.scale.ScaleBreaks;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bJ*\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bJ\u001e\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000b2\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bJ(\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ2\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00100\u0004\"\u0004\b\u0000\u0010\u00102\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00100\bJ\u001e\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00122\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/base/scale/ScaleUtil;", "", "()V", "inverseTransform", "", "l", "", "scale", "Ljetbrains/datalore/plot/base/Scale;", "inverseTransformToContinuousDomain", "labelByBreak", "", "", "map", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "range", "T", "transformedDefinedLimits", "Lkotlin/Pair;", "plot-base-portable"})
public final class ScaleUtil {
    @NotNull
    public static final ScaleUtil INSTANCE = new ScaleUtil();

    private ScaleUtil() {
    }

    @NotNull
    public final Map<Object, String> labelByBreak(@NotNull Scale<?> scale) {
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        ScaleBreaks scaleBreaks = scale.getScaleBreaks();
        return MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)scaleBreaks.getDomainValues(), (Iterable)scaleBreaks.getLabels()));
    }

    @NotNull
    public final ClosedRange<Double> map(@NotNull ClosedRange<Double> range, @NotNull Scale<Double> scale) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        return MapperUtil.INSTANCE.map(range, scale.getMapper());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<T> map(@NotNull List<Double> l, @NotNull Scale<T> scale) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        Function1<Double, T> mapper = scale.getMapper();
        Iterable $this$map$iv = l;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Double d = (Double)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = mapper.invoke((Object)it);
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<Double> inverseTransformToContinuousDomain(@NotNull List<Double> l, @NotNull Scale<?> scale) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        boolean bl = scale.isContinuousDomain();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Not continuous numeric domain: ", scale);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return ((ContinuousTransform)scale.getTransform()).applyInverse(l);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<?> inverseTransform(@NotNull List<Double> l, @NotNull Scale<?> scale) {
        List list2;
        Intrinsics.checkNotNullParameter(l, (String)"l");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        Transform transform = scale.getTransform();
        if (transform instanceof ContinuousTransform) {
            list2 = ((ContinuousTransform)transform).applyInverse(l);
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = l;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Double d = (Double)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = transform.applyInverse((Double)it);
                collection.add(object);
            }
            list2 = (List)destination$iv$iv;
        }
        return list2;
    }

    @NotNull
    public final Pair<Double, Double> transformedDefinedLimits(@NotNull Scale<?> scale) {
        Pair pair;
        double d;
        double d2;
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        ContinuousScale cfr_ignored_0 = (ContinuousScale)scale;
        Pair<Double, Double> pair2 = ((ContinuousScale)scale).getContinuousDomainLimits();
        double lower = ((Number)pair2.component1()).doubleValue();
        double upper = ((Number)pair2.component2()).doubleValue();
        ContinuousTransform transform = (ContinuousTransform)scale.getTransform();
        if (transform.isInDomain(lower)) {
            Double d3 = transform.apply(lower);
            Intrinsics.checkNotNull((Object)d3);
            d2 = d3;
        } else {
            d2 = Double.NaN;
        }
        Double d4 = d2;
        if (transform.isInDomain(upper)) {
            Double d5 = transform.apply(upper);
            Intrinsics.checkNotNull((Object)d5);
            d = d5;
        } else {
            d = Double.NaN;
        }
        Pair pair3 = new Pair((Object)d4, (Object)d);
        double transformedLower = ((Number)pair3.component1()).doubleValue();
        double transformedUpper = ((Number)pair3.component2()).doubleValue();
        if (SeriesUtil.INSTANCE.allFinite(Double.valueOf(transformedLower), Double.valueOf(transformedUpper))) {
            boolean bl = false;
            bl = false;
            pair = new Pair((Object)Math.min(transformedLower, transformedUpper), (Object)Math.max(transformedLower, transformedUpper));
        } else {
            pair = new Pair((Object)transformedLower, (Object)transformedUpper);
        }
        return pair;
    }
}

