/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.ArrayList;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.collections.list.ObservableList;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.aes.AesScaling;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.GeomHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.HintColorUtil;
import jetbrains.datalore.plot.base.geom.util.HintsCollection;
import jetbrains.datalore.plot.base.interact.GeomTargetCollector;
import jetbrains.datalore.plot.base.interact.TipLayoutHint;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgNode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J0\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/base/geom/ErrorBarGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "buildHints", "", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "geomHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "buildIntern", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "Companion", "MyLegendKeyElementFactory", "plot-base-portable"})
public final class ErrorBarGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = false;

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new MyLegendKeyElementFactory();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx);
        for (DataPointAesthetics p : GeomUtil.INSTANCE.withDefined(aesthetics.dataPoints(), Aes.Companion.getX(), Aes.Companion.getYMIN(), Aes.Companion.getYMAX())) {
            Double d = p.x();
            Intrinsics.checkNotNull((Object)d);
            double x = d;
            Double d2 = p.ymin();
            Intrinsics.checkNotNull((Object)d2);
            double ymin = d2;
            Double d3 = p.ymax();
            Intrinsics.checkNotNull((Object)d3);
            double ymax = d3;
            Double d4 = p.width();
            Intrinsics.checkNotNull((Object)d4);
            double width2 = d4;
            double height = ymax - ymin;
            DoubleRectangle r = new DoubleRectangle(x - (width2 *= ctx.getResolution(Aes.Companion.getX())) / (double)2, ymin, width2, height);
            SvgGElement g = ErrorBarGeom.Companion.errorBarShape(r, p, geomHelper);
            root.add((SvgNode)g);
            this.buildHints(new DoubleRectangle(r.getLeft(), r.getCenter().getY(), r.getWidth(), 0.0), p, ctx, geomHelper);
        }
    }

    private final void buildHints(DoubleRectangle rect, DataPointAesthetics p, GeomContext ctx, GeomHelper geomHelper) {
        DoubleRectangle clientRect;
        DoubleRectangle doubleRectangle = clientRect = geomHelper.toClient(rect, p);
        boolean bl = false;
        boolean bl2 = false;
        DoubleRectangle $this$buildHints_u24lambda_u2d0 = doubleRectangle;
        boolean bl3 = false;
        double objectRadius = ctx.getFlipped() ? $this$buildHints_u24lambda_u2d0.getHeight() / 2.0 : $this$buildHints_u24lambda_u2d0.getWidth() / 2.0;
        HintsCollection.HintConfigFactory hintConfigFactory = new HintsCollection.HintConfigFactory().defaultObjectRadius(objectRadius);
        Double d = p.x();
        Intrinsics.checkNotNull((Object)d);
        HintsCollection.HintConfigFactory hint = hintConfigFactory.defaultX(d).defaultKind(ctx.getFlipped() ? TipLayoutHint.Kind.ROTATED_TOOLTIP : TipLayoutHint.Kind.HORIZONTAL_TOOLTIP);
        Map<Aes<?>, TipLayoutHint> hints = new HintsCollection(p, geomHelper).addHint(hint.create(Aes.Companion.getYMAX())).addHint(hint.create(Aes.Companion.getYMIN())).getHints();
        ctx.getTargetCollector().addRectangle(p.index(), clientRect, GeomTargetCollector.TooltipParams.Companion.params().setTipLayoutHints(hints).setColor(HintColorUtil.INSTANCE.fromColor(p)), ctx.getFlipped() ? TipLayoutHint.Kind.VERTICAL_TOOLTIP : TipLayoutHint.Kind.HORIZONTAL_TOOLTIP);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/geom/ErrorBarGeom$MyLegendKeyElementFactory;", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "()V", "createKeyElement", "Ljetbrains/datalore/vis/svg/SvgGElement;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "size", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plot-base-portable"})
    private static final class MyLegendKeyElementFactory
    implements LegendKeyElementFactory {
        @Override
        @NotNull
        public SvgGElement createKeyElement(@NotNull DataPointAesthetics p, @NotNull DoubleVector size) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            double strokeWidth = AesScaling.INSTANCE.strokeWidth(p);
            Double d = p.width();
            Intrinsics.checkNotNull((Object)d);
            double width2 = d * (size.getX() - strokeWidth);
            double height = size.getY() - strokeWidth;
            double x = (size.getX() - width2) / (double)2;
            double y = strokeWidth / (double)2;
            return Companion.errorBarLegendShape(new DoubleRectangle(x, y, width2, height), p);
        }

        @Override
        @NotNull
        public DoubleVector minimumKeySize(@NotNull DataPointAesthetics p) {
            return LegendKeyElementFactory.DefaultImpls.minimumKeySize(this, p);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/base/geom/ErrorBarGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "errorBarLegendShape", "Ljetbrains/datalore/vis/svg/SvgGElement;", "r", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "errorBarShape", "geomHelper", "Ljetbrains/datalore/plot/base/geom/util/GeomHelper;", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final SvgGElement errorBarLegendShape(DoubleRectangle r, DataPointAesthetics p) {
            double left = r.getLeft();
            double top = r.getTop();
            double right = r.getRight();
            double bottom = r.getBottom();
            double center = left + r.getWidth() / (double)2;
            ArrayList<SvgLineElement> shapeLines = new ArrayList<SvgLineElement>();
            shapeLines.add(new SvgLineElement(left, top, right, top));
            shapeLines.add(new SvgLineElement(left, bottom, right, bottom));
            shapeLines.add(new SvgLineElement(center, top, center, bottom));
            SvgGElement g = new SvgGElement();
            for (SvgLineElement shapeLine : shapeLines) {
                Intrinsics.checkNotNullExpressionValue((Object)shapeLine, (String)"shapeLine");
                GeomHelper.Companion.decorate$default(GeomHelper.Companion, (SvgNode)shapeLine, p, false, 4, null);
                g.children().add((Object)shapeLine);
            }
            return g;
        }

        private final SvgGElement errorBarShape(DoubleRectangle r, DataPointAesthetics p, GeomHelper geomHelper) {
            double left = r.getLeft();
            double top = r.getTop();
            double right = r.getRight();
            double bottom = r.getBottom();
            double center = left + r.getWidth() / (double)2;
            SvgGElement g = new SvgGElement();
            GeomHelper.SvgElementHelper elementHelper = geomHelper.createSvgElementHelper();
            elementHelper.setStrokeAlphaEnabled(true);
            ObservableList observableList = g.children();
            boolean bl = false;
            boolean bl2 = false;
            ObservableList $this$errorBarShape_u24lambda_u2d0 = observableList;
            boolean bl3 = false;
            $this$errorBarShape_u24lambda_u2d0.add((Object)elementHelper.createLine(new DoubleVector(left, top), new DoubleVector(right, top), p));
            $this$errorBarShape_u24lambda_u2d0.add((Object)elementHelper.createLine(new DoubleVector(left, bottom), new DoubleVector(right, bottom), p));
            $this$errorBarShape_u24lambda_u2d0.add((Object)elementHelper.createLine(new DoubleVector(center, top), new DoubleVector(center, bottom), p));
            return g;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

