/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.layout.PlotLayoutBase;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import jetbrains.datalore.plot.builder.layout.XYPlotLayoutUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/builder/layout/FacetGridPlotLayout;", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutBase;", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "tileLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "showFacetStrip", "", "(Ljetbrains/datalore/plot/builder/assemble/PlotFacets;Ljetbrains/datalore/plot/builder/layout/TileLayout;Z)V", "totalPanelHorizontalPadding", "", "totalPanelVerticalPadding", "doLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutInfo;", "preferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "layoutTile", "Ljetbrains/datalore/plot/builder/layout/FacetGridPlotLayout$MyTileInfo;", "tileWidth", "tileHeight", "tilesAreaSize", "tileInfo", "Companion", "MyTileInfo", "plot-builder-portable"})
public final class FacetGridPlotLayout
extends PlotLayoutBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PlotFacets facets;
    @NotNull
    private final TileLayout tileLayout;
    private final boolean showFacetStrip;
    private final double totalPanelHorizontalPadding;
    private final double totalPanelVerticalPadding;
    public static final double FACET_TAB_HEIGHT = 30.0;
    public static final int FACET_H_PADDING = 0;
    public static final int FACET_V_PADDING = 6;
    private static final double PANEL_PADDING = 10.0;

    public FacetGridPlotLayout(@NotNull PlotFacets facets, @NotNull TileLayout tileLayout, boolean showFacetStrip) {
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        Intrinsics.checkNotNullParameter((Object)tileLayout, (String)"tileLayout");
        this.facets = facets;
        this.tileLayout = tileLayout;
        this.showFacetStrip = showFacetStrip;
        this.totalPanelHorizontalPadding = 10.0 * (double)(this.facets.getColCount() - 1);
        this.totalPanelVerticalPadding = 10.0 * (double)(this.facets.getRowCount() - 1);
        this.setPadding(10.0, 10.0, 0.0, 0.0);
        boolean bl = this.facets.isDefined();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Undefined facets.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PlotLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider) {
        void var10_17;
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        DoubleVector tilesAreaSize = new DoubleVector(preferredSize.getX() - (this.getPaddingLeft() + this.getPaddingRight()), preferredSize.getY() - (this.getPaddingTop() + this.getPaddingBottom()));
        List<PlotFacets.FacetTileInfo> facetTiles = this.facets.tileInfos();
        if (this.showFacetStrip) {
            boolean bl;
            double totalAddedHeight;
            block18: {
                Collection $this$distinctBy$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Object v1;
                int $i$f$firstOrNull;
                Iterable<String> $this$firstOrNull$iv;
                block17: {
                    $this$firstOrNull$iv = (List<String>)facetTiles;
                    $i$f$firstOrNull = 0;
                    for (Object t : $this$firstOrNull$iv) {
                        PlotFacets.FacetTileInfo it = (PlotFacets.FacetTileInfo)t;
                        boolean bl2 = false;
                        Collection collection = it.getColLabs();
                        boolean bl3 = false;
                        boolean bl4 = !collection.isEmpty();
                        if (!bl4) continue;
                        v1 = t;
                        break block17;
                    }
                    v1 = null;
                }
                PlotFacets.FacetTileInfo facetTileInfo = v1;
                int tileColLabCounts = facetTileInfo == null ? 0 : (($this$firstOrNull$iv = facetTileInfo.getColLabs()) == null ? 0 : ($i$f$firstOrNull = $this$firstOrNull$iv.size()));
                $this$firstOrNull$iv = facetTiles;
                boolean $i$f$filter = false;
                Iterator iterator2 = $this$filter$iv;
                Collection collection = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PlotFacets.FacetTileInfo it = (PlotFacets.FacetTileInfo)element$iv$iv;
                    boolean bl5 = false;
                    Collection collection2 = it.getColLabs();
                    boolean bl6 = false;
                    boolean bl7 = !collection2.isEmpty();
                    if (!bl7) continue;
                    collection.add(element$iv$iv);
                }
                $this$filter$iv = (List)collection;
                boolean $i$f$distinctBy = false;
                HashSet<Integer> set$iv = new HashSet<Integer>();
                ArrayList arrayList = new ArrayList();
                for (Object e$iv : $this$distinctBy$iv) {
                    PlotFacets.FacetTileInfo it = (PlotFacets.FacetTileInfo)e$iv;
                    boolean bl8 = false;
                    Integer key$iv = it.getRow();
                    if (!set$iv.add(key$iv)) continue;
                    arrayList.add(e$iv);
                }
                $this$distinctBy$iv = arrayList;
                boolean bl9 = false;
                int tileWithColLabInRowCount = $this$distinctBy$iv.size();
                totalAddedHeight = Companion.facetColHeadHeight(tileColLabCounts) * (double)tileWithColLabInRowCount;
                Iterable iterable = facetTiles;
                boolean $i$f$any = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : iterable) {
                        PlotFacets.FacetTileInfo it = (PlotFacets.FacetTileInfo)element$iv;
                        boolean bl10 = false;
                        if (!(it.getRowLab() != null)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            boolean labsInRow = bl;
            DoubleVector doubleVector = new DoubleVector((double)labsInRow * 30.0, totalAddedHeight);
            tilesAreaSize = tilesAreaSize.subtract(doubleVector);
        }
        double tileWidth = (tilesAreaSize.getX() - this.totalPanelHorizontalPadding) / (double)this.facets.getColCount();
        double tileHeight = (tilesAreaSize.getY() - this.totalPanelVerticalPadding) / (double)this.facets.getRowCount();
        MyTileInfo tileInfo = this.layoutTile(tileWidth, tileHeight, coordProvider);
        boolean bl = false;
        do {
            void i = var10_17++;
            DoubleVector tilesAreaSizeNew = this.tilesAreaSize(tileInfo);
            double widthDiff = tilesAreaSize.getX() - tilesAreaSizeNew.getX();
            double heightDiff = tilesAreaSize.getY() - tilesAreaSizeNew.getY();
            boolean bl8 = false;
            if (Math.abs(widthDiff) <= (double)this.facets.getColCount()) {
                bl8 = false;
                if (Math.abs(heightDiff) <= (double)this.facets.getRowCount()) break;
            }
            double geomWidth = tileInfo.geomWidth$plot_builder_portable() + widthDiff / (double)this.facets.getColCount();
            double newPanelWidth = geomWidth + tileInfo.axisThicknessY$plot_builder_portable();
            double geomHeight = tileInfo.geomHeight$plot_builder_portable() + heightDiff / (double)this.facets.getRowCount();
            double newPanelHeight = geomHeight + tileInfo.axisThicknessX$plot_builder_portable();
            tileInfo = this.layoutTile(newPanelWidth, newPanelHeight, coordProvider);
        } while (var10_17 <= true);
        double d = tileInfo.axisThicknessX$plot_builder_portable();
        double axisThicknessY = tileInfo.axisThicknessY$plot_builder_portable();
        double geomWidth = tileInfo.geomWidth$plot_builder_portable();
        double geomHeight = tileInfo.geomHeight$plot_builder_portable();
        DoubleRectangle tilesAreaBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
        DoubleVector tilesAreaOffset = new DoubleVector(this.getPaddingLeft(), this.getPaddingTop());
        ArrayList<TileLayoutInfo> tileInfos = new ArrayList<TileLayoutInfo>();
        double offsetX = 0.0;
        double offsetY = 0.0;
        int currRow = 0;
        double prevHeight = 0.0;
        for (PlotFacets.FacetTileInfo facetTile : facetTiles) {
            double width2 = geomWidth;
            double geomX = 0.0;
            if (facetTile.getYAxis()) {
                width2 += axisThicknessY;
                geomX = axisThicknessY;
            }
            if (facetTile.getRowLab() != null && this.showFacetStrip) {
                width2 += 30.0;
            }
            double height = geomHeight;
            if (facetTile.getXAxis() && facetTile.getRow() == this.facets.getRowCount() - 1) {
                height += d;
            }
            double geomY = 0.0;
            if (this.showFacetStrip) {
                double addedHeight = Companion.facetColHeadHeight(facetTile.getColLabs().size());
                height += addedHeight;
                geomY = addedHeight;
            }
            DoubleRectangle bounds = new DoubleRectangle(0.0, 0.0, width2, height);
            DoubleRectangle geomBounds = new DoubleRectangle(geomX, geomY, geomWidth, geomHeight);
            int row = facetTile.getRow();
            if (row > currRow) {
                currRow = row;
                offsetY += prevHeight + 10.0;
            }
            prevHeight = height;
            int col = facetTile.getCol();
            if (col == 0) {
                offsetX = 0.0;
            }
            DoubleVector offset2 = new DoubleVector(offsetX, offsetY);
            offsetX += width2 + 10.0;
            TileLayoutInfo info = new TileLayoutInfo(bounds, geomBounds, XYPlotLayoutUtil.INSTANCE.clipBounds(geomBounds), tileInfo.getLayoutInfo$plot_builder_portable().getXAxisInfo(), tileInfo.getLayoutInfo$plot_builder_portable().getYAxisInfo(), facetTile.getXAxis(), facetTile.getYAxis(), facetTile.getTrueIndex()).withOffset(tilesAreaOffset.add(offset2));
            if (this.showFacetStrip) {
                info = info.withFacetLabels(facetTile.getColLabs(), facetTile.getRowLab());
            }
            tileInfos.add(info);
            tilesAreaBounds = tilesAreaBounds.union(info.getAbsoluteBounds(tilesAreaOffset));
        }
        DoubleVector plotSize2 = new DoubleVector(tilesAreaBounds.getRight() + this.getPaddingRight(), tilesAreaBounds.getHeight() + this.getPaddingBottom());
        return new PlotLayoutInfo((List<TileLayoutInfo>)tileInfos, plotSize2);
    }

    private final MyTileInfo layoutTile(double tileWidth, double tileHeight, CoordProvider coordProvider) {
        TileLayoutInfo layoutInfo = this.tileLayout.doLayout(new DoubleVector(tileWidth, tileHeight), coordProvider);
        return new MyTileInfo(layoutInfo);
    }

    private final DoubleVector tilesAreaSize(MyTileInfo tileInfo) {
        double w = tileInfo.geomWidth$plot_builder_portable() * (double)this.facets.getColCount() + this.totalPanelHorizontalPadding + tileInfo.axisThicknessY$plot_builder_portable();
        double h = tileInfo.geomHeight$plot_builder_portable() * (double)this.facets.getRowCount() + this.totalPanelVerticalPadding + tileInfo.axisThicknessX$plot_builder_portable();
        return new DoubleVector(w, h);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\r\u0010\n\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000bJ\r\u0010\f\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/layout/FacetGridPlotLayout$MyTileInfo;", "", "layoutInfo", "Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "(Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;)V", "getLayoutInfo$plot_builder_portable", "()Ljetbrains/datalore/plot/builder/layout/TileLayoutInfo;", "axisThicknessX", "", "axisThicknessX$plot_builder_portable", "axisThicknessY", "axisThicknessY$plot_builder_portable", "geomHeight", "geomHeight$plot_builder_portable", "geomWidth", "geomWidth$plot_builder_portable", "plot-builder-portable"})
    private static final class MyTileInfo {
        @NotNull
        private final TileLayoutInfo layoutInfo;

        public MyTileInfo(@NotNull TileLayoutInfo layoutInfo) {
            Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
            this.layoutInfo = layoutInfo;
        }

        @NotNull
        public final TileLayoutInfo getLayoutInfo$plot_builder_portable() {
            return this.layoutInfo;
        }

        public final double axisThicknessX$plot_builder_portable() {
            return this.layoutInfo.getBounds().getBottom() - this.layoutInfo.getGeomBounds().getBottom();
        }

        public final double axisThicknessY$plot_builder_portable() {
            return this.layoutInfo.getGeomBounds().getLeft() - this.layoutInfo.getBounds().getLeft();
        }

        public final double geomWidth$plot_builder_portable() {
            return this.layoutInfo.getGeomBounds().getWidth();
        }

        public final double geomHeight$plot_builder_portable() {
            return this.layoutInfo.getGeomBounds().getHeight();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/builder/layout/FacetGridPlotLayout$Companion;", "", "()V", "FACET_H_PADDING", "", "FACET_TAB_HEIGHT", "", "FACET_V_PADDING", "PANEL_PADDING", "facetColHeadHeight", "labCount", "facetColLabelSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "colWidth", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleVector facetColLabelSize(double colWidth) {
            return new DoubleVector(colWidth - 0.0, 18.0);
        }

        public final double facetColHeadHeight(int labCount) {
            return labCount > 0 ? this.facetColLabelSize(0.0).getY() * (double)labCount + (double)12 : 0.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

