/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.svg;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.observable.property.WritableProperty;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.vis.svg.SvgAttributeSpec;
import jetbrains.datalore.vis.svg.SvgColor;
import jetbrains.datalore.vis.svg.SvgGraphicsElement;
import jetbrains.datalore.vis.svg.SvgPlatformPeer;
import jetbrains.datalore.vis.svg.SvgShape;
import jetbrains.datalore.vis.svg.SvgTransform;
import jetbrains.datalore.vis.svg.SvgTransformable;
import jetbrains.datalore.vis.svg.SvgUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001&B'\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u0005\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019H\u0016J\u0010\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016H\u0016J\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016H\u0016J\u0010\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0019H\u0016J\u0010\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016H\u0016J\u0010\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016H\u0016J\u0010\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u0016H\u0016J\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016J\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016J\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0016R\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006'"}, d2={"Ljetbrains/datalore/vis/svg/SvgRectElement;", "Ljetbrains/datalore/vis/svg/SvgGraphicsElement;", "Ljetbrains/datalore/vis/svg/SvgTransformable;", "Ljetbrains/datalore/vis/svg/SvgShape;", "x", "", "y", "width", "height", "(DDDD)V", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "(Ljetbrains/datalore/base/geometry/DoubleRectangle;)V", "()V", "bBox", "getBBox", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "elementName", "", "getElementName", "()Ljava/lang/String;", "fill", "Ljetbrains/datalore/base/observable/property/Property;", "Ljetbrains/datalore/vis/svg/SvgColor;", "fillColor", "Ljetbrains/datalore/base/observable/property/WritableProperty;", "Ljetbrains/datalore/base/values/Color;", "fillOpacity", "pointToAbsoluteCoordinates", "Ljetbrains/datalore/base/geometry/DoubleVector;", "point", "pointToTransformedCoordinates", "stroke", "strokeColor", "strokeOpacity", "strokeWidth", "transform", "Ljetbrains/datalore/vis/svg/SvgTransform;", "Companion", "vis-svg-portable"})
public final class SvgRectElement
extends SvgGraphicsElement
implements SvgTransformable,
SvgShape {
    @NotNull
    private final String elementName;
    @NotNull
    private static final SvgAttributeSpec<Double> X;
    @NotNull
    private static final SvgAttributeSpec<Double> Y;
    @NotNull
    private static final SvgAttributeSpec<Double> WIDTH;
    @NotNull
    private static final SvgAttributeSpec<Double> HEIGHT;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getElementName() {
        return this.elementName;
    }

    @Override
    @NotNull
    public DoubleRectangle getBBox() {
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.getBBox(this);
    }

    @NotNull
    public final Property<Double> x() {
        return this.getAttribute(X);
    }

    @NotNull
    public final Property<Double> y() {
        return this.getAttribute(Y);
    }

    @NotNull
    public final Property<Double> height() {
        return this.getAttribute(HEIGHT);
    }

    @NotNull
    public final Property<Double> width() {
        return this.getAttribute(WIDTH);
    }

    @Override
    @NotNull
    public Property<SvgTransform> transform() {
        return this.getAttribute(SvgTransformable.Companion.getTRANSFORM());
    }

    @Override
    @NotNull
    public Property<SvgColor> fill() {
        return this.getAttribute(SvgShape.Companion.getFILL());
    }

    @Override
    @NotNull
    public WritableProperty<Color> fillColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$vis_svg_portable(this.fill(), this.fillOpacity());
    }

    @Override
    @NotNull
    public Property<Double> fillOpacity() {
        return this.getAttribute(SvgShape.Companion.getFILL_OPACITY());
    }

    @Override
    @NotNull
    public Property<SvgColor> stroke() {
        return this.getAttribute(SvgShape.Companion.getSTROKE());
    }

    @Override
    @NotNull
    public WritableProperty<Color> strokeColor() {
        return SvgUtils.INSTANCE.colorAttributeTransform$vis_svg_portable(this.stroke(), this.strokeOpacity());
    }

    @Override
    @NotNull
    public Property<Double> strokeOpacity() {
        return this.getAttribute(SvgShape.Companion.getSTROKE_OPACITY());
    }

    @Override
    @NotNull
    public Property<Double> strokeWidth() {
        return this.getAttribute(SvgShape.Companion.getSTROKE_WIDTH());
    }

    @Override
    @NotNull
    public DoubleVector pointToTransformedCoordinates(@NotNull DoubleVector point2) {
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.invertTransform(this, point2);
    }

    @Override
    @NotNull
    public DoubleVector pointToAbsoluteCoordinates(@NotNull DoubleVector point2) {
        Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
        SvgPlatformPeer svgPlatformPeer = this.container().getPeer();
        Intrinsics.checkNotNull((Object)svgPlatformPeer);
        return svgPlatformPeer.applyTransform(this, point2);
    }

    public SvgRectElement() {
        this.elementName = "rect";
    }

    public SvgRectElement(double x2, double y2, double width2, double height) {
        this();
        this.setAttribute(X, x2);
        this.setAttribute(Y, y2);
        this.setAttribute(HEIGHT, height);
        this.setAttribute(WIDTH, width2);
    }

    public SvgRectElement(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        this(rect2.getOrigin().getX(), rect2.getOrigin().getY(), rect2.getDimension().getX(), rect2.getDimension().getY());
    }

    static {
        Companion = new Companion(null);
        X = SvgAttributeSpec.Companion.createSpec("x");
        Y = SvgAttributeSpec.Companion.createSpec("y");
        WIDTH = SvgAttributeSpec.Companion.createSpec("width");
        HEIGHT = SvgAttributeSpec.Companion.createSpec("height");
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/vis/svg/SvgRectElement$Companion;", "", "()V", "HEIGHT", "Ljetbrains/datalore/vis/svg/SvgAttributeSpec;", "", "getHEIGHT", "()Ljetbrains/datalore/vis/svg/SvgAttributeSpec;", "WIDTH", "getWIDTH", "X", "getX", "Y", "getY", "vis-svg-portable"})
    public static final class Companion {
        @NotNull
        public final SvgAttributeSpec<Double> getX() {
            return X;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getY() {
            return Y;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getWIDTH() {
            return WIDTH;
        }

        @NotNull
        public final SvgAttributeSpec<Double> getHEIGHT() {
            return HEIGHT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

