/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.vis.canvas.javaFx;

import java.util.Arrays;
import javafx.geometry.Bounds;
import javafx.geometry.VPos;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.math.MathKt;
import jetbrains.datalore.vis.canvas.Canvas;
import jetbrains.datalore.vis.canvas.Context2d;
import jetbrains.datalore.vis.canvas.CssFontParser;
import jetbrains.datalore.vis.canvas.javaFx.JavafxCanvas;
import jetbrains.datalore.vis.canvas.javaFx.JavafxContext2d$WhenMappings;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0013\n\u0002\b\u0011\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0006H\u0016J8\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0006H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J \u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J0\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0016JP\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/2\u0006\u00102\u001a\u00020\b2\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\b2\u0006\u00100\u001a\u00020\b2\u0006\u00101\u001a\u00020\bH\u0016J\b\u00108\u001a\u00020\u0006H\u0016J\u0010\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020\u0006H\u0016J(\u0010<\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\bH\u0016J \u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0018\u0010A\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010B\u001a\u00020\b2\u0006\u0010C\u001a\u00020\u001cH\u0016J\u0018\u0010B\u001a\u00020D2\u0006\u0010C\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020\u001cH\u0016J\u0018\u0010F\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J(\u0010G\u001a\u00020\u00062\u0006\u0010H\u001a\u00020\b2\u0006\u0010I\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010J\u001a\u00020\u0006H\u0016J\u0010\u0010K\u001a\u00020\u00062\u0006\u0010L\u001a\u00020\bH\u0016J\b\u0010M\u001a\u00020\u0006H\u0016J\u0018\u0010N\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0012\u0010O\u001a\u00020\u00062\b\u0010P\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010Q\u001a\u00020\u00062\u0006\u0010R\u001a\u00020\u001cH\u0016J\u0010\u0010S\u001a\u00020\u00062\u0006\u0010T\u001a\u00020\bH\u0016J\u0010\u0010U\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010V\u001a\u00020\u00062\u0006\u0010W\u001a\u00020XH\u0016J\u0010\u0010Y\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010Z\u001a\u00020\u00062\u0006\u0010[\u001a\u00020\bH\u0016J\u0012\u0010\\\u001a\u00020\u00062\b\u0010P\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010]\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010^\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,H\u0016J8\u0010_\u001a\u00020\u00062\u0006\u0010`\u001a\u00020\b2\u0006\u0010a\u001a\u00020\b2\u0006\u0010b\u001a\u00020\b2\u0006\u0010c\u001a\u00020\b2\u0006\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\bH\u0016J\b\u0010d\u001a\u00020\u0006H\u0016J(\u0010e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020\bH\u0016J \u0010f\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J8\u0010g\u001a\u00020\u00062\u0006\u0010`\u001a\u00020\b2\u0006\u0010a\u001a\u00020\b2\u0006\u0010b\u001a\u00020\b2\u0006\u0010c\u001a\u00020\b2\u0006\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\bH\u0016J\u0018\u0010h\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Ljetbrains/datalore/vis/canvas/javaFx/JavafxContext2d;", "Ljetbrains/datalore/vis/canvas/Context2d;", "myContext2d", "Ljavafx/scene/canvas/GraphicsContext;", "(Ljavafx/scene/canvas/GraphicsContext;)V", "arc", "", "x", "", "y", "radius", "startAngle", "endAngle", "anticlockwise", "", "beginPath", "bezierCurveTo", "cp1x", "cp1y", "cp2x", "cp2y", "clearRect", "rect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "closePath", "convertCssFont", "Ljavafx/scene/text/Font;", "fontString", "", "convertLineCap", "Ljavafx/scene/shape/StrokeLineCap;", "lineCap", "Ljetbrains/datalore/vis/canvas/Context2d$LineCap;", "convertLineJoin", "Ljavafx/scene/shape/StrokeLineJoin;", "lineJoin", "Ljetbrains/datalore/vis/canvas/Context2d$LineJoin;", "convertTextAlign", "Ljavafx/scene/text/TextAlignment;", "align", "Ljetbrains/datalore/vis/canvas/Context2d$TextAlign;", "convertTextBaseline", "Ljavafx/geometry/VPos;", "baseline", "Ljetbrains/datalore/vis/canvas/Context2d$TextBaseline;", "drawImage", "snapshot", "Ljetbrains/datalore/vis/canvas/Canvas$Snapshot;", "dw", "dh", "sx", "sy", "sw", "sh", "dx", "dy", "fill", "fillRule", "Ljavafx/scene/shape/FillRule;", "fillEvenOdd", "fillRect", "w", "h", "fillText", "text", "lineTo", "measureText", "str", "Ljetbrains/datalore/base/geometry/DoubleVector;", "font", "moveTo", "quadraticCurveTo", "cpx", "cpy", "restore", "rotate", "angle", "save", "scale", "setFillStyle", "color", "setFont", "f", "setGlobalAlpha", "alpha", "setLineCap", "setLineDash", "lineDash", "", "setLineJoin", "setLineWidth", "lineWidth", "setStrokeStyle", "setTextAlign", "setTextBaseline", "setTransform", "m11", "m12", "m21", "m22", "stroke", "strokeRect", "strokeText", "transform", "translate", "vis-canvas"})
public final class JavafxContext2d
implements Context2d {
    private final GraphicsContext myContext2d;

    private final StrokeLineJoin convertLineJoin(Context2d.LineJoin lineJoin) {
        StrokeLineJoin strokeLineJoin;
        switch (JavafxContext2d$WhenMappings.$EnumSwitchMapping$0[lineJoin.ordinal()]) {
            case 1: {
                strokeLineJoin = StrokeLineJoin.BEVEL;
                break;
            }
            case 2: {
                strokeLineJoin = StrokeLineJoin.MITER;
                break;
            }
            case 3: {
                strokeLineJoin = StrokeLineJoin.ROUND;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return strokeLineJoin;
    }

    private final StrokeLineCap convertLineCap(Context2d.LineCap lineCap) {
        StrokeLineCap strokeLineCap;
        switch (JavafxContext2d$WhenMappings.$EnumSwitchMapping$1[lineCap.ordinal()]) {
            case 1: {
                strokeLineCap = StrokeLineCap.BUTT;
                break;
            }
            case 2: {
                strokeLineCap = StrokeLineCap.ROUND;
                break;
            }
            case 3: {
                strokeLineCap = StrokeLineCap.SQUARE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return strokeLineCap;
    }

    private final VPos convertTextBaseline(Context2d.TextBaseline baseline) {
        VPos vPos;
        switch (JavafxContext2d$WhenMappings.$EnumSwitchMapping$2[baseline.ordinal()]) {
            case 1: {
                vPos = VPos.BOTTOM;
                break;
            }
            case 2: {
                vPos = VPos.BOTTOM;
                break;
            }
            case 3: {
                vPos = VPos.TOP;
                break;
            }
            case 4: {
                vPos = VPos.BOTTOM;
                break;
            }
            case 5: {
                vPos = VPos.CENTER;
                break;
            }
            case 6: {
                vPos = VPos.TOP;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return vPos;
    }

    private final TextAlignment convertTextAlign(Context2d.TextAlign align) {
        TextAlignment textAlignment;
        switch (JavafxContext2d$WhenMappings.$EnumSwitchMapping$3[align.ordinal()]) {
            case 1: {
                textAlignment = TextAlignment.CENTER;
                break;
            }
            case 2: {
                textAlignment = TextAlignment.RIGHT;
                break;
            }
            case 3: {
                textAlignment = TextAlignment.LEFT;
                break;
            }
            case 4: {
                textAlignment = TextAlignment.RIGHT;
                break;
            }
            case 5: {
                textAlignment = TextAlignment.LEFT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return textAlignment;
    }

    private final Font convertCssFont(String fontString) {
        Font font;
        CssFontParser cssFontParser = CssFontParser.Companion.create(fontString);
        if (cssFontParser == null) {
            throw (Throwable)new IllegalStateException("Could not parse css font string: " + fontString);
        }
        CssFontParser parser = cssFontParser;
        String family = parser.getFontFamily();
        Double size2 = parser.getFontSize();
        if (size2 == null) {
            Font font2 = Font.font((String)family);
            font = font2;
            Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"Font.font(family)");
        } else {
            Font font3 = Font.font((String)family, (double)size2);
            font = font3;
            Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"Font.font(family, size)");
        }
        return font;
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        JavafxCanvas.JavafxSnapshot javafxSnapshot = (JavafxCanvas.JavafxSnapshot)snapshot;
        this.myContext2d.drawImage(javafxSnapshot.getImage(), x2, y2);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double x2, double y2, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        JavafxCanvas.JavafxSnapshot javafxSnapshot = (JavafxCanvas.JavafxSnapshot)snapshot;
        this.myContext2d.drawImage(javafxSnapshot.getImage(), x2, y2, dw, dh);
    }

    @Override
    public void drawImage(@NotNull Canvas.Snapshot snapshot, double sx, double sy, double sw, double sh, double dx, double dy, double dw, double dh) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        JavafxCanvas.JavafxSnapshot javafxSnapshot = (JavafxCanvas.JavafxSnapshot)snapshot;
        this.myContext2d.drawImage(javafxSnapshot.getImage(), sx, sy, sw, sh, dx, dy, dw, dh);
    }

    @Override
    public void beginPath() {
        this.myContext2d.beginPath();
    }

    @Override
    public void closePath() {
        this.myContext2d.closePath();
    }

    @Override
    public void stroke() {
        this.myContext2d.stroke();
    }

    @Override
    public void fill() {
        this.fill(FillRule.NON_ZERO);
    }

    @Override
    public void fillEvenOdd() {
        this.fill(FillRule.EVEN_ODD);
    }

    @Override
    public void fillRect(double x2, double y2, double w, double h) {
        this.myContext2d.fillRect(x2, y2, w, h);
    }

    @Override
    public void moveTo(double x2, double y2) {
        this.myContext2d.moveTo(x2, y2);
    }

    @Override
    public void lineTo(double x2, double y2) {
        this.myContext2d.lineTo(x2, y2);
    }

    @Override
    public void arc(double x2, double y2, double radius, double startAngle, double endAngle, boolean anticlockwise) {
        double s2 = MathKt.toDegrees(startAngle);
        double e = MathKt.toDegrees(endAngle);
        if (anticlockwise) {
            s2 = s2 < e ? s2 + (double)360 : s2;
        } else {
            e = e < s2 ? e + (double)360 : e;
        }
        this.myContext2d.arc(x2, y2, radius, radius, -s2, s2 - e);
    }

    @Override
    public void save() {
        this.myContext2d.save();
    }

    @Override
    public void restore() {
        this.myContext2d.restore();
    }

    @Override
    public void setFillStyle(@Nullable String color) {
        this.myContext2d.setFill(color != null ? (Paint)Color.valueOf((String)color) : null);
    }

    @Override
    public void setStrokeStyle(@Nullable String color) {
        this.myContext2d.setStroke(color != null ? (Paint)Color.valueOf((String)color) : null);
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.myContext2d.setGlobalAlpha(alpha);
    }

    @Override
    public void setFont(@NotNull String f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.myContext2d.setFont(this.convertCssFont(f));
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.myContext2d.setLineWidth(lineWidth);
    }

    @Override
    public void strokeRect(double x2, double y2, double w, double h) {
        this.myContext2d.strokeRect(x2, y2, w, h);
    }

    @Override
    public void strokeText(@NotNull String text, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.myContext2d.strokeText(text, x2, y2);
    }

    @Override
    public void fillText(@NotNull String text, double x2, double y2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.myContext2d.fillText(text, x2, y2);
    }

    @Override
    public void scale(double x2, double y2) {
        this.myContext2d.scale(x2, y2);
    }

    @Override
    public void rotate(double angle) {
        this.myContext2d.rotate(MathKt.toDegrees(angle));
    }

    @Override
    public void translate(double x2, double y2) {
        this.myContext2d.translate(x2, y2);
    }

    @Override
    public void transform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.myContext2d.transform(m11, m12, m21, m22, dx, dy);
    }

    @Override
    public void bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x2, double y2) {
        this.myContext2d.bezierCurveTo(cp1x, cp1y, cp2x, cp2y, x2, y2);
    }

    @Override
    public void quadraticCurveTo(double cpx, double cpy, double x2, double y2) {
        this.myContext2d.quadraticCurveTo(cpx, cpy, x2, y2);
    }

    @Override
    public void setLineJoin(@NotNull Context2d.LineJoin lineJoin) {
        Intrinsics.checkNotNullParameter((Object)((Object)lineJoin), (String)"lineJoin");
        this.myContext2d.setLineJoin(this.convertLineJoin(lineJoin));
    }

    @Override
    public void setLineCap(@NotNull Context2d.LineCap lineCap) {
        Intrinsics.checkNotNullParameter((Object)((Object)lineCap), (String)"lineCap");
        this.myContext2d.setLineCap(this.convertLineCap(lineCap));
    }

    @Override
    public void setTextBaseline(@NotNull Context2d.TextBaseline baseline) {
        Intrinsics.checkNotNullParameter((Object)((Object)baseline), (String)"baseline");
        this.myContext2d.setTextBaseline(this.convertTextBaseline(baseline));
    }

    @Override
    public void setTextAlign(@NotNull Context2d.TextAlign align) {
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        this.myContext2d.setTextAlign(this.convertTextAlign(align));
    }

    @Override
    public void setTransform(double m11, double m12, double m21, double m22, double dx, double dy) {
        this.myContext2d.setTransform(m11, m12, m21, m22, dx, dy);
    }

    @Override
    public void setLineDash(@NotNull double[] lineDash) {
        Intrinsics.checkNotNullParameter((Object)lineDash, (String)"lineDash");
        this.myContext2d.setLineDashes(Arrays.copyOf(lineDash, lineDash.length));
    }

    @Override
    public double measureText(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Text text = new Text(str);
        text.setFont(this.myContext2d.getFont());
        Bounds bounds = text.getLayoutBounds();
        Intrinsics.checkNotNullExpressionValue((Object)bounds, (String)"text.layoutBounds");
        return bounds.getWidth();
    }

    @Override
    @NotNull
    public DoubleVector measureText(@NotNull String str, @NotNull String font) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Text text = new Text(str);
        text.setFont(this.convertCssFont(font));
        Bounds bounds = text.getLayoutBounds();
        Intrinsics.checkNotNullExpressionValue((Object)bounds, (String)"text.layoutBounds");
        double d = bounds.getWidth();
        Bounds bounds2 = text.getLayoutBounds();
        Intrinsics.checkNotNullExpressionValue((Object)bounds2, (String)"text.layoutBounds");
        return new DoubleVector(d, bounds2.getHeight());
    }

    @Override
    public void clearRect(@NotNull DoubleRectangle rect2) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        this.myContext2d.clearRect(rect2.getLeft(), rect2.getTop(), rect2.getWidth(), rect2.getHeight());
    }

    private final void fill(FillRule fillRule) {
        this.myContext2d.setFillRule(fillRule);
        this.myContext2d.fill();
    }

    public JavafxContext2d(@NotNull GraphicsContext myContext2d) {
        Intrinsics.checkNotNullParameter((Object)myContext2d, (String)"myContext2d");
        this.myContext2d = myContext2d;
    }
}

