/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.gcommon.collect.Lists;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.builder.VarBinding;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.assemble.TypedScaleMap;
import jetbrains.datalore.plot.builder.assemble.TypedScaleProviderMap;
import jetbrains.datalore.plot.builder.scale.ScaleProvider;
import jetbrains.datalore.plot.builder.scale.ScaleProviderHelper;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.plot.config.BunchConfig;
import jetbrains.datalore.plot.config.LayerConfig;
import jetbrains.datalore.plot.config.OptionsAccessor;
import jetbrains.datalore.plot.config.PlotConfig;
import jetbrains.datalore.plot.config.PlotConfigUtil;
import jetbrains.datalore.plot.config.ScaleConfig;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ!\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\r0\fH\u0000\u00a2\u0006\u0002\b\u000eJ+\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u000e\u0010\u0018\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0019J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u000e\u0010\u001b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0019H\u0002J(\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\f0\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\f2\u0006\u0010\u001f\u001a\u00020 \u00a8\u0006!"}, d2={"Ljetbrains/datalore/plot/config/PlotConfigUtil;", "", "()V", "addComputationMessage", "", "accessor", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "message", "", "createScaleProviders", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleProviderMap;", "scaleConfigs", "", "Ljetbrains/datalore/plot/config/ScaleConfig;", "createScaleProviders$plot_config_portable", "createScales", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "layerConfigs", "Ljetbrains/datalore/plot/config/LayerConfig;", "scaleProvidersMap", "isClientSide", "", "createScales$plot_config_portable", "findComputationMessages", "spec", "", "getComputationMessages", "opts", "toLayersDataByTile", "Ljetbrains/datalore/plot/base/DataFrame;", "dataByLayer", "facets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "plot-config-portable"})
public final class PlotConfigUtil {
    public static final PlotConfigUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<DataFrame>> toLayersDataByTile(@NotNull List<DataFrame> dataByLayer, @NotNull PlotFacets facets) {
        Intrinsics.checkNotNullParameter(dataByLayer, (String)"dataByLayer");
        Intrinsics.checkNotNullParameter((Object)facets, (String)"facets");
        ArrayList layersDataByTile = new ArrayList();
        layersDataByTile.add(new ArrayList());
        List xLevels = CollectionsKt.emptyList();
        List yLevels = CollectionsKt.emptyList();
        boolean hasFacets = facets.isDefined();
        if (hasFacets) {
            List list2 = facets.getXLevels();
            Intrinsics.checkNotNull(list2);
            xLevels = list2;
            List list3 = facets.getYLevels();
            Intrinsics.checkNotNull(list3);
            yLevels = list3;
            if (xLevels.isEmpty()) {
                xLevels = CollectionsKt.listOf(null);
            }
            if (yLevels.isEmpty()) {
                yLevels = CollectionsKt.listOf(null);
            }
            int numTiles = xLevels.size() * yLevels.size();
            while (layersDataByTile.size() < numTiles) {
                layersDataByTile.add(new ArrayList());
            }
        }
        for (DataFrame layerData : dataByLayer) {
            if (!hasFacets) {
                ((List)layersDataByTile.get(0)).add(layerData);
                continue;
            }
            int n = 0;
            int n2 = ((Collection)yLevels).size();
            while (n < n2) {
                void row;
                Object yLevel = yLevels.get((int)row);
                int n3 = 0;
                int n4 = ((Collection)xLevels).size();
                while (n3 < n4) {
                    void col;
                    Object xLevel = xLevels.get((int)col);
                    DataFrame panelLayerData = facets.dataSubset(layerData, xLevel, yLevel);
                    void panelIndex = row * xLevels.size() + col;
                    ((List)layersDataByTile.get((int)panelIndex)).add(panelLayerData);
                    ++col;
                }
                ++row;
            }
        }
        return layersDataByTile;
    }

    public final void addComputationMessage(@NotNull OptionsAccessor accessor, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
        Preconditions.INSTANCE.checkArgument(message != null);
        ArrayList<String> computationMessages = new ArrayList<String>((Collection)this.getComputationMessages(accessor));
        String string = message;
        Intrinsics.checkNotNull((Object)string);
        computationMessages.add(string);
        accessor.update("computation_messages", computationMessages);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> findComputationMessages(@NotNull Map<?, ?> spec) {
        List list2;
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        if (PlotConfig.Companion.isPlotSpec(spec)) {
            list2 = this.getComputationMessages(spec);
        } else if (PlotConfig.Companion.isGGBunchSpec(spec)) {
            void $this$flatMapTo$iv$iv;
            BunchConfig bunchConfig = new BunchConfig(spec);
            Iterable $this$flatMap$iv = bunchConfig.getBunchItems();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                BunchConfig.BunchItem it = (BunchConfig.BunchItem)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = INSTANCE.getComputationMessages(it.getFeatureSpec());
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            throw (Throwable)new RuntimeException("Unexpected plot spec kind: " + PlotConfig.Companion.specKind(spec));
        }
        List result = list2;
        return CollectionsKt.distinct((Iterable)result);
    }

    private final List<String> getComputationMessages(Map<?, ?> opts) {
        return this.getComputationMessages(OptionsAccessor.Companion.over(opts));
    }

    private final List<String> getComputationMessages(OptionsAccessor accessor) {
        return Lists.INSTANCE.transform(accessor.getList("computation_messages"), getComputationMessages.1.INSTANCE);
    }

    @NotNull
    public final TypedScaleProviderMap createScaleProviders$plot_config_portable(@NotNull List<ScaleConfig<Object>> scaleConfigs) {
        Intrinsics.checkNotNullParameter(scaleConfigs, (String)"scaleConfigs");
        HashMap scaleProviderByAes = new HashMap();
        for (ScaleConfig<Object> scaleConfig : scaleConfigs) {
            ScaleProvider<Object> scaleProvider = scaleConfig.createScaleProvider();
            ((Map)scaleProviderByAes).put(scaleConfig.getAes(), scaleProvider);
        }
        return new TypedScaleProviderMap(scaleProviderByAes);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypedScaleMap createScales$plot_config_portable(@NotNull List<LayerConfig> layerConfigs, @NotNull TypedScaleProviderMap scaleProvidersMap, boolean isClientSide) {
        ScaleProvider scaleProvider22;
        Iterable $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        Object aes;
        Iterable it$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Object object;
        Iterator<Object> value$iv;
        Object variable;
        Map.Entry varBinding;
        Object object2;
        Object object3;
        Iterator $this$mapTo$iv$iv2;
        Object object4;
        Object element$iv$iv2;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(layerConfigs, (String)"layerConfigs");
        Intrinsics.checkNotNullParameter((Object)scaleProvidersMap, (String)"scaleProvidersMap");
        Iterable $this$flatMap$iv = layerConfigs;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv3;
            VarBinding it;
            Iterable $this$filterTo$iv$iv;
            LayerConfig layer = (LayerConfig)element$iv$iv2;
            boolean bl = false;
            Iterable $this$filter$iv = layer.getVarBindings();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                it = (VarBinding)element$iv$iv3;
                boolean bl2 = false;
                if (!(isClientSide || !it.getVariable().isStat())) continue;
                destination$iv$iv3.add(element$iv$iv3);
            }
            Iterable $this$map$iv2 = (List)destination$iv$iv3;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                it = (VarBinding)item$iv$iv;
                object4 = destination$iv$iv3;
                boolean bl3 = false;
                Pair pair2 = TuplesKt.to((Object)it, (Object)layer.getCombinedData());
                object4.add(pair2);
            }
            Iterable list$iv$iv = (List)destination$iv$iv3;
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Map dataByVarBinding = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        Iterable $this$map$iv3 = dataByVarBinding.keySet();
        boolean $i$f$map2 = false;
        destination$iv$iv2 = $this$map$iv3;
        Object destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo = false;
        element$iv$iv2 = $this$mapTo$iv$iv2.iterator();
        while (element$iv$iv2.hasNext()) {
            void it;
            Object item$iv$iv = element$iv$iv2.next();
            VarBinding bl = (VarBinding)item$iv$iv;
            object3 = destination$iv$iv4;
            boolean bl42 = false;
            ScaleProvider<?> scaleProvider = ScaleProviderHelper.INSTANCE.getOrCreateDefault(it.getAes(), scaleProvidersMap);
            object2 = TuplesKt.to(it.getAes(), scaleProvider);
            object3.add(object2);
        }
        Map scaleProvidersByMappedAes = MapsKt.toMap((Iterable)((List)destination$iv$iv4));
        HashSet discreteMappedAes = new HashSet();
        destination$iv$iv4 = dataByVarBinding;
        $i$f$mapTo = false;
        for (Map.Entry $i$f$map2 : destination$iv$iv4.entrySet()) {
            element$iv$iv2 = $i$f$map2;
            boolean item$iv$iv = false;
            destination$iv$iv4 = (VarBinding)element$iv$iv2.getKey();
            element$iv$iv2 = $i$f$map2;
            item$iv$iv = false;
            DataFrame data = (DataFrame)element$iv$iv2.getValue();
            variable = ((VarBinding)((Object)varBinding)).getVariable();
            item$iv$iv = data.has((DataFrame.Variable)variable);
            boolean it = false;
            boolean bl42 = false;
            if (!item$iv$iv) {
                boolean bl = false;
                String bl42 = "Undefined variable: '" + ((DataFrame.Variable)variable).getName() + "'. Variables in data frame: " + data.variables();
                throw (Throwable)new IllegalArgumentException(bl42.toString());
            }
            Aes<?> aes2 = ((VarBinding)((Object)varBinding)).getAes();
            Object v = scaleProvidersByMappedAes.get(aes2);
            Intrinsics.checkNotNull(v);
            ScaleProvider scaleProvider = (ScaleProvider)v;
            if (!scaleProvider.getDiscreteDomain() && data.isNumeric((DataFrame.Variable)variable)) continue;
            discreteMappedAes.add(aes2);
        }
        HashMap discreteDomainByAes = new HashMap();
        HashMap continuousDomainByAesRaw = new HashMap();
        variable = dataByVarBinding;
        boolean aes2 = false;
        Iterator data = variable.entrySet().iterator();
        while (data.hasNext()) {
            void varBinding2;
            Map.Entry scaleProvider = varBinding = data.next();
            boolean bl42 = false;
            variable = (VarBinding)scaleProvider.getKey();
            scaleProvider = varBinding;
            bl42 = false;
            DataFrame data2 = (DataFrame)scaleProvider.getValue();
            Aes<?> aes3 = varBinding2.getAes();
            DataFrame.Variable variable2 = varBinding2.getVariable();
            if (discreteMappedAes.contains(aes3)) {
                Object object5;
                Object object6 = discreteDomainByAes;
                Object object7 = aes3;
                Map $this$getOrPut$iv = discreteDomainByAes;
                boolean $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(aes3);
                if (value$iv == null) {
                    object2 = object7;
                    object3 = object6;
                    boolean bl = false;
                    object = SetsKt.emptySet();
                    object6 = object3;
                    object7 = object2;
                    Collection answer$iv = object;
                    $this$getOrPut$iv.put(aes3, answer$iv);
                    object5 = answer$iv;
                } else {
                    object5 = value$iv;
                }
                object6.put(object7, CollectionsKt.plus((Collection)((Collection)object5), (Iterable)data2.distinctValues(variable2)));
                continue;
            }
            ((Map)continuousDomainByAesRaw).put(aes3, SeriesUtil.INSTANCE.span((ClosedRange)continuousDomainByAesRaw.get(aes3), data2.range(variable2)));
        }
        Map $this$mapValues$iv = continuousDomainByAesRaw;
        boolean $i$f$mapValues = false;
        Map data2 = $this$mapValues$iv;
        Map destination$iv$iv5 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            Object item$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            item$iv$iv = destination$iv$iv5;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            object4 = (Map.Entry)element$iv$iv$iv;
            object2 = k;
            object3 = item$iv$iv;
            boolean bl5 = false;
            object = SeriesUtil.INSTANCE.ensureApplicableRange((ClosedRange)it.getValue());
            object3.put(object2, object);
        }
        Map continuousDomainByAes = destination$iv$iv5;
        HashMap variablesByMappedAes = new HashMap();
        Map.Entry entry2 = dataByVarBinding.keySet().iterator();
        while (entry2.hasNext()) {
            Object object8;
            VarBinding varBinding3 = (VarBinding)entry2.next();
            Aes<?> aes4 = varBinding3.getAes();
            DataFrame.Variable variable3 = varBinding3.getVariable();
            Map $this$getOrPut$iv = variablesByMappedAes;
            boolean $i$f$getOrPut = false;
            value$iv = $this$getOrPut$iv.get(aes4);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(aes4, answer$iv);
                object8 = answer$iv;
            } else {
                object8 = value$iv;
            }
            ((List)object8).add(variable3);
        }
        HashMap scaleByMappedAes = new HashMap();
        Object variable3 = discreteDomainByAes;
        boolean $this$getOrPut$iv = false;
        Iterator iterator2 = variable3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry $i$f$getOrPut = entry2 = iterator2.next();
            boolean value$iv2 = false;
            variable3 = (Aes)$i$f$getOrPut.getKey();
            $i$f$getOrPut = entry2;
            value$iv2 = false;
            Collection discreteDomain = (Collection)$i$f$getOrPut.getValue();
            Object v = variablesByMappedAes.get(aes);
            Intrinsics.checkNotNull(v);
            Intrinsics.checkNotNullExpressionValue(v, (String)"variablesByMappedAes[aes]!!");
            $this$map$iv = (Iterable)v;
            boolean $i$f$map3 = false;
            it$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataFrame.Variable bl5 = (DataFrame.Variable)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl = false;
                object2 = it.getLabel();
                object3.add(object2);
            }
            String defaultName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
            Object v2 = scaleProvidersByMappedAes.get(aes);
            Intrinsics.checkNotNull(v2);
            scaleProvider22 = (ScaleProvider)v2;
            ((Map)scaleByMappedAes).put(aes, scaleProvider22.createScale(defaultName, discreteDomain));
        }
        aes = continuousDomainByAes;
        boolean discreteDomain = false;
        for (Map.Entry entry2 : aes.entrySet()) {
            Object defaultName = entry2;
            boolean scaleProvider22 = false;
            aes = (Aes)defaultName.getKey();
            defaultName = entry2;
            scaleProvider22 = false;
            ClosedRange continuousDomain = (ClosedRange)defaultName.getValue();
            Object v = variablesByMappedAes.get(aes);
            Intrinsics.checkNotNull(v);
            Intrinsics.checkNotNullExpressionValue(v, (String)"variablesByMappedAes[aes]!!");
            $this$map$iv = (Iterable)v;
            boolean $i$f$map4 = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DataFrame.Variable it = (DataFrame.Variable)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl = false;
                object2 = it.getLabel();
                object3.add(object2);
            }
            defaultName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
            Object v3 = scaleProvidersByMappedAes.get(aes);
            Intrinsics.checkNotNull(v3);
            scaleProvider22 = (ScaleProvider)v3;
            ((Map)scaleByMappedAes).put(aes, scaleProvider22.createScale((String)defaultName, continuousDomain));
        }
        return new TypedScaleMap(scaleByMappedAes);
    }

    private PlotConfigUtil() {
    }

    static {
        PlotConfigUtil plotConfigUtil;
        INSTANCE = plotConfigUtil = new PlotConfigUtil();
    }
}

