/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.config.OptionsAccessor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\b\u0010\u0013\u001a\u00020\u0006H\u0002J\b\u0010\u0014\u001a\u00020\u0006H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0013\u0010\b\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/config/FacetConfig;", "Ljetbrains/datalore/plot/config/OptionsAccessor;", "options", "", "(Ljava/util/Map;)V", "isGrid", "", "()Z", "x", "", "getX", "()Ljava/lang/String;", "y", "getY", "createFacets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "dataList", "", "Ljetbrains/datalore/plot/base/DataFrame;", "hasX", "hasY", "plot-config-portable"})
public final class FacetConfig
extends OptionsAccessor {
    public final boolean isGrid() {
        return true;
    }

    @Nullable
    public final String getX() {
        Preconditions.INSTANCE.checkState(this.hasX(), "No facet x specified");
        return this.getString("x");
    }

    @Nullable
    public final String getY() {
        Preconditions.INSTANCE.checkState(this.hasY(), "No facet y specified");
        return this.getString("y");
    }

    private final boolean hasX() {
        return this.has("x");
    }

    private final boolean hasY() {
        return this.has("y");
    }

    @NotNull
    public final PlotFacets createFacets(@NotNull List<DataFrame> dataList) {
        Intrinsics.checkNotNullParameter(dataList, (String)"dataList");
        String nameX = null;
        LinkedHashSet<Object> levelsX = new LinkedHashSet<Object>();
        if (this.hasX()) {
            nameX = this.getX();
            for (DataFrame data : dataList) {
                String string = nameX;
                Intrinsics.checkNotNull((Object)string);
                if (!DataFrameUtil.INSTANCE.hasVariable(data, string)) continue;
                DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, nameX);
                levelsX.addAll(DataFrameUtil.INSTANCE.distinctValues(data, variable));
            }
        }
        String nameY = null;
        LinkedHashSet<Object> levelsY = new LinkedHashSet<Object>();
        if (this.hasY()) {
            nameY = this.getY();
            for (DataFrame data : dataList) {
                String string = nameY;
                Intrinsics.checkNotNull((Object)string);
                if (!DataFrameUtil.INSTANCE.hasVariable(data, string)) continue;
                DataFrame.Variable variable = DataFrameUtil.INSTANCE.findVariableOrFail(data, nameY);
                levelsY.addAll(DataFrameUtil.INSTANCE.distinctValues(data, variable));
            }
        }
        return new PlotFacets(nameX, nameY, new ArrayList(levelsX), new ArrayList(levelsY));
    }

    public FacetConfig(@NotNull Map<?, ?> options) {
        Intrinsics.checkNotNullParameter(options, (String)"options");
        super(options, MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)"grid")));
    }
}

