/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.common.time.interval;

import java.util.List;
import jetbrains.datalore.base.datetime.Duration;
import jetbrains.datalore.plot.common.data.DataType;
import jetbrains.datalore.plot.common.text.Formatter;
import jetbrains.datalore.plot.common.time.interval.DurationInterval;
import jetbrains.datalore.plot.common.time.interval.MonthInterval;
import jetbrains.datalore.plot.common.time.interval.QuarterInterval;
import jetbrains.datalore.plot.common.time.interval.SemesterInterval;
import jetbrains.datalore.plot.common.time.interval.TimeInterval$Companion$WhenMappings;
import jetbrains.datalore.plot.common.time.interval.YearInterval;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0004\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/common/time/interval/TimeInterval;", "", "count", "", "(I)V", "getCount", "()I", "tickFormatPattern", "", "getTickFormatPattern", "()Ljava/lang/String;", "tickFormatter", "Lkotlin/Function1;", "getTickFormatter", "()Lkotlin/jvm/functions/Function1;", "range", "", "", "start", "end", "Companion", "plot-common-portable"})
public abstract class TimeInterval {
    private final int count;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract String getTickFormatPattern();

    @NotNull
    public Function1<Object, String> getTickFormatter() {
        return Formatter.INSTANCE.time(this.getTickFormatPattern());
    }

    @NotNull
    public abstract List<Double> range(double var1, double var3);

    public final int getCount() {
        return this.count;
    }

    protected TimeInterval(int count2) {
        this.count = count2;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0013"}, d2={"Ljetbrains/datalore/plot/common/time/interval/TimeInterval$Companion;", "", "()V", "days", "Ljetbrains/datalore/plot/common/time/interval/TimeInterval;", "count", "", "fromIntervalDataType", "dataType", "Ljetbrains/datalore/plot/common/data/DataType;", "hours", "milliseconds", "minutes", "months", "quarter", "seconds", "semester", "weeks", "years", "plot-common-portable"})
    public static final class Companion {
        @NotNull
        public final TimeInterval milliseconds(int count2) {
            return new DurationInterval(Duration.Companion.getMS(), count2);
        }

        @NotNull
        public final TimeInterval seconds(int count2) {
            return new DurationInterval(Duration.Companion.getSECOND(), count2);
        }

        @NotNull
        public final TimeInterval minutes(int count2) {
            return new DurationInterval(Duration.Companion.getMINUTE(), count2);
        }

        @NotNull
        public final TimeInterval hours(int count2) {
            return new DurationInterval(Duration.Companion.getHOUR(), count2);
        }

        @NotNull
        public final TimeInterval days(int count2) {
            return new DurationInterval(Duration.Companion.getDAY(), count2);
        }

        @NotNull
        public final TimeInterval weeks(int count2) {
            return new DurationInterval(Duration.Companion.getWEEK(), count2);
        }

        @NotNull
        public final TimeInterval months(int count2) {
            return new MonthInterval(count2);
        }

        private final TimeInterval quarter(int count2) {
            return new QuarterInterval(count2);
        }

        private final TimeInterval semester(int count2) {
            return new SemesterInterval(count2);
        }

        @NotNull
        public final TimeInterval years(int count2) {
            return new YearInterval(count2);
        }

        @NotNull
        public final TimeInterval fromIntervalDataType(@NotNull DataType dataType) {
            TimeInterval timeInterval;
            Intrinsics.checkNotNullParameter((Object)((Object)dataType), (String)"dataType");
            switch (TimeInterval$Companion$WhenMappings.$EnumSwitchMapping$0[dataType.ordinal()]) {
                case 1: {
                    timeInterval = this.days(1);
                    break;
                }
                case 2: {
                    timeInterval = this.months(1);
                    break;
                }
                case 3: {
                    timeInterval = this.quarter(1);
                    break;
                }
                case 4: {
                    timeInterval = this.semester(1);
                    break;
                }
                case 5: {
                    timeInterval = this.years(1);
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Can't create interval from data type: " + (Object)((Object)dataType));
                }
            }
            return timeInterval;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

