/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.tooltip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.observable.property.Property;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.Colors;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.interact.TooltipSpec;
import jetbrains.datalore.plot.builder.presentation.Defaults;
import jetbrains.datalore.plot.builder.tooltip.TooltipBox$PointerBox$WhenMappings;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgGraphicsElement;
import jetbrains.datalore.vis.svg.SvgPathData;
import jetbrains.datalore.vis.svg.SvgPathDataBuilder;
import jetbrains.datalore.vis.svg.SvgPathElement;
import jetbrains.datalore.vis.svg.SvgSvgElement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0004/012B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001c\u001a\u00020\u001dH\u0014J3\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\n2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b&J%\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J\f\u0010.\u001a\u00020\u0016*\u00020\nH\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00108@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00063"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "tooltipMinWidth", "", "(Ljava/lang/Double;)V", "contentRect", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "getContentRect", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "fillColor", "Ljetbrains/datalore/base/values/Color;", "myPointerBox", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerBox;", "myTextBox", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$TextBox;", "pointerDirection", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "getPointerDirection$plot_builder", "()Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "textColor", "Ljava/lang/Double;", "isVisible", "", "visible", "getVisible", "()Z", "setVisible", "(Z)V", "buildComponent", "", "setContent", "color", "lines", "", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec$Line;", "style", "", "isOutlier", "setContent$plot_builder", "setPosition", "tooltipCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "pointerCoord", "orientation", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$Orientation;", "setPosition$plot_builder", "isDark", "Orientation", "PointerBox", "PointerDirection", "TextBox", "plot-builder"})
public final class TooltipBox
extends SvgComponent {
    private final PointerBox myPointerBox;
    private final TextBox myTextBox;
    private Color textColor;
    private Color fillColor;
    private final Double tooltipMinWidth;

    @NotNull
    public final DoubleRectangle getContentRect() {
        return DoubleRectangle.Companion.span(DoubleVector.Companion.getZERO(), this.myTextBox.getDimension());
    }

    public final boolean getVisible() {
        return (SvgGraphicsElement.Visibility)((Object)this.getRootGroup().visibility().get()) == SvgGraphicsElement.Visibility.VISIBLE;
    }

    public final void setVisible(boolean isVisible2) {
        SvgGraphicsElement.Visibility visibility = SvgGraphicsElement.Visibility.VISIBLE;
        boolean bl = false;
        boolean bl2 = false;
        SvgGraphicsElement.Visibility visibility2 = visibility;
        Property<SvgGraphicsElement.Visibility> property2 = this.getRootGroup().visibility();
        boolean bl3 = false;
        boolean bl4 = isVisible2;
        SvgGraphicsElement.Visibility visibility3 = bl4 ? visibility : null;
        if (visibility3 == null) {
            visibility3 = SvgGraphicsElement.Visibility.HIDDEN;
        }
        property2.set(visibility3);
    }

    @Nullable
    public final PointerDirection getPointerDirection$plot_builder() {
        return this.myPointerBox.getPointerDirection$plot_builder();
    }

    @Override
    protected void buildComponent() {
        this.add(this.myPointerBox);
        this.add(this.myTextBox);
    }

    public final void setContent$plot_builder(@NotNull Color color, @NotNull List<TooltipSpec.Line> lines, @NotNull String style, boolean isOutlier) {
        Object it;
        boolean bl;
        SvgComponent svgComponent;
        boolean bl2;
        boolean bl3;
        Object object;
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        this.addClassName(style);
        if (isOutlier) {
            this.fillColor = Colors.INSTANCE.mimicTransparency(color, (double)color.getAlpha() / 255.0, Color.Companion.getWHITE());
            object = Defaults.Common.Tooltip.INSTANCE.getLIGHT_TEXT_COLOR();
            bl3 = false;
            bl2 = false;
            Color color2 = object;
            svgComponent = this;
            boolean bl4 = false;
            bl = this.isDark(this.fillColor);
            Object object2 = bl ? object : null;
            if (object2 == null) {
                object2 = Defaults.Common.Tooltip.INSTANCE.getDARK_TEXT_COLOR();
            }
            ((TooltipBox)svgComponent).textColor = object2;
        } else {
            Color color3;
            this.fillColor = Color.Companion.getWHITE();
            object = color;
            bl3 = false;
            bl2 = false;
            it = object;
            svgComponent = this;
            boolean bl5 = false;
            bl = this.isDark(color);
            Object object3 = bl ? object : null;
            if (object3 == null) {
                object3 = color3 = Colors.darker$default(Colors.INSTANCE, color, 0.0, 2, null);
            }
            if (object3 == null) {
                color3 = Defaults.Common.Tooltip.INSTANCE.getDARK_TEXT_COLOR();
            }
            ((TooltipBox)svgComponent).textColor = color3;
        }
        object = this.tooltipMinWidth;
        bl3 = false;
        bl2 = false;
        it = object;
        Color color4 = this.textColor;
        Color color5 = Defaults.Common.Tooltip.INSTANCE.getDARK_TEXT_COLOR();
        List<TooltipSpec.Line> list2 = lines;
        svgComponent = this.myTextBox;
        boolean bl6 = false;
        boolean bl7 = isOutlier;
        ((TextBox)svgComponent).update$plot_builder(list2, color5, color4, (Double)(!bl7 ? object : null));
    }

    public final void setPosition$plot_builder(@NotNull DoubleVector tooltipCoord, @NotNull DoubleVector pointerCoord, @NotNull Orientation orientation) {
        Intrinsics.checkNotNullParameter((Object)tooltipCoord, (String)"tooltipCoord");
        Intrinsics.checkNotNullParameter((Object)pointerCoord, (String)"pointerCoord");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        this.myPointerBox.update$plot_builder(pointerCoord.subtract(tooltipCoord), orientation);
        this.moveTo(tooltipCoord.getX(), tooltipCoord.getY());
    }

    private final boolean isDark(Color $this$isDark) {
        return Colors.INSTANCE.luminance($this$isDark) < 0.5;
    }

    public TooltipBox(@Nullable Double tooltipMinWidth) {
        this.tooltipMinWidth = tooltipMinWidth;
        this.myPointerBox = new PointerBox();
        this.myTextBox = new TextBox();
        this.textColor = Color.Companion.getBLACK();
        this.fillColor = Color.Companion.getWHITE();
    }

    public /* synthetic */ TooltipBox(Double d, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            d = null;
        }
        this(d);
    }

    public TooltipBox() {
        this(null, 1, null);
    }

    public static final /* synthetic */ void access$setTextColor$p(TooltipBox $this, Color color) {
        $this.textColor = color;
    }

    public static final /* synthetic */ void access$setFillColor$p(TooltipBox $this, Color color) {
        $this.fillColor = color;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$Orientation;", "", "(Ljava/lang/String;I)V", "VERTICAL", "HORIZONTAL", "plot-builder"})
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation VERTICAL;
        public static final /* enum */ Orientation HORIZONTAL;
        private static final /* synthetic */ Orientation[] $VALUES;

        static {
            Orientation[] orientationArray = new Orientation[2];
            Orientation[] orientationArray2 = orientationArray;
            orientationArray[0] = VERTICAL = new Orientation();
            orientationArray[1] = HORIZONTAL = new Orientation();
            $VALUES = orientationArray;
        }

        public static Orientation[] values() {
            return (Orientation[])$VALUES.clone();
        }

        public static Orientation valueOf(String string) {
            return Enum.valueOf(Orientation.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "UP", "DOWN", "plot-builder"})
    public static final class PointerDirection
    extends Enum<PointerDirection> {
        public static final /* enum */ PointerDirection LEFT;
        public static final /* enum */ PointerDirection RIGHT;
        public static final /* enum */ PointerDirection UP;
        public static final /* enum */ PointerDirection DOWN;
        private static final /* synthetic */ PointerDirection[] $VALUES;

        static {
            PointerDirection[] pointerDirectionArray = new PointerDirection[4];
            PointerDirection[] pointerDirectionArray2 = pointerDirectionArray;
            pointerDirectionArray[0] = LEFT = new PointerDirection();
            pointerDirectionArray[1] = RIGHT = new PointerDirection();
            pointerDirectionArray[2] = UP = new PointerDirection();
            pointerDirectionArray[3] = DOWN = new PointerDirection();
            $VALUES = pointerDirectionArray;
        }

        public static PointerDirection[] values() {
            return (PointerDirection[])$VALUES.clone();
        }

        public static PointerDirection valueOf(String string) {
            return Enum.valueOf(PointerDirection.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u001d\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerBox;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "(Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;)V", "myPointerPath", "Ljetbrains/datalore/vis/svg/SvgPathElement;", "pointerDirection", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "getPointerDirection$plot_builder", "()Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;", "setPointerDirection$plot_builder", "(Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$PointerDirection;)V", "buildComponent", "", "calculatePointerFootingIndent", "", "sideLength", "update", "pointerCoord", "Ljetbrains/datalore/base/geometry/DoubleVector;", "orientation", "Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$Orientation;", "update$plot_builder", "plot-builder"})
    private final class PointerBox
    extends SvgComponent {
        private final SvgPathElement myPointerPath = new SvgPathElement();
        @Nullable
        private PointerDirection pointerDirection;

        @Nullable
        public final PointerDirection getPointerDirection$plot_builder() {
            return this.pointerDirection;
        }

        public final void setPointerDirection$plot_builder(@Nullable PointerDirection pointerDirection) {
            this.pointerDirection = pointerDirection;
        }

        @Override
        protected void buildComponent() {
            this.add(this.myPointerPath);
        }

        /*
         * WARNING - void declaration
         */
        public final void update$plot_builder(@NotNull DoubleVector pointerCoord, @NotNull Orientation orientation) {
            void $this$apply;
            PointerDirection pointerDirection;
            Intrinsics.checkNotNullParameter((Object)pointerCoord, (String)"pointerCoord");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            switch (TooltipBox$PointerBox$WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()]) {
                case 1: {
                    if (pointerCoord.getX() < TooltipBox.this.getContentRect().getLeft()) {
                        pointerDirection = PointerDirection.LEFT;
                        break;
                    }
                    if (pointerCoord.getX() > TooltipBox.this.getContentRect().getRight()) {
                        pointerDirection = PointerDirection.RIGHT;
                        break;
                    }
                    pointerDirection = null;
                    break;
                }
                case 2: {
                    if (pointerCoord.getY() > TooltipBox.this.getContentRect().getBottom()) {
                        pointerDirection = PointerDirection.DOWN;
                        break;
                    }
                    if (pointerCoord.getY() < TooltipBox.this.getContentRect().getTop()) {
                        pointerDirection = PointerDirection.UP;
                        break;
                    }
                    pointerDirection = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.pointerDirection = pointerDirection;
            SvgPathElement svgPathElement = this.myPointerPath;
            boolean bl = false;
            boolean bl2 = false;
            SvgPathElement $this$apply2 = svgPathElement;
            boolean bl3 = false;
            $this$apply2.strokeColor().set(TooltipBox.this.textColor);
            $this$apply2.strokeOpacity().set(1.0);
            $this$apply2.fillColor().set(TooltipBox.this.fillColor);
            double vertFootingIndent = -this.calculatePointerFootingIndent(TooltipBox.this.getContentRect().getHeight());
            double horFootingIndent = this.calculatePointerFootingIndent(TooltipBox.this.getContentRect().getWidth());
            SvgPathDataBuilder svgPathDataBuilder = new SvgPathDataBuilder(false, 1, null);
            boolean bl4 = false;
            boolean bl5 = false;
            SvgPathDataBuilder svgPathDataBuilder2 = svgPathDataBuilder;
            Property<SvgPathData> property2 = this.myPointerPath.d();
            boolean bl6 = false;
            DoubleRectangle doubleRectangle = TooltipBox.this.getContentRect();
            boolean bl7 = false;
            boolean bl8 = false;
            DoubleRectangle $this$with = doubleRectangle;
            boolean bl9 = false;
            Function2<DoubleVector, Boolean, Unit> $fun$lineToIf$1 = new Function2<DoubleVector, Boolean, Unit>((SvgPathDataBuilder)$this$apply, this, vertFootingIndent, pointerCoord, horFootingIndent){
                final /* synthetic */ SvgPathDataBuilder $this_apply$inlined;
                final /* synthetic */ PointerBox this$0;
                final /* synthetic */ double $vertFootingIndent$inlined;
                final /* synthetic */ DoubleVector $pointerCoord$inlined;
                final /* synthetic */ double $horFootingIndent$inlined;
                {
                    this.$this_apply$inlined = svgPathDataBuilder;
                    this.this$0 = pointerBox;
                    this.$vertFootingIndent$inlined = d;
                    this.$pointerCoord$inlined = doubleVector;
                    this.$horFootingIndent$inlined = d2;
                    super(2);
                }

                public final void invoke(@NotNull DoubleVector p, boolean isTrue) {
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (isTrue) {
                        this.$this_apply$inlined.lineTo(p);
                    }
                }
            };
            SvgPathDataBuilder.moveTo$default((SvgPathDataBuilder)$this$apply, $this$with.getRight(), $this$with.getBottom(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getRight(), $this$with.getBottom() + vertFootingIndent, false, 4, null);
            $fun$lineToIf$1.invoke(pointerCoord, this.pointerDirection == PointerDirection.RIGHT);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getRight(), $this$with.getTop() - vertFootingIndent, false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getRight(), $this$with.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getRight() - horFootingIndent, $this$with.getTop(), false, 4, null);
            $fun$lineToIf$1.invoke(pointerCoord, this.pointerDirection == PointerDirection.UP);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getLeft() + horFootingIndent, $this$with.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getLeft(), $this$with.getTop(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getLeft(), $this$with.getTop() - vertFootingIndent, false, 4, null);
            $fun$lineToIf$1.invoke(pointerCoord, this.pointerDirection == PointerDirection.LEFT);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getLeft(), $this$with.getBottom() + vertFootingIndent, false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getLeft(), $this$with.getBottom(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getLeft() + horFootingIndent, $this$with.getBottom(), false, 4, null);
            $fun$lineToIf$1.invoke(pointerCoord, this.pointerDirection == PointerDirection.DOWN);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getRight() - horFootingIndent, $this$with.getBottom(), false, 4, null);
            SvgPathDataBuilder.lineTo$default((SvgPathDataBuilder)$this$apply, $this$with.getRight(), $this$with.getBottom(), false, 4, null);
            Unit unit = Unit.INSTANCE;
            property2.set(svgPathDataBuilder.build());
        }

        private final double calculatePointerFootingIndent(double sideLength) {
            double d = sideLength * 0.4;
            double d2 = 12.0;
            boolean bl = false;
            double footingLength = Math.min(d, d2);
            return (sideLength - footingLength) / (double)2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0014J7\u0010\f\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/plot/builder/tooltip/TooltipBox$TextBox;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "(Ljetbrains/datalore/plot/builder/tooltip/TooltipBox;)V", "dimension", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getDimension", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "myContent", "Ljetbrains/datalore/vis/svg/SvgSvgElement;", "myLines", "buildComponent", "", "update", "lines", "", "Ljetbrains/datalore/plot/builder/interact/TooltipSpec$Line;", "labelTextColor", "Ljetbrains/datalore/base/values/Color;", "valueTextColor", "tooltipMinWidth", "", "update$plot_builder", "(Ljava/util/List;Ljetbrains/datalore/base/values/Color;Ljetbrains/datalore/base/values/Color;Ljava/lang/Double;)V", "plot-builder"})
    private final class TextBox
    extends SvgComponent {
        private final SvgSvgElement myLines;
        private final SvgSvgElement myContent;

        @NotNull
        public final DoubleVector getDimension() {
            SvgSvgElement svgSvgElement = this.myContent;
            boolean bl = false;
            boolean bl2 = false;
            SvgSvgElement $this$run = svgSvgElement;
            boolean bl3 = false;
            Object ValueT = $this$run.width().get();
            Intrinsics.checkNotNull(ValueT);
            double d = ((Number)ValueT).doubleValue();
            Object ValueT2 = $this$run.height().get();
            Intrinsics.checkNotNull(ValueT2);
            return new DoubleVector(d, ((Number)ValueT2).doubleValue());
        }

        @Override
        protected void buildComponent() {
            this.myContent.children().add(this.myLines);
            this.add(this.myContent);
        }

        /*
         * WARNING - void declaration
         */
        public final void update$plot_builder(@NotNull List<TooltipSpec.Line> lines, @NotNull Color labelTextColor, @NotNull Color valueTextColor, @Nullable Double tooltipMinWidth) {
            void $this$fold$iv;
            TextLabel it;
            void $this$mapTo$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Object $dstr$_u24__u24$_u24__u24$valueComponent;
            Object object;
            boolean bl;
            Collection collection2;
            Iterable $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)labelTextColor, (String)"labelTextColor");
            Intrinsics.checkNotNullParameter((Object)valueTextColor, (String)"valueTextColor");
            Iterable $this$map$iv = lines;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                TextLabel textLabel;
                String p1;
                Iterator line2;
                TooltipSpec.Line line3 = (TooltipSpec.Line)item$iv$iv;
                collection2 = destination$iv$iv22;
                boolean bl2 = false;
                String string = ((TooltipSpec.Line)((Object)line2)).getLabel();
                boolean bl3 = false;
                boolean bl4 = false;
                String string2 = string;
                String string3 = ((TooltipSpec.Line)((Object)line2)).getLabel();
                boolean bl5 = false;
                CharSequence charSequence = p1;
                bl = false;
                boolean bl6 = false;
                boolean bl7 = charSequence == null || charSequence.length() == 0;
                String string4 = string3;
                String string5 = !bl7 ? string : null;
                if (string5 != null) {
                    string = string5;
                    bl3 = false;
                    bl4 = false;
                    p1 = string;
                    string3 = string4;
                    boolean bl8 = false;
                    TextLabel textLabel2 = new TextLabel(p1);
                    string4 = string3;
                    textLabel = textLabel2;
                } else {
                    textLabel = null;
                }
                TextLabel textLabel3 = new TextLabel(((TooltipSpec.Line)((Object)line2)).getValue());
                TextLabel textLabel4 = textLabel;
                String string6 = string4;
                object = new Triple((Object)string6, textLabel4, (Object)textLabel3);
                collection2.add(object);
            }
            List linesInfo = (List)destination$iv$iv22;
            Iterable $this$onEach$iv = linesInfo;
            boolean $i$f$onEach = false;
            $this$mapTo$iv$iv2 = $this$onEach$iv;
            boolean destination$iv$iv22 = false;
            $i$f$mapTo22 = false;
            Iterable $this$apply$iv = $this$mapTo$iv$iv2;
            boolean bl9 = false;
            for (Object element$iv : $this$apply$iv) {
                Triple $dstr$_u24__u24$labelComponent$_u24__u24 = (Triple)element$iv;
                boolean bl10 = false;
                TextLabel labelComponent = (TextLabel)$dstr$_u24__u24$labelComponent$_u24__u24.component2();
                if (labelComponent == null) continue;
                labelComponent.textColor().set(labelTextColor);
                this.myLines.children().add(labelComponent.getRootGroup());
            }
            $this$onEach$iv = linesInfo;
            $i$f$onEach = false;
            $this$mapTo$iv$iv2 = $this$onEach$iv;
            destination$iv$iv22 = false;
            $i$f$mapTo22 = false;
            $this$apply$iv = $this$mapTo$iv$iv2;
            bl9 = false;
            for (Object element$iv : $this$apply$iv) {
                $dstr$_u24__u24$_u24__u24$valueComponent = (Triple)element$iv;
                boolean bl11 = false;
                TextLabel valueComponent = (TextLabel)$dstr$_u24__u24$_u24__u24$valueComponent.component3();
                valueComponent.textColor().set(valueTextColor);
                this.myLines.children().add(valueComponent.getRootGroup());
            }
            Iterable $this$mapNotNull$iv = linesInfo;
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$mapTo22 = $this$mapNotNull$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            $dstr$_u24__u24$_u24__u24$valueComponent = $this$forEach$iv$iv$iv.iterator();
            while ($dstr$_u24__u24$_u24__u24$valueComponent.hasNext()) {
                TextLabel bl8;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = $dstr$_u24__u24$_u24__u24$valueComponent.next();
                boolean bl12 = false;
                Triple $dstr$_u24__u24$labelComponent$_u24__u24 = (Triple)element$iv$iv;
                boolean bl13 = false;
                TextLabel labelComponent2 = (TextLabel)$dstr$_u24__u24$labelComponent$_u24__u24.component2();
                if (labelComponent2 == null) continue;
                boolean bl14 = false;
                bl = false;
                TextLabel it$iv$iv = bl8;
                boolean bl15 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$map$iv2 = (List)destination$iv$iv;
            boolean $i$f$map2 = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                $dstr$_u24__u24$_u24__u24$valueComponent = (TextLabel)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl16 = false;
                object = it.getRootGroup().getBBox().getWidth();
                collection2.add(object);
            }
            Double d = CollectionsKt.max((Iterable)((List)destination$iv$iv));
            double maxLabelWidth = d != null ? d : 0.0;
            Double d2 = tooltipMinWidth;
            double maxLineWidth = d2 != null ? d2 : 0.0;
            Iterable $this$forEach$iv = linesInfo;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv) {
                void labelComponent;
                Triple $dstr$_u24__u24$labelComponent$valueComponent = (Triple)element$iv;
                boolean bl17 = false;
                it = (TextLabel)$dstr$_u24__u24$labelComponent$valueComponent.component2();
                TextLabel valueComponent = (TextLabel)$dstr$_u24__u24$labelComponent$valueComponent.component3();
                double valueWidth = valueComponent.getRootGroup().getBBox().getWidth();
                double $dstr$_u24__u24$labelComponent$_u24__u24 = maxLineWidth;
                double labelComponent2 = labelComponent == null ? valueWidth : maxLabelWidth + valueWidth + 8.0;
                boolean bl18 = false;
                maxLineWidth = Math.max($dstr$_u24__u24$labelComponent$_u24__u24, labelComponent2);
            }
            Iterable $i$f$forEach22 = linesInfo;
            DoubleVector initial$iv = DoubleVector.Companion.getZERO();
            boolean $i$f$fold = false;
            DoubleVector accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void labelText;
                Unit unit;
                void labelComponent;
                void $dstr$labelText$labelComponent$valueComponent;
                Triple valueComponent = (Triple)element$iv;
                DoubleVector textDimension = accumulator$iv;
                boolean bl19 = false;
                String $dstr$_u24__u24$labelComponent$_u24__u24 = (String)$dstr$labelText$labelComponent$valueComponent.component1();
                TextLabel bl13 = (TextLabel)$dstr$labelText$labelComponent$valueComponent.component2();
                TextLabel valueComponent2 = (TextLabel)$dstr$labelText$labelComponent$valueComponent.component3();
                DoubleRectangle valueBBox = valueComponent2.getRootGroup().getBBox();
                Object object2 = labelComponent;
                if (object2 == null || (object2 = ((SvgComponent)object2).getRootGroup()) == null || (object2 = ((SvgGElement)object2).getBBox()) == null) {
                    object2 = new DoubleRectangle(DoubleVector.Companion.getZERO(), DoubleVector.Companion.getZERO());
                }
                Object labelBBox = object2;
                double d3 = valueBBox.getTop();
                double d4 = ((DoubleRectangle)labelBBox).getTop();
                boolean bl20 = false;
                double yPosition = textDimension.getY() - Math.min(d3, d4);
                valueComponent2.y().set(yPosition);
                Property<Double> property2 = labelComponent;
                if (property2 != null && (property2 = ((TextLabel)((Object)property2)).y()) != null) {
                    property2.set(yPosition);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (labelComponent != null) {
                    labelComponent.x().set(-((DoubleRectangle)labelBBox).getLeft());
                    valueComponent2.x().set(maxLineWidth);
                    valueComponent2.setHorizontalAnchor(TextLabel.HorizontalAnchor.RIGHT);
                } else if (valueBBox.getWidth() == maxLineWidth) {
                    valueComponent2.x().set(-valueBBox.getLeft());
                } else if (Intrinsics.areEqual((Object)labelText, (Object)"")) {
                    valueComponent2.x().set(maxLineWidth);
                    valueComponent2.setHorizontalAnchor(TextLabel.HorizontalAnchor.RIGHT);
                } else {
                    valueComponent2.setHorizontalAnchor(TextLabel.HorizontalAnchor.MIDDLE);
                    valueComponent2.x().set(maxLineWidth / (double)2);
                }
                Object ValueT = valueComponent2.y().get();
                Intrinsics.checkNotNull(ValueT);
                d3 = valueBBox.getHeight() + valueBBox.getTop();
                d4 = ((DoubleRectangle)labelBBox).getHeight() + ((DoubleRectangle)labelBBox).getTop();
                bl20 = false;
                accumulator$iv = new DoubleVector(maxLineWidth, ((Number)ValueT).doubleValue() + Math.max(d3, d4) + 3.0);
            }
            DoubleVector textSize = accumulator$iv.subtract(new DoubleVector(0.0, 3.0));
            SvgSvgElement svgSvgElement = this.myLines;
            boolean bl21 = false;
            boolean bl22 = false;
            SvgSvgElement $this$apply = svgSvgElement;
            boolean bl23 = false;
            $this$apply.x().set(4.0);
            $this$apply.y().set(4.0);
            $this$apply.width().set(textSize.getX());
            $this$apply.height().set(textSize.getY());
            svgSvgElement = this.myContent;
            bl21 = false;
            bl22 = false;
            $this$apply = svgSvgElement;
            boolean bl24 = false;
            $this$apply.width().set(textSize.getX() + 8.0);
            $this$apply.height().set(textSize.getY() + 8.0);
        }

        public TextBox() {
            SvgSvgElement $this$apply;
            SvgSvgElement svgSvgElement = new SvgSvgElement();
            boolean bl = false;
            boolean bl2 = false;
            SvgSvgElement svgSvgElement2 = svgSvgElement;
            TextBox textBox = this;
            boolean bl3 = false;
            $this$apply.x().set(0.0);
            $this$apply.y().set(0.0);
            $this$apply.width().set(0.0);
            $this$apply.height().set(0.0);
            Unit unit = Unit.INSTANCE;
            textBox.myLines = svgSvgElement;
            svgSvgElement = new SvgSvgElement();
            bl = false;
            bl2 = false;
            $this$apply = svgSvgElement;
            textBox = this;
            boolean bl4 = false;
            $this$apply.x().set(0.0);
            $this$apply.y().set(0.0);
            $this$apply.width().set(0.0);
            $this$apply.height().set(0.0);
            unit = Unit.INSTANCE;
            textBox.myContent = svgSvgElement;
        }
    }
}

