/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.sampling.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.algorithms.GeometryKt;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Pair;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.base.util.MutableDouble;
import jetbrains.datalore.plot.base.util.MutableInteger;
import jetbrains.datalore.plot.builder.sampling.method.SamplingUtil;
import jetbrains.datalore.plot.builder.sampling.method.VertexSampling;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u00042\u0006\u0010\b\u001a\u00020\u0005J(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u0005J\u001a\u0010\u000e\u001a\u00020\u000f2\u0010\u0010\u0010\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u0011J\u0018\u0010\u0013\u001a\u00020\u00052\u0010\u0010\u0010\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00050\u0011J\"\u0010\u0014\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u0005J\u001a\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00040\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017J\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0017\u00a8\u0006\u001c"}, d2={"Ljetbrains/datalore/plot/builder/sampling/method/SamplingUtil;", "", "()V", "calculateRingLimits", "", "", "rings", "Ljetbrains/datalore/base/geometry/DoubleVector;", "totalPointsLimit", "distinctGroups", "", "groupMapper", "Lkotlin/Function1;", "size", "getRingArea", "", "pair", "Ljetbrains/datalore/base/values/Pair;", "getRingIndex", "getRingLimit", "groupCount", "splitRings", "population", "Ljetbrains/datalore/plot/base/DataFrame;", "xVar", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "data", "yVar", "plot-builder-portable"})
public final class SamplingUtil {
    public static final SamplingUtil INSTANCE;

    /*
     * WARNING - void declaration
     */
    public final int groupCount(@NotNull Function1<? super Integer, Integer> groupMapper2, int size2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)size2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Integer n2 = ((Number)groupMapper2.invoke((Object)((int)it))).intValue();
            collection2.add(n2);
        }
        Collection collection3 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        return collection3.size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> distinctGroups(@NotNull Function1<? super Integer, Integer> groupMapper2, int size2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)size2);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Integer n2 = ((Number)groupMapper2.invoke((Object)((int)it))).intValue();
            collection2.add(n2);
        }
        return CollectionsKt.toMutableList((Collection)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
    }

    @NotNull
    public final DataFrame.Variable xVar(@NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.has(Stats.INSTANCE.getX())) {
            return Stats.INSTANCE.getX();
        }
        if (data.has(TransformVar.INSTANCE.getX())) {
            return TransformVar.INSTANCE.getX();
        }
        throw (Throwable)new IllegalStateException("Can't apply sampling: couldn't deduce the (X) variable");
    }

    @NotNull
    public final DataFrame.Variable yVar(@NotNull DataFrame data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.has(Stats.INSTANCE.getY())) {
            return Stats.INSTANCE.getY();
        }
        if (data.has(TransformVar.INSTANCE.getY())) {
            return TransformVar.INSTANCE.getY();
        }
        throw (Throwable)new IllegalStateException("Can't apply sampling: couldn't deduce the (Y) variable");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<List<DoubleVector>> splitRings(@NotNull DataFrame population) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        ArrayList<List> rings = new ArrayList<List>();
        DoubleVector lastPoint = null;
        int start = -1;
        List<?> list2 = population.get(this.xVar(population));
        if (list2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
        }
        List<?> xValues = list2;
        List<?> list3 = population.get(this.yVar(population));
        if (list3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<kotlin.Any>");
        }
        List<?> yValues = list3;
        VertexSampling.DoubleVectorComponentsList points2 = new VertexSampling.DoubleVectorComponentsList(xValues, yValues);
        int n = 0;
        int n2 = ((Collection)((Object)points2)).size();
        while (n < n2) {
            void i;
            DoubleVector point2 = points2.get((int)i);
            if (start < 0) {
                start = i;
                lastPoint = point2;
            } else if (Intrinsics.areEqual((Object)lastPoint, (Object)point2)) {
                rings.add(points2.subList(start, (int)(i + true)));
                start = -1;
                lastPoint = null;
            }
            ++i;
        }
        if (start >= 0) {
            rings.add(points2.subList(start, points2.size()));
        }
        return rings;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> calculateRingLimits(@NotNull List<? extends List<DoubleVector>> rings, int totalPointsLimit) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(rings, (String)"rings");
        Iterable $this$map$iv = rings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List list2 = (List)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            Double d = GeometryKt.calculateArea((List<DoubleVector>)it);
            collection2.add(d);
        }
        double totalArea = CollectionsKt.sumOfDouble((Iterable)((List)destination$iv$iv));
        MutableDouble areaProceed = new MutableDouble(0.0);
        MutableInteger pointsProceed = new MutableInteger(0);
        Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)CollectionsKt.getIndices((Collection)rings))), (Function1)((Function1)new Function1<Integer, Pair<Integer, Double>>(rings){
            final /* synthetic */ List $rings;

            @NotNull
            public final Pair<Integer, Double> invoke(int it) {
                return new Pair<Integer, Double>(it, GeometryKt.calculateArea((List)this.$rings.get(it)));
            }
            {
                this.$rings = list2;
                super(1);
            }
        }));
        boolean bl = false;
        Comparator comparator2 = ((Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                Comparable comparable = Double.valueOf(SamplingUtil.access$getRingArea(SamplingUtil.INSTANCE, it));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Double.valueOf(SamplingUtil.access$getRingArea(SamplingUtil.INSTANCE, it));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }).reversed();
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"compareBy<Pair<*, Double\u2026\n            }.reversed()");
        bl = false;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)sequence, comparator2), (Function1)((Function1)new Function1<Pair<Integer, Double>, Pair<Integer, Integer>>(totalArea, areaProceed, totalPointsLimit, pointsProceed, rings){
            final /* synthetic */ double $totalArea;
            final /* synthetic */ MutableDouble $areaProceed;
            final /* synthetic */ int $totalPointsLimit;
            final /* synthetic */ MutableInteger $pointsProceed;
            final /* synthetic */ List $rings;

            @NotNull
            public final Pair<Integer, Integer> invoke(@NotNull Pair<Integer, Double> p) {
                Intrinsics.checkNotNullParameter(p, (String)"p");
                int n = MathKt.roundToInt((double)(((Number)p.getSecond()).doubleValue() / (this.$totalArea - this.$areaProceed.get()) * (double)(this.$totalPointsLimit - this.$pointsProceed.get())));
                int n2 = ((List)this.$rings.get(SamplingUtil.INSTANCE.getRingIndex(p))).size();
                boolean bl = false;
                int limit = Math.min(n, n2);
                if (limit >= 4) {
                    this.$areaProceed.getAndAdd(SamplingUtil.access$getRingArea(SamplingUtil.INSTANCE, p));
                    this.$pointsProceed.getAndAdd(limit);
                } else {
                    limit = 0;
                }
                return new Pair<Integer, Integer>(SamplingUtil.INSTANCE.getRingIndex(p), limit);
            }
            {
                this.$totalArea = d;
                this.$areaProceed = mutableDouble;
                this.$totalPointsLimit = n;
                this.$pointsProceed = mutableInteger;
                this.$rings = list2;
                super(1);
            }
        })), (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Pair it = (Pair)a;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(SamplingUtil.INSTANCE.getRingIndex(it));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = Integer.valueOf(SamplingUtil.INSTANCE.getRingIndex(it));
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        }), (Function1)calculateRingLimits.5.INSTANCE));
    }

    public final int getRingIndex(@NotNull Pair<Integer, ?> pair2) {
        Intrinsics.checkNotNullParameter(pair2, (String)"pair");
        return ((Number)pair2.getFirst()).intValue();
    }

    private final double getRingArea(Pair<?, Double> pair2) {
        return ((Number)pair2.getSecond()).doubleValue();
    }

    public final int getRingLimit(@NotNull Pair<?, Integer> pair2) {
        Intrinsics.checkNotNullParameter(pair2, (String)"pair");
        return ((Number)pair2.getSecond()).intValue();
    }

    private SamplingUtil() {
    }

    static {
        SamplingUtil samplingUtil;
        INSTANCE = samplingUtil = new SamplingUtil();
    }

    public static final /* synthetic */ double access$getRingArea(SamplingUtil $this, Pair pair2) {
        return $this.getRingArea(pair2);
    }
}

