/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.sampling.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.util.SamplingUtil;
import jetbrains.datalore.plot.builder.data.GroupUtil;
import jetbrains.datalore.plot.builder.sampling.GroupAwareSampling;
import jetbrains.datalore.plot.builder.sampling.method.SamplingBase;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\bJ$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0013H\u0016J$\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0013H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/plot/builder/sampling/method/RandomStratifiedSampling;", "Ljetbrains/datalore/plot/builder/sampling/method/SamplingBase;", "Ljetbrains/datalore/plot/builder/sampling/GroupAwareSampling;", "sampleSize", "", "mySeed", "", "myMinSubsampleSize", "(ILjava/lang/Long;Ljava/lang/Integer;)V", "expressionText", "", "getExpressionText", "()Ljava/lang/String;", "Ljava/lang/Integer;", "Ljava/lang/Long;", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "population", "groupMapper", "Lkotlin/Function1;", "isApplicable", "", "Companion", "plot-builder-portable"})
public final class RandomStratifiedSampling
extends SamplingBase
implements GroupAwareSampling {
    private final Long mySeed;
    private final Integer myMinSubsampleSize;
    @NotNull
    public static final String ALIAS = "random_stratified";
    private static final int DEF_MIN_SUBSAMPLE_SIZE = 2;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getExpressionText() {
        return "sampling_random_stratified(n=" + this.getSampleSize() + (this.mySeed != null ? ", seed=" + this.mySeed : "") + (this.myMinSubsampleSize != null ? ", min_subsample=" + this.myMinSubsampleSize : "") + ")";
    }

    @Override
    public boolean isApplicable(@NotNull DataFrame population, @NotNull Function1<? super Integer, Integer> groupMapper2) {
        Intrinsics.checkNotNullParameter((Object)population, (String)"population");
        Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
        return population.rowCount() > this.getSampleSize();
    }

    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame population, @NotNull Function1<? super Integer, Integer> groupMapper2) {
        Long l;
        ArrayList<Integer> pickIndices;
        int popSize;
        int minSubSampleSize;
        Map<Integer, List<Integer>> indicesByGroup;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)population, (String)"population");
                Intrinsics.checkNotNullParameter(groupMapper2, (String)"groupMapper");
                Preconditions.INSTANCE.checkArgument(this.isApplicable(population, groupMapper2));
                indicesByGroup = GroupUtil.INSTANCE.indicesByGroup(population.rowCount(), groupMapper2);
                Integer n = this.myMinSubsampleSize;
                minSubSampleSize = n != null ? n : 2;
                int n2 = 0;
                boolean bl = false;
                minSubSampleSize = Math.max(n2, minSubSampleSize);
                popSize = population.rowCount();
                pickIndices = new ArrayList<Integer>();
                l = this.mySeed;
                if (l == null) break block6;
                Long l2 = l;
                boolean bl2 = false;
                boolean bl3 = false;
                long it = ((Number)l2).longValue();
                boolean bl4 = false;
                l = RandomKt.Random((long)it);
                if (l != null) break block7;
            }
            l = (Random)Random.Default;
        }
        Long rand = l;
        Iterator<Integer> iterator2 = indicesByGroup.keySet().iterator();
        while (iterator2.hasNext()) {
            List<Integer> groupIndices;
            int group2 = ((Number)iterator2.next()).intValue();
            Intrinsics.checkNotNull(indicesByGroup.get(group2));
            int stratumSize = groupIndices.size();
            double ratio = (double)stratumSize / (double)popSize;
            double d = (double)this.getSampleSize() * ratio;
            boolean bl = false;
            int stratumSampleSize = (int)Math.rint(d);
            boolean bl5 = false;
            stratumSampleSize = Math.max(stratumSampleSize, minSubSampleSize);
            if (stratumSampleSize >= stratumSize) {
                pickIndices.addAll((Collection)groupIndices);
                continue;
            }
            List sampleGroupIndices2 = (List)SamplingUtil.INSTANCE.sampleWithoutReplacement(stratumSize, stratumSampleSize, (Random)rand, (Function1)new Function1<Set<? extends Integer>, List<? extends Integer>>(groupIndices){
                final /* synthetic */ List $groupIndices;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<Integer> invoke(@NotNull Set<Integer> indexSet) {
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter(indexSet, (String)"indexSet");
                    Iterable $this$filter$iv = (Iterable)RangesKt.until((int)0, (int)this.$groupIndices.size());
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        int it = ((Number)element$iv$iv).intValue();
                        boolean bl = false;
                        if (!indexSet.contains(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                {
                    this.$groupIndices = list2;
                    super(1);
                }
            }, (Function1)new Function1<Set<? extends Integer>, List<? extends Integer>>(groupIndices){
                final /* synthetic */ List $groupIndices;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<Integer> invoke(@NotNull Set<Integer> indexSet) {
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter(indexSet, (String)"indexSet");
                    Iterable $this$filter$iv = (Iterable)RangesKt.until((int)0, (int)this.$groupIndices.size());
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        int i = ((Number)element$iv$iv).intValue();
                        boolean bl = false;
                        if (!(!indexSet.contains(i))) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
                {
                    this.$groupIndices = list2;
                    super(1);
                }
            });
            Iterator iterator3 = sampleGroupIndices2.iterator();
            while (iterator3.hasNext()) {
                int i = ((Number)iterator3.next()).intValue();
                pickIndices.add(groupIndices.get(i));
            }
        }
        return population.selectIndices((List<Integer>)pickIndices);
    }

    public RandomStratifiedSampling(int sampleSize, @Nullable Long mySeed, @Nullable Integer myMinSubsampleSize) {
        super(sampleSize);
        this.mySeed = mySeed;
        this.myMinSubsampleSize = myMinSubsampleSize;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/plot/builder/sampling/method/RandomStratifiedSampling$Companion;", "", "()V", "ALIAS", "", "DEF_MIN_SUBSAMPLE_SIZE", "", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

