/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout.axis.label;

import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.layout.axis.GuideBreaks;
import jetbrains.datalore.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import jetbrains.datalore.plot.builder.layout.axis.label.HorizontalMultilineLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.HorizontalSimpleLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.HorizontalTiltedLabelsLayout;
import jetbrains.datalore.plot.builder.layout.axis.label.HorizontalVerticalLabelsLayout;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u0019H\u0002J\b\u0010\u001f\u001a\u00020\u0019H\u0002J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006!"}, d2={"Ljetbrains/datalore/plot/builder/layout/axis/label/HorizontalFixedBreaksLabelsLayout;", "Ljetbrains/datalore/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "axisDomain", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "labelSpec", "Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;", "breaks", "Ljetbrains/datalore/plot/builder/layout/axis/GuideBreaks;", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "(Ljetbrains/datalore/plot/builder/guide/Orientation;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/plot/builder/presentation/PlotLabelSpec;Ljetbrains/datalore/plot/builder/layout/axis/GuideBreaks;Ljetbrains/datalore/plot/builder/theme/AxisTheme;)V", "doLayout", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisLength", "axisMapper", "Lkotlin/Function1;", "maxLabelsBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "labelBounds", "labelNormalSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "multilineLayout", "Ljetbrains/datalore/plot/builder/layout/axis/label/AxisLabelsLayout;", "overlap", "", "labelsInfo", "maxTickLabelsBounds", "simpleLayout", "tiltedLayout", "verticalLayout", "plot-builder-portable"})
public final class HorizontalFixedBreaksLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean overlap(AxisLabelsLayoutInfo labelsInfo, DoubleRectangle maxTickLabelsBounds) {
        if (labelsInfo.isOverlap$plot_builder_portable()) return true;
        if (maxTickLabelsBounds == null) return false;
        ClosedRange<Double> closedRange = maxTickLabelsBounds.xRange();
        DoubleRectangle doubleRectangle = labelsInfo.getBounds();
        Intrinsics.checkNotNull((Object)doubleRectangle);
        if (!closedRange.encloses(doubleRectangle.xRange())) return true;
        if (maxTickLabelsBounds.yRange().encloses(labelsInfo.getBounds().yRange())) return false;
        return true;
    }

    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(double axisLength, @NotNull Function1<? super Double, Double> axisMapper, @Nullable DoubleRectangle maxLabelsBounds) {
        Intrinsics.checkNotNullParameter(axisMapper, (String)"axisMapper");
        if (!this.getTheme().showTickLabels()) {
            return this.noLabelsLayoutInfo(axisLength, this.getOrientation());
        }
        AxisLabelsLayoutInfo labelsInfo = this.simpleLayout().doLayout(axisLength, axisMapper, maxLabelsBounds);
        if (this.overlap(labelsInfo, maxLabelsBounds) && this.overlap(labelsInfo = this.multilineLayout().doLayout(axisLength, axisMapper, maxLabelsBounds), maxLabelsBounds) && this.overlap(labelsInfo = this.tiltedLayout().doLayout(axisLength, axisMapper, maxLabelsBounds), maxLabelsBounds) && this.overlap(labelsInfo = this.verticalLayout(this.getLabelSpec()).doLayout(axisLength, axisMapper, maxLabelsBounds), maxLabelsBounds)) {
            labelsInfo = this.verticalLayout(AxisLabelsLayout.Companion.getTICK_LABEL_SPEC_SMALL()).doLayout(axisLength, axisMapper, maxLabelsBounds);
        }
        return labelsInfo;
    }

    private final AxisLabelsLayout simpleLayout() {
        return new HorizontalSimpleLabelsLayout(this.getOrientation(), this.getAxisDomain(), this.getLabelSpec(), this.getBreaks(), this.getTheme());
    }

    private final AxisLabelsLayout multilineLayout() {
        return new HorizontalMultilineLabelsLayout(this.getOrientation(), this.getAxisDomain(), this.getLabelSpec(), this.getBreaks(), this.getTheme(), 2);
    }

    private final AxisLabelsLayout tiltedLayout() {
        return new HorizontalTiltedLabelsLayout(this.getOrientation(), this.getAxisDomain(), this.getLabelSpec(), this.getBreaks(), this.getTheme());
    }

    private final AxisLabelsLayout verticalLayout(PlotLabelSpec labelSpec) {
        return new HorizontalVerticalLabelsLayout(this.getOrientation(), this.getAxisDomain(), labelSpec, this.getBreaks(), this.getTheme());
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        throw (Throwable)new IllegalStateException("Not implemented here");
    }

    public HorizontalFixedBreaksLabelsLayout(@NotNull Orientation orientation, @NotNull ClosedRange<Double> axisDomain, @NotNull PlotLabelSpec labelSpec, @NotNull GuideBreaks breaks, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter(axisDomain, (String)"axisDomain");
        Intrinsics.checkNotNullParameter((Object)labelSpec, (String)"labelSpec");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, axisDomain, labelSpec, breaks, theme);
        Preconditions.INSTANCE.checkArgument(orientation.isHorizontal(), orientation.toString());
    }
}

