/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Ljetbrains/datalore/plot/builder/layout/TileLayoutBase;", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "()V", "Companion", "plot-builder-portable"})
public abstract class TileLayoutBase
implements TileLayout {
    public static final double GEOM_MARGIN = 0.0;
    protected static final double CLIP_EXTEND = 5.0;
    @NotNull
    private static final DoubleVector GEOM_MIN_SIZE;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        GEOM_MIN_SIZE = new DoubleVector(50.0, 50.0);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/layout/TileLayoutBase$Companion;", "", "()V", "CLIP_EXTEND", "", "GEOM_MARGIN", "GEOM_MIN_SIZE", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getGEOM_MIN_SIZE", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "clipBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "geomBounds", "xAxisThickness", "yAxisThickness", "plotSize", "plot-builder-portable"})
    public static final class Companion {
        @NotNull
        public final DoubleVector getGEOM_MIN_SIZE() {
            return GEOM_MIN_SIZE;
        }

        @NotNull
        public final DoubleRectangle geomBounds(double xAxisThickness, double yAxisThickness, @NotNull DoubleVector plotSize) {
            Intrinsics.checkNotNullParameter((Object)plotSize, (String)"plotSize");
            DoubleVector marginLeftTop = new DoubleVector(yAxisThickness, 0.0);
            DoubleVector marginRightBottom = new DoubleVector(0.0, xAxisThickness);
            DoubleVector geomSize = plotSize.subtract(marginLeftTop).subtract(marginRightBottom);
            if (geomSize.getX() < this.getGEOM_MIN_SIZE().getX()) {
                geomSize = new DoubleVector(this.getGEOM_MIN_SIZE().getX(), geomSize.getY());
            }
            if (geomSize.getY() < this.getGEOM_MIN_SIZE().getY()) {
                geomSize = new DoubleVector(geomSize.getX(), this.getGEOM_MIN_SIZE().getY());
            }
            return new DoubleRectangle(marginLeftTop, geomSize);
        }

        @NotNull
        public final DoubleRectangle clipBounds(@NotNull DoubleRectangle geomBounds) {
            Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
            return new DoubleRectangle(geomBounds.getOrigin().subtract(new DoubleVector(5.0, 5.0)), new DoubleVector(geomBounds.getDimension().getX() + 10.0, geomBounds.getDimension().getY() + 10.0));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

