/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.guide.LegendArrangement;
import jetbrains.datalore.plot.builder.guide.LegendJustification;
import jetbrains.datalore.plot.builder.guide.LegendPosition;
import jetbrains.datalore.plot.builder.layout.GeometryUtil;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.LegendBoxesLayoutUtil;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\f\rB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/builder/layout/LegendBoxesLayout;", "", "myPlotBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "myTheme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "(Ljetbrains/datalore/base/geometry/DoubleRectangle;Ljetbrains/datalore/plot/builder/theme/LegendTheme;)V", "doLayout", "Ljetbrains/datalore/plot/builder/layout/LegendBoxesLayout$Result;", "infos", "", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "BoxWithLocation", "Result", "plot-builder-portable"})
public final class LegendBoxesLayout {
    private final DoubleRectangle myPlotBounds;
    private final LegendTheme myTheme;

    @NotNull
    public final Result doLayout(@NotNull List<? extends LegendBoxInfo> infos) {
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        LegendPosition legendPosition = this.myTheme.position();
        LegendJustification legendJustification = this.myTheme.justification();
        LegendArrangement legendArrangement = LegendArrangement.VERTICAL;
        DoubleVector plotCenter = this.myPlotBounds.getCenter();
        DoubleRectangle plotInnerBoundsWithoutLegendBoxes = this.myPlotBounds;
        List<BoxWithLocation> boxWithLocationList = legendArrangement == LegendArrangement.VERTICAL ? LegendBoxesLayoutUtil.INSTANCE.verticalStack(infos) : LegendBoxesLayoutUtil.INSTANCE.horizontalStack(infos);
        DoubleVector boxesSize = LegendBoxesLayoutUtil.INSTANCE.size(boxWithLocationList);
        if (Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getLEFT()) || Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getRIGHT())) {
            double d = 0.0;
            double d2 = plotInnerBoundsWithoutLegendBoxes.getWidth() - boxesSize.getX();
            boolean bl = false;
            double plotWidth = Math.max(d, d2);
            plotInnerBoundsWithoutLegendBoxes = Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getLEFT()) ? GeometryUtil.INSTANCE.changeWidthKeepRight(plotInnerBoundsWithoutLegendBoxes, plotWidth) : GeometryUtil.INSTANCE.changeWidth(plotInnerBoundsWithoutLegendBoxes, plotWidth);
        } else if (Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getTOP()) || Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getBOTTOM())) {
            double d = 0.0;
            double d3 = plotInnerBoundsWithoutLegendBoxes.getHeight() - boxesSize.getY();
            boolean bl = false;
            double plotHeight = Math.max(d, d3);
            plotInnerBoundsWithoutLegendBoxes = Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getTOP()) ? GeometryUtil.INSTANCE.changeHeightKeepBottom(plotInnerBoundsWithoutLegendBoxes, plotHeight) : GeometryUtil.INSTANCE.changeHeight(plotInnerBoundsWithoutLegendBoxes, plotHeight);
        }
        DoubleVector legendOrigin = null;
        legendOrigin = Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getLEFT()) ? new DoubleVector(plotInnerBoundsWithoutLegendBoxes.getLeft() - boxesSize.getX(), plotCenter.getY() - boxesSize.getY() / (double)2) : (Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getRIGHT()) ? new DoubleVector(plotInnerBoundsWithoutLegendBoxes.getRight(), plotCenter.getY() - boxesSize.getY() / (double)2) : (Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getTOP()) ? new DoubleVector(plotCenter.getX() - boxesSize.getX() / (double)2, plotInnerBoundsWithoutLegendBoxes.getTop() - boxesSize.getY()) : (Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getBOTTOM()) ? new DoubleVector(plotCenter.getX() - boxesSize.getX() / (double)2, plotInnerBoundsWithoutLegendBoxes.getBottom()) : LegendBoxesLayoutUtil.INSTANCE.overlayLegendOrigin(plotInnerBoundsWithoutLegendBoxes, boxesSize, legendPosition, legendJustification))));
        List<BoxWithLocation> resultBoxWithLocationList = LegendBoxesLayoutUtil.INSTANCE.moveAll(legendOrigin, boxWithLocationList);
        return new Result(plotInnerBoundsWithoutLegendBoxes, resultBoxWithLocationList);
    }

    public LegendBoxesLayout(@NotNull DoubleRectangle myPlotBounds, @NotNull LegendTheme myTheme) {
        Intrinsics.checkNotNullParameter((Object)myPlotBounds, (String)"myPlotBounds");
        Intrinsics.checkNotNullParameter((Object)myTheme, (String)"myTheme");
        this.myPlotBounds = myPlotBounds;
        this.myTheme = myTheme;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/builder/layout/LegendBoxesLayout$Result;", "", "plotInnerBoundsWithoutLegendBoxes", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "locations", "", "Ljetbrains/datalore/plot/builder/layout/LegendBoxesLayout$BoxWithLocation;", "(Ljetbrains/datalore/base/geometry/DoubleRectangle;Ljava/util/List;)V", "boxWithLocationList", "getBoxWithLocationList", "()Ljava/util/List;", "getPlotInnerBoundsWithoutLegendBoxes", "()Ljetbrains/datalore/base/geometry/DoubleRectangle;", "plot-builder-portable"})
    public static final class Result {
        @NotNull
        private final List<BoxWithLocation> boxWithLocationList;
        @NotNull
        private final DoubleRectangle plotInnerBoundsWithoutLegendBoxes;

        @NotNull
        public final List<BoxWithLocation> getBoxWithLocationList() {
            return this.boxWithLocationList;
        }

        @NotNull
        public final DoubleRectangle getPlotInnerBoundsWithoutLegendBoxes() {
            return this.plotInnerBoundsWithoutLegendBoxes;
        }

        public Result(@NotNull DoubleRectangle plotInnerBoundsWithoutLegendBoxes, @NotNull List<BoxWithLocation> locations) {
            Intrinsics.checkNotNullParameter((Object)plotInnerBoundsWithoutLegendBoxes, (String)"plotInnerBoundsWithoutLegendBoxes");
            Intrinsics.checkNotNullParameter(locations, (String)"locations");
            this.plotInnerBoundsWithoutLegendBoxes = plotInnerBoundsWithoutLegendBoxes;
            this.boxWithLocationList = new ArrayList(locations);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rJ\r\u0010\u000e\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/layout/LegendBoxesLayout$BoxWithLocation;", "", "legendBox", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "location", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;Ljetbrains/datalore/base/geometry/DoubleVector;)V", "getLegendBox", "()Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "getLocation", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "bounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "bounds$plot_builder_portable", "size", "size$plot_builder_portable", "plot-builder-portable"})
    public static final class BoxWithLocation {
        @NotNull
        private final LegendBoxInfo legendBox;
        @NotNull
        private final DoubleVector location;

        @NotNull
        public final DoubleVector size$plot_builder_portable() {
            return this.legendBox.getSize$plot_builder_portable();
        }

        @NotNull
        public final DoubleRectangle bounds$plot_builder_portable() {
            return new DoubleRectangle(this.location, this.legendBox.getSize$plot_builder_portable());
        }

        @NotNull
        public final LegendBoxInfo getLegendBox() {
            return this.legendBox;
        }

        @NotNull
        public final DoubleVector getLocation() {
            return this.location;
        }

        public BoxWithLocation(@NotNull LegendBoxInfo legendBox, @NotNull DoubleVector location) {
            Intrinsics.checkNotNullParameter((Object)legendBox, (String)"legendBox");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            this.legendBox = legendBox;
            this.location = location;
        }
    }
}

