/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.guide.LegendBoxLayout;
import jetbrains.datalore.plot.builder.guide.LegendBreak;
import jetbrains.datalore.plot.builder.guide.LegendDirection;
import jetbrains.datalore.plot.builder.layout.GeometryUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u0000 12\u00020\u0001:\u000512345B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u000f2\u0006\u0010,\u001a\u00020\u001dH$J\b\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020.H\u0002J\u0010\u00100\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u000fH$R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\rR\u0010\u0010\"\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u001d0$j\b\u0012\u0004\u0012\u00020\u001d`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u001d0$j\b\u0012\u0004\u0012\u00020\u001d`%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010'\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0011\"\u0004\b)\u0010\u0013\u00a8\u00066"}, d2={"Ljetbrains/datalore/plot/builder/guide/LegendComponentLayout;", "Ljetbrains/datalore/plot/builder/guide/LegendBoxLayout;", "title", "", "breaks", "", "Ljetbrains/datalore/plot/builder/guide/LegendBreak;", "keySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "legendDirection", "Ljetbrains/datalore/plot/builder/guide/LegendDirection;", "(Ljava/lang/String;Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/builder/guide/LegendDirection;)V", "getBreaks", "()Ljava/util/List;", "colCount", "", "getColCount", "()I", "setColCount", "(I)V", "graphSize", "getGraphSize", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "isFillByRow", "", "()Z", "setFillByRow", "(Z)V", "keyLabelBoxes", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "getKeyLabelBoxes", "getKeySize", "labelBoxes", "getLabelBoxes", "myContentSize", "myKeyLabelBoxes", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "myLabelBoxes", "rowCount", "getRowCount", "setRowCount", "breakBoxOrigin", "index", "prevBreakBoxBounds", "doLayout", "", "ensureInited", "labelSize", "Companion", "MyHorizontal", "MyHorizontalMultiRow", "MyMultiRow", "MyVertical", "plot-builder-portable"})
public abstract class LegendComponentLayout
extends LegendBoxLayout {
    private DoubleVector myContentSize;
    private final ArrayList<DoubleRectangle> myKeyLabelBoxes;
    private final ArrayList<DoubleRectangle> myLabelBoxes;
    private boolean isFillByRow;
    private int rowCount;
    private int colCount;
    @NotNull
    private final List<LegendBreak> breaks;
    @NotNull
    private final DoubleVector keySize;
    public static final Companion Companion = new Companion(null);

    public final boolean isFillByRow() {
        return this.isFillByRow;
    }

    public final void setFillByRow(boolean bl) {
        this.isFillByRow = bl;
    }

    public final int getRowCount() {
        return this.rowCount;
    }

    public final void setRowCount(int rowCount) {
        Preconditions.INSTANCE.checkState(rowCount > 0, "Row count must be greater than 0, was " + rowCount);
        this.rowCount = rowCount;
    }

    public final int getColCount() {
        return this.colCount;
    }

    public final void setColCount(int colCount) {
        Preconditions.INSTANCE.checkState(colCount > 0, "Col count must be greater than 0, was " + colCount);
        this.colCount = colCount;
    }

    @Override
    @NotNull
    protected DoubleVector getGraphSize() {
        this.ensureInited();
        DoubleVector doubleVector = this.myContentSize;
        Intrinsics.checkNotNull((Object)doubleVector);
        return doubleVector;
    }

    @NotNull
    public final List<DoubleRectangle> getKeyLabelBoxes() {
        this.ensureInited();
        return this.myKeyLabelBoxes;
    }

    @NotNull
    public final List<DoubleRectangle> getLabelBoxes() {
        this.ensureInited();
        return this.myLabelBoxes;
    }

    private final void ensureInited() {
        if (this.myContentSize == null) {
            this.doLayout();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doLayout() {
        double labelHeight = LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().height();
        double labelLeftMargin = LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().width(1) / (double)2;
        double labelHOffset = this.keySize.getX() + labelLeftMargin;
        double labelVOffset = (this.keySize.getY() - labelHeight) / (double)2;
        DoubleVector contentOrigin = DoubleVector.Companion.getZERO();
        DoubleRectangle breakBoxBounds = null;
        int n = 0;
        int n2 = ((Collection)this.breaks).size();
        while (n < n2) {
            Object object;
            DoubleVector breakBoxSize;
            DoubleVector labelSize;
            void i;
            block4: {
                block3: {
                    labelSize = this.labelSize((int)i);
                    breakBoxSize = new DoubleVector(labelHOffset + labelSize.getX(), this.keySize.getY());
                    object = breakBoxBounds;
                    if (object == null) break block3;
                    DoubleRectangle doubleRectangle = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    DoubleRectangle it = doubleRectangle;
                    boolean bl3 = false;
                    DoubleVector doubleVector = this.breakBoxOrigin((int)i, it);
                    object = doubleVector;
                    if (object != null) break block4;
                }
                object = contentOrigin;
            }
            DoubleVector doubleVector = breakBoxSize;
            Object object2 = object;
            breakBoxBounds = new DoubleRectangle((DoubleVector)object2, doubleVector);
            this.myKeyLabelBoxes.add(breakBoxBounds);
            this.myLabelBoxes.add(new DoubleRectangle(labelHOffset, labelVOffset, labelSize.getX(), labelSize.getY()));
            ++i;
        }
        this.myContentSize = GeometryUtil.INSTANCE.union(new DoubleRectangle(contentOrigin, DoubleVector.Companion.getZERO()), (Collection<DoubleRectangle>)this.myKeyLabelBoxes).getDimension();
    }

    @NotNull
    protected abstract DoubleVector breakBoxOrigin(int var1, @NotNull DoubleRectangle var2);

    @NotNull
    protected abstract DoubleVector labelSize(int var1);

    @NotNull
    protected final List<LegendBreak> getBreaks() {
        return this.breaks;
    }

    @NotNull
    public final DoubleVector getKeySize() {
        return this.keySize;
    }

    public LegendComponentLayout(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull DoubleVector keySize, @NotNull LegendDirection legendDirection) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)keySize, (String)"keySize");
        Intrinsics.checkNotNullParameter((Object)((Object)legendDirection), (String)"legendDirection");
        super(title, legendDirection);
        this.breaks = breaks;
        this.keySize = keySize;
        this.myKeyLabelBoxes = new ArrayList();
        this.myLabelBoxes = new ArrayList();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/builder/guide/LegendComponentLayout$MyHorizontal;", "Ljetbrains/datalore/plot/builder/guide/LegendComponentLayout;", "title", "", "breaks", "", "Ljetbrains/datalore/plot/builder/guide/LegendBreak;", "keySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljava/lang/String;Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleVector;)V", "breakBoxOrigin", "index", "", "prevBreakBoxBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "labelSize", "plot-builder-portable"})
    private static final class MyHorizontal
    extends LegendComponentLayout {
        @Override
        @NotNull
        protected DoubleVector breakBoxOrigin(int index, @NotNull DoubleRectangle prevBreakBoxBounds) {
            Intrinsics.checkNotNullParameter((Object)prevBreakBoxBounds, (String)"prevBreakBoxBounds");
            return new DoubleVector(prevBreakBoxBounds.getRight(), 0.0);
        }

        @Override
        @NotNull
        protected DoubleVector labelSize(int index) {
            String label = this.getBreaks().get(index).getLabel();
            return new DoubleVector(LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().width(label.length()), LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().height());
        }

        public MyHorizontal(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull DoubleVector keySize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)keySize, (String)"keySize");
            super(title, breaks, keySize, LegendDirection.HORIZONTAL);
            this.setColCount(breaks.size());
            this.setRowCount(1);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/builder/guide/LegendComponentLayout$MyHorizontalMultiRow;", "Ljetbrains/datalore/plot/builder/guide/LegendComponentLayout$MyMultiRow;", "title", "", "breaks", "", "Ljetbrains/datalore/plot/builder/guide/LegendBreak;", "keySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljava/lang/String;Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleVector;)V", "plot-builder-portable"})
    private static final class MyHorizontalMultiRow
    extends MyMultiRow {
        public MyHorizontalMultiRow(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull DoubleVector keySize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)keySize, (String)"keySize");
            super(title, breaks, keySize, LegendDirection.HORIZONTAL);
            this.setColCount(breaks.size());
            this.setRowCount(1);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/builder/guide/LegendComponentLayout$MyVertical;", "Ljetbrains/datalore/plot/builder/guide/LegendComponentLayout$MyMultiRow;", "title", "", "breaks", "", "Ljetbrains/datalore/plot/builder/guide/LegendBreak;", "keySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljava/lang/String;Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleVector;)V", "plot-builder-portable"})
    private static final class MyVertical
    extends MyMultiRow {
        public MyVertical(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull DoubleVector keySize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)keySize, (String)"keySize");
            super(title, breaks, keySize, LegendDirection.VERTICAL);
            this.setColCount(1);
            this.setRowCount(breaks.size());
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/guide/LegendComponentLayout$MyMultiRow;", "Ljetbrains/datalore/plot/builder/guide/LegendComponentLayout;", "title", "", "breaks", "", "Ljetbrains/datalore/plot/builder/guide/LegendBreak;", "keySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "legendDirection", "Ljetbrains/datalore/plot/builder/guide/LegendDirection;", "(Ljava/lang/String;Ljava/util/List;Ljetbrains/datalore/base/geometry/DoubleVector;Ljetbrains/datalore/plot/builder/guide/LegendDirection;)V", "myMaxLabelWidth", "", "breakBoxOrigin", "index", "", "prevBreakBoxBounds", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "labelSize", "plot-builder-portable"})
    private static abstract class MyMultiRow
    extends LegendComponentLayout {
        private double myMaxLabelWidth;

        @Override
        @NotNull
        protected DoubleVector breakBoxOrigin(int index, @NotNull DoubleRectangle prevBreakBoxBounds) {
            Intrinsics.checkNotNullParameter((Object)prevBreakBoxBounds, (String)"prevBreakBoxBounds");
            if (this.isFillByRow()) {
                return index % this.getColCount() == 0 ? new DoubleVector(0.0, prevBreakBoxBounds.getBottom()) : new DoubleVector(prevBreakBoxBounds.getRight(), prevBreakBoxBounds.getTop());
            }
            return index % this.getRowCount() == 0 ? new DoubleVector(prevBreakBoxBounds.getRight(), 0.0) : new DoubleVector(prevBreakBoxBounds.getLeft(), prevBreakBoxBounds.getBottom());
        }

        @Override
        @NotNull
        protected DoubleVector labelSize(int index) {
            return new DoubleVector(this.myMaxLabelWidth, LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().height());
        }

        public MyMultiRow(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull DoubleVector keySize, @NotNull LegendDirection legendDirection) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)keySize, (String)"keySize");
            Intrinsics.checkNotNullParameter((Object)((Object)legendDirection), (String)"legendDirection");
            super(title, breaks, keySize, legendDirection);
            for (LegendBreak br : breaks) {
                double d = this.myMaxLabelWidth;
                double d2 = LegendBoxLayout.Companion.getLABEL_SPEC$plot_builder_portable().width(br.getLabel().length());
                boolean bl = false;
                this.myMaxLabelWidth = Math.max(d, d2);
            }
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ$\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/builder/guide/LegendComponentLayout$Companion;", "", "()V", "horizontal", "Ljetbrains/datalore/plot/builder/guide/LegendComponentLayout;", "title", "", "breaks", "", "Ljetbrains/datalore/plot/builder/guide/LegendBreak;", "keySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "horizontalMultiRow", "vertical", "plot-builder-portable"})
    public static final class Companion {
        @NotNull
        public final LegendComponentLayout horizontal(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull DoubleVector keySize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)keySize, (String)"keySize");
            return new MyHorizontal(title, breaks, keySize);
        }

        @NotNull
        public final LegendComponentLayout horizontalMultiRow(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull DoubleVector keySize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)keySize, (String)"keySize");
            return new MyHorizontalMultiRow(title, breaks, keySize);
        }

        @NotNull
        public final LegendComponentLayout vertical(@NotNull String title, @NotNull List<LegendBreak> breaks, @NotNull DoubleVector keySize) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter(breaks, (String)"breaks");
            Intrinsics.checkNotNullParameter((Object)keySize, (String)"keySize");
            return new MyVertical(title, breaks, keySize);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

