/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.coord;

import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Pair;
import jetbrains.datalore.plot.builder.coord.CoordProviderBase;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007JD\u0010\b\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00050\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/datalore/plot/builder/coord/FixedRatioCoordProvider;", "Ljetbrains/datalore/plot/builder/coord/CoordProviderBase;", "ratio", "", "xLim", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "yLim", "(DLjetbrains/datalore/base/gcommon/collect/ClosedRange;Ljetbrains/datalore/base/gcommon/collect/ClosedRange;)V", "adjustDomains", "Ljetbrains/datalore/base/values/Pair;", "xDomain", "yDomain", "displaySize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "plot-builder-portable"})
public class FixedRatioCoordProvider
extends CoordProviderBase {
    private final double ratio;

    @Override
    @NotNull
    public Pair<ClosedRange<Double>, ClosedRange<Double>> adjustDomains(@NotNull ClosedRange<Double> xDomain, @NotNull ClosedRange<Double> yDomain, @NotNull DoubleVector displaySize) {
        Intrinsics.checkNotNullParameter(xDomain, (String)"xDomain");
        Intrinsics.checkNotNullParameter(yDomain, (String)"yDomain");
        Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
        Pair<ClosedRange<Double>, ClosedRange<Double>> adjusted = super.adjustDomains(xDomain, yDomain, displaySize);
        ClosedRange<Double> xDomain2 = adjusted.getFirst();
        ClosedRange<Double> yDomain2 = adjusted.getSecond();
        double spanX = SeriesUtil.INSTANCE.span(xDomain2);
        double spanY = SeriesUtil.INSTANCE.span(yDomain2);
        if (spanX < 1.0E-50 || spanY < 1.0E-50) {
            return new Pair<ClosedRange<Double>, ClosedRange<Double>>(xDomain2, yDomain2);
        }
        double displayW = displaySize.getX();
        double displayH = displaySize.getY();
        if (this.ratio > 1.0) {
            displayW *= this.ratio;
        } else {
            displayH *= 1.0 / this.ratio;
        }
        double ratioX = spanX / displayW;
        double ratioY = spanY / displayH;
        if (ratioX > ratioY) {
            double spanAdjusted = displayH * ratioX;
            yDomain2 = SeriesUtil.INSTANCE.expand(yDomain2, spanAdjusted);
        } else {
            double spanAdjusted = displayW * ratioY;
            xDomain2 = SeriesUtil.INSTANCE.expand(xDomain2, spanAdjusted);
        }
        return new Pair<ClosedRange<Double>, ClosedRange<Double>>(xDomain2, yDomain2);
    }

    public FixedRatioCoordProvider(double ratio, @Nullable ClosedRange<Double> xLim, @Nullable ClosedRange<Double> yLim) {
        super(xLim, yLim);
        this.ratio = ratio;
    }
}

