/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.aes.AestheticsDefaults;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.VarBinding;
import jetbrains.datalore.plot.builder.assemble.TypedScaleMap;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J\u001f\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00170\u0015\u00a2\u0006\u0002\u0010\u0018J\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J\u0006\u0010 \u001a\u00020!J\u0012\u0010\"\u001a\u00020\u000b2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J\u0012\u0010#\u001a\u00020\u000b2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015J\u000e\u0010$\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010%\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0003R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ljetbrains/datalore/plot/builder/assemble/StitchedPlotLayers;", "", "layers", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "(Ljava/util/List;)V", "aestheticsDefaults", "Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;", "getAestheticsDefaults", "()Ljetbrains/datalore/plot/base/aes/AestheticsDefaults;", "isLegendDisabled", "", "()Z", "legendKeyElementFactory", "Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Ljetbrains/datalore/plot/base/render/LegendKeyElementFactory;", "myLayers", "getBinding", "Ljetbrains/datalore/plot/builder/VarBinding;", "aes", "Ljetbrains/datalore/plot/base/Aes;", "getConstant", "T", "(Ljetbrains/datalore/plot/base/Aes;)Ljava/lang/Object;", "getDataRange", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "var", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "getScale", "Ljetbrains/datalore/plot/base/Scale;", "getScaleMap", "Ljetbrains/datalore/plot/builder/assemble/TypedScaleMap;", "hasBinding", "hasConstant", "isNumericData", "renderedAes", "plot-builder-portable"})
public final class StitchedPlotLayers {
    private final List<GeomLayer> myLayers;

    @NotNull
    public final LegendKeyElementFactory getLegendKeyElementFactory() {
        Collection collection2 = this.myLayers;
        boolean bl = false;
        Preconditions.INSTANCE.checkState(!collection2.isEmpty());
        return this.myLayers.get(0).getLegendKeyElementFactory();
    }

    @NotNull
    public final AestheticsDefaults getAestheticsDefaults() {
        Collection collection2 = this.myLayers;
        boolean bl = false;
        Preconditions.INSTANCE.checkState(!collection2.isEmpty());
        return this.myLayers.get(0).getAestheticsDefaults();
    }

    public final boolean isLegendDisabled() {
        Collection collection2 = this.myLayers;
        boolean bl = false;
        Preconditions.INSTANCE.checkState(!collection2.isEmpty());
        return this.myLayers.get(0).isLegendDisabled();
    }

    @NotNull
    public final List<Aes<?>> renderedAes() {
        return this.myLayers.isEmpty() ? CollectionsKt.emptyList() : this.myLayers.get(0).renderedAes();
    }

    public final boolean hasBinding(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Collection collection2 = this.myLayers;
        boolean bl = false;
        return !collection2.isEmpty() && this.myLayers.get(0).hasBinding(aes);
    }

    public final boolean hasConstant(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Collection collection2 = this.myLayers;
        boolean bl = false;
        return !collection2.isEmpty() && this.myLayers.get(0).hasConstant(aes);
    }

    public final <T> T getConstant(@NotNull Aes<T> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Collection collection2 = this.myLayers;
        boolean bl = false;
        Preconditions.INSTANCE.checkState(!collection2.isEmpty());
        return this.myLayers.get(0).getConstant(aes);
    }

    @NotNull
    public final VarBinding getBinding(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Collection collection2 = this.myLayers;
        boolean bl = false;
        Preconditions.INSTANCE.checkState(!collection2.isEmpty());
        return this.myLayers.get(0).getBinding(aes);
    }

    @NotNull
    public final Scale<?> getScale(@NotNull Aes<?> aes) {
        Intrinsics.checkNotNullParameter(aes, (String)"aes");
        Collection collection2 = this.myLayers;
        boolean bl = false;
        Preconditions.INSTANCE.checkState(!collection2.isEmpty());
        return this.myLayers.get(0).getScaleMap().get(aes);
    }

    @NotNull
    public final TypedScaleMap getScaleMap() {
        Collection collection2 = this.myLayers;
        boolean bl = false;
        Preconditions.INSTANCE.checkState(!collection2.isEmpty());
        return this.myLayers.get(0).getScaleMap();
    }

    @Nullable
    public final ClosedRange<Double> getDataRange(@NotNull DataFrame.Variable var) {
        Intrinsics.checkNotNullParameter((Object)var, (String)"var");
        Preconditions.INSTANCE.checkState(this.isNumericData(var), "Not numeric data [" + var + ']');
        ClosedRange<Double> result = null;
        for (GeomLayer layer : this.myLayers) {
            ClosedRange<Double> range2 = layer.getDataFrame().range(var);
            result = SeriesUtil.INSTANCE.span(result, range2);
        }
        return result;
    }

    public final boolean isNumericData(@NotNull DataFrame.Variable var) {
        Intrinsics.checkNotNullParameter((Object)var, (String)"var");
        Collection collection2 = this.myLayers;
        boolean bl = false;
        Preconditions.INSTANCE.checkState(!collection2.isEmpty());
        for (GeomLayer layer : this.myLayers) {
            if (layer.getDataFrame().isNumeric(var)) continue;
            return false;
        }
        return true;
    }

    public StitchedPlotLayers(@NotNull List<? extends GeomLayer> layers) {
        Intrinsics.checkNotNullParameter(layers, (String)"layers");
        this.myLayers = new ArrayList(layers);
    }
}

