/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.gcommon.collect.Iterables;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.base.values.Pair;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.aes.AestheticsDefaults;
import jetbrains.datalore.plot.base.render.LegendKeyElementFactory;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.PlotUtil;
import jetbrains.datalore.plot.builder.VarBinding;
import jetbrains.datalore.plot.builder.assemble.ColorBarAssembler;
import jetbrains.datalore.plot.builder.assemble.ColorBarOptions;
import jetbrains.datalore.plot.builder.assemble.GuideOptions;
import jetbrains.datalore.plot.builder.assemble.LegendAssembler;
import jetbrains.datalore.plot.builder.assemble.PlotFacets;
import jetbrains.datalore.plot.builder.assemble.PlotGuidesAssemblerUtil;
import jetbrains.datalore.plot.builder.assemble.StitchedPlotLayers;
import jetbrains.datalore.plot.builder.layout.FacetGridPlotLayout;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.PlotLayout;
import jetbrains.datalore.plot.builder.layout.SingleTilePlotLayout;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.theme.LegendTheme;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JZ\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u001c\u0010\b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t2\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J@\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00040\u00042\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ0\u0010\u001b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t2\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00040\u0004JB\u0010\u001d\u001a\u00020\u001e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\n2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u001c\u0010!\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\"H\u0002J0\u0010#\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002J.\u0010#\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0&2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0002\u00a8\u0006'"}, d2={"Ljetbrains/datalore/plot/builder/assemble/PlotAssemblerUtil;", "", "()V", "createLegends", "", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "stitchedLayersList", "Ljetbrains/datalore/plot/builder/assemble/StitchedPlotLayers;", "dataRangeByAes", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "guideOptionsMap", "Ljetbrains/datalore/plot/builder/assemble/GuideOptions;", "theme", "Ljetbrains/datalore/plot/builder/theme/LegendTheme;", "layersByPanel", "Ljetbrains/datalore/plot/builder/GeomLayer;", "createPlotLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayout;", "tileLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "faceted", "", "plotFacets", "Ljetbrains/datalore/plot/builder/assemble/PlotFacets;", "rangeByNumericAes", "layersByTile", "updateAesRangeMap", "", "aes", "range", "rangeByAes", "", "updateRange", "wasRange", "values", "", "plot-builder-portable"})
public final class PlotAssemblerUtil {
    public static final PlotAssemblerUtil INSTANCE;

    private final void updateAesRangeMap(Aes<?> aes, ClosedRange<Double> range2, Map<Aes<?>, ClosedRange<Double>> rangeByAes) {
        ClosedRange<Double> range3 = range2;
        if (range3 != null) {
            ClosedRange<Double> wasRange = rangeByAes.get(aes);
            if (wasRange != null) {
                range3 = wasRange.span(range3);
            }
            rangeByAes.put(aes, range3);
        }
    }

    private final ClosedRange<Double> updateRange(ClosedRange<Double> range2, ClosedRange<Double> wasRange) {
        ClosedRange<Double> range3 = range2;
        if (range3 != null) {
            if (wasRange != null) {
                range3 = wasRange.span(range3);
            }
            return range3;
        }
        return wasRange;
    }

    private final ClosedRange<Double> updateRange(Iterable<Double> values2, ClosedRange<Double> wasRange) {
        if (!Iterables.INSTANCE.isEmpty(values2)) {
            ClosedRange<Double> newRange = ClosedRange.Companion.encloseAll(values2);
            if (wasRange != null) {
                newRange = wasRange.span(newRange);
            }
            return newRange;
        }
        return wasRange;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<LegendBoxInfo> createLegends(@NotNull List<? extends List<? extends GeomLayer>> layersByPanel, @NotNull Map<Aes<?>, ? extends GuideOptions> guideOptionsMap, @NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter(layersByPanel, (String)"layersByPanel");
        Intrinsics.checkNotNullParameter(guideOptionsMap, (String)"guideOptionsMap");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        int planeCount = 0;
        Collection collection2 = layersByPanel;
        int n = 0;
        if (!collection2.isEmpty()) {
            planeCount = layersByPanel.get(0).size();
        }
        ArrayList<StitchedPlotLayers> stitchedLayersList = new ArrayList<StitchedPlotLayers>();
        n = 0;
        int n2 = planeCount;
        while (n < n2) {
            void i;
            ArrayList<GeomLayer> layersOnPlane = new ArrayList<GeomLayer>();
            for (List<? extends GeomLayer> list2 : layersByPanel) {
                layersOnPlane.add(list2.get((int)i));
            }
            stitchedLayersList.add(new StitchedPlotLayers((List<? extends GeomLayer>)layersOnPlane));
            ++i;
        }
        HashMap dataRangeByAes = new HashMap();
        Iterator iterator2 = stitchedLayersList.iterator();
        while (iterator2.hasNext()) {
            StitchedPlotLayers stitchedPlotLayers;
            StitchedPlotLayers stitchedPlotLayers2 = stitchedPlotLayers = (StitchedPlotLayers)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)stitchedPlotLayers2, (String)"stitchedPlotLayers");
            Map<Aes<?>, ClosedRange<Double>> map2 = PlotGuidesAssemblerUtil.INSTANCE.guideDataRangeByAes(stitchedPlotLayers2, guideOptionsMap);
            for (Aes<?> aes : map2.keySet()) {
                ClosedRange<Double> range2 = map2.get(aes);
                this.updateAesRangeMap(aes, range2, dataRangeByAes);
            }
        }
        return this.createLegends((List<StitchedPlotLayers>)stitchedLayersList, dataRangeByAes, guideOptionsMap, theme);
    }

    private final List<LegendBoxInfo> createLegends(List<StitchedPlotLayers> stitchedLayersList, Map<Aes<?>, ? extends ClosedRange<Double>> dataRangeByAes, Map<Aes<?>, ? extends GuideOptions> guideOptionsMap, LegendTheme theme) {
        LegendBoxInfo boxInfo;
        LinkedHashMap legendAssemblerByTitle = new LinkedHashMap();
        LinkedHashMap colorBarAssemblerByTitle = new LinkedHashMap();
        for (StitchedPlotLayers stitchedLayers : stitchedLayersList) {
            HashMap layerConstantByAes = new HashMap();
            for (Aes<?> aes : stitchedLayers.renderedAes()) {
                if (!stitchedLayers.hasConstant(aes)) continue;
                Map map2 = layerConstantByAes;
                Object obj = stitchedLayers.getConstant(aes);
                Intrinsics.checkNotNull(obj);
                map2.put(aes, obj);
            }
            LinkedHashMap layerBindingsByScaleName = new LinkedHashMap();
            List<Aes<?>> aesList = PlotGuidesAssemblerUtil.INSTANCE.mappedRenderedAesToCreateGuides(stitchedLayers, guideOptionsMap);
            for (Aes<?> aes : aesList) {
                boolean colorBar = false;
                VarBinding binding = stitchedLayers.getBinding(aes);
                Scale<Color> scale = stitchedLayers.getScale(aes);
                String scaleName = scale.getName();
                if (guideOptionsMap.containsKey(aes)) {
                    GuideOptions guideOptions = guideOptionsMap.get(aes);
                    if (guideOptions instanceof ColorBarOptions) {
                        Scale<Color> colorScale;
                        PlotGuidesAssemblerUtil.INSTANCE.checkFitsColorBar(binding.getAes(), scale);
                        colorBar = true;
                        if (scale == null) {
                            throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.base.Scale<jetbrains.datalore.base.values.Color>");
                        }
                        ((Map)colorBarAssemblerByTitle).put(scaleName, PlotGuidesAssemblerUtil.INSTANCE.createColorBarAssembler(scaleName, binding.getAes(), dataRangeByAes, colorScale, (ColorBarOptions)guideOptions, theme));
                    }
                } else if (PlotGuidesAssemblerUtil.INSTANCE.fitsColorBar(binding.getAes(), scale)) {
                    Scale<Color> colorScale;
                    colorBar = true;
                    if (scale == null) {
                        throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.base.Scale<jetbrains.datalore.base.values.Color>");
                    }
                    ((Map)colorBarAssemblerByTitle).put(scaleName, PlotGuidesAssemblerUtil.INSTANCE.createColorBarAssembler(scaleName, binding.getAes(), dataRangeByAes, colorScale, null, theme));
                }
                if (colorBar) continue;
                if (!layerBindingsByScaleName.containsKey(scaleName)) {
                    ((Map)layerBindingsByScaleName).put(scaleName, new ArrayList());
                }
                Object v = layerBindingsByScaleName.get(scaleName);
                Intrinsics.checkNotNull(v);
                ((List)v).add(binding);
            }
            for (String scaleName : layerBindingsByScaleName.keySet()) {
                if (!legendAssemblerByTitle.containsKey(scaleName)) {
                    Map map3 = legendAssemblerByTitle;
                    String string = scaleName;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scaleName");
                    map3.put(string, new LegendAssembler(scaleName, guideOptionsMap, theme));
                }
                Object v = layerBindingsByScaleName.get(scaleName);
                Intrinsics.checkNotNull(v);
                Intrinsics.checkNotNullExpressionValue(v, (String)"layerBindingsByScaleName[scaleName]!!");
                List varBindings = (List)v;
                LegendKeyElementFactory legendKeyFactory = stitchedLayers.getLegendKeyElementFactory();
                AestheticsDefaults aestheticsDefaults = stitchedLayers.getAestheticsDefaults();
                Object v2 = legendAssemblerByTitle.get(scaleName);
                Intrinsics.checkNotNull(v2);
                Intrinsics.checkNotNullExpressionValue(v2, (String)"legendAssemblerByTitle[scaleName]!!");
                LegendAssembler legendAssembler = (LegendAssembler)v2;
                legendAssembler.addLayer(legendKeyFactory, varBindings, layerConstantByAes, aestheticsDefaults, stitchedLayers.getScaleMap(), dataRangeByAes);
            }
        }
        ArrayList<LegendBoxInfo> legendBoxInfos = new ArrayList<LegendBoxInfo>();
        for (String legendTitle : colorBarAssemblerByTitle.keySet()) {
            Object v = colorBarAssemblerByTitle.get(legendTitle);
            Intrinsics.checkNotNull(v);
            boxInfo = ((ColorBarAssembler)v).createColorBar();
            if (boxInfo.isEmpty()) continue;
            legendBoxInfos.add(boxInfo);
        }
        for (String legendTitle : legendAssemblerByTitle.keySet()) {
            Object v = legendAssemblerByTitle.get(legendTitle);
            Intrinsics.checkNotNull(v);
            boxInfo = ((LegendAssembler)v).createLegend();
            if (boxInfo.isEmpty()) continue;
            legendBoxInfos.add(boxInfo);
        }
        return legendBoxInfos;
    }

    @NotNull
    public final PlotLayout createPlotLayout(@NotNull TileLayout tileLayout, boolean faceted, @Nullable PlotFacets plotFacets) {
        Intrinsics.checkNotNullParameter((Object)tileLayout, (String)"tileLayout");
        if (!faceted) {
            return new SingleTilePlotLayout(tileLayout);
        }
        PlotFacets plotFacets2 = plotFacets;
        Intrinsics.checkNotNull((Object)plotFacets2);
        List<?> xLevels = plotFacets2.getXLevels();
        List<?> yLevels = plotFacets.getYLevels();
        ArrayList<String> xLabs = new ArrayList<String>();
        List<?> list2 = xLevels;
        Intrinsics.checkNotNull(list2);
        for (Object level : list2) {
            xLabs.add(String.valueOf(level));
        }
        ArrayList<String> yLabs = new ArrayList<String>();
        List<?> list3 = yLevels;
        Intrinsics.checkNotNull(list3);
        for (Object level : list3) {
            yLabs.add(String.valueOf(level));
        }
        return new FacetGridPlotLayout((List<String>)xLabs, (List<String>)yLabs, tileLayout);
    }

    @NotNull
    public final Map<Aes<?>, ClosedRange<Double>> rangeByNumericAes(@NotNull List<? extends List<? extends GeomLayer>> layersByTile) {
        Intrinsics.checkNotNullParameter(layersByTile, (String)"layersByTile");
        HashMap rangeByAes = new HashMap();
        HashMap dryRunAestheticsByTileLayer = new HashMap();
        for (List<? extends GeomLayer> list2 : layersByTile) {
            for (GeomLayer geomLayer : list2) {
                Aesthetics aesthetics = PlotUtil.INSTANCE.createLayerDryRunAesthetics(geomLayer);
                ((Map)dryRunAestheticsByTileLayer).put(geomLayer, aesthetics);
            }
        }
        for (List<? extends GeomLayer> list3 : layersByTile) {
            for (GeomLayer geomLayer : list3) {
                Iterable<Aes<Double>> numericAes = Aes.Companion.numeric((Iterable)geomLayer.renderedAes());
                Object v = dryRunAestheticsByTileLayer.get(geomLayer);
                Intrinsics.checkNotNull(v);
                Intrinsics.checkNotNullExpressionValue(v, (String)"dryRunAestheticsByTileLayer[layer]!!");
                Aesthetics aesthetics = (Aesthetics)v;
                Pair<ClosedRange<Double>, ClosedRange<Double>> xyRanges = PlotUtil.INSTANCE.computeLayerDryRunXYRanges(geomLayer, aesthetics);
                boolean isXCalculated = false;
                boolean isYCalculated = false;
                for (Aes<Double> aes : numericAes) {
                    ClosedRange<Double> layerAesRange = null;
                    if (geomLayer.hasBinding(aes)) {
                        Scale<Double> scale = geomLayer.getScaleMap().get(aes);
                        if (scale.isContinuousDomain()) {
                            layerAesRange = this.updateRange((Iterable<Double>)ScaleUtil.INSTANCE.transformedDefinedLimits(scale), layerAesRange);
                        }
                        if (scale.hasBreaks()) {
                            layerAesRange = this.updateRange((Iterable<Double>)ScaleUtil.INSTANCE.breaksTransformed(scale), layerAesRange);
                        }
                    }
                    Aes<Double> realAes = null;
                    if (Aes.Companion.isAffectingScaleX(aes)) {
                        if (isXCalculated) continue;
                        isXCalculated = true;
                        realAes = Aes.Companion.getX();
                        ClosedRange<Double> xRange = xyRanges.getFirst();
                        layerAesRange = this.updateRange(xRange, layerAesRange);
                        layerAesRange = PlotUtil.INSTANCE.rangeWithExpand(geomLayer, aes, layerAesRange);
                    } else if (Aes.Companion.isAffectingScaleY(aes)) {
                        if (isYCalculated) continue;
                        isYCalculated = true;
                        realAes = Aes.Companion.getY();
                        ClosedRange<Double> yRange = xyRanges.getSecond();
                        layerAesRange = this.updateRange(yRange, layerAesRange);
                        layerAesRange = PlotUtil.INSTANCE.rangeWithExpand(geomLayer, aes, layerAesRange);
                    } else {
                        realAes = aes;
                        layerAesRange = this.updateRange(aesthetics.range(aes), layerAesRange);
                    }
                    if (geomLayer.rangeIncludesZero(aes)) {
                        layerAesRange = this.updateRange(ClosedRange.Companion.singleton(0.0), layerAesRange);
                    }
                    this.updateAesRangeMap(realAes, layerAesRange, rangeByAes);
                }
            }
        }
        for (Aes aes : CollectionsKt.listOf((Object[])new Aes[]{Aes.Companion.getX(), Aes.Companion.getY()})) {
            ((Map)rangeByAes).put(aes, SeriesUtil.INSTANCE.ensureApplicableRange((ClosedRange)rangeByAes.get(aes)));
        }
        return rangeByAes;
    }

    private PlotAssemblerUtil() {
    }

    static {
        PlotAssemblerUtil plotAssemblerUtil;
        INSTANCE = plotAssemblerUtil = new PlotAssemblerUtil();
    }
}

