/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.gcommon.collect.Iterables;
import jetbrains.datalore.base.gcommon.collect.Sets;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Pair;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.aes.AestheticsBuilder;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.base.scale.Mappers;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.PlotUtil;
import jetbrains.datalore.plot.builder.PosProviderContext;
import jetbrains.datalore.plot.builder.assemble.GeomContextBuilder;
import jetbrains.datalore.plot.builder.assemble.ImmutableGeomContext;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JA\u0010\u0003\u001a\u0002H\u0004\"\u0004\b\u0000\u0010\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u0002H\u00042\u0018\u0010\b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u0001H\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0002\u0010\u000bJ,\u0010\f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J<\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J2\u0010\u0017\u001a\u001e\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0011J<\u0010\u001b\u001a\u001e\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J<\u0010\u001c\u001a\u001e\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r\u0012\f\u0012\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r0\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J]\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2&\u0010\u001e\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u001f2\u001e\u0010 \u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\r0\u001fH\u0000\u00a2\u0006\u0002\b!J\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\u001d\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0005\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b%J\"\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010'2\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J\u001e\u0010(\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\n0\u0006H\u0002J\u001e\u0010)\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\n0\u0006H\u0002J_\u0010*\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t0\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2(\u0010+\u001a$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u0006\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t0\u001fH\u0000\u00a2\u0006\u0002\b,J4\u0010-\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\rJ \u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\n2\u0006\u00103\u001a\u000204H\u0002\u00a8\u00065"}, d2={"Ljetbrains/datalore/plot/builder/PlotUtil;", "", "()V", "asAesValue", "T", "aes", "Ljetbrains/datalore/plot/base/Aes;", "dataValue", "mapperOption", "Lkotlin/Function1;", "", "(Ljetbrains/datalore/plot/base/Aes;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "combineRanges", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "aesList", "", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "computeLayerDryRunRangeAfterSizeExpand", "locationAes", "sizeAes", "geomCtx", "Ljetbrains/datalore/plot/base/GeomContext;", "computeLayerDryRunXYRanges", "Ljetbrains/datalore/base/values/Pair;", "layer", "Ljetbrains/datalore/plot/builder/GeomLayer;", "computeLayerDryRunXYRangesAfterPosAdjustment", "computeLayerDryRunXYRangesAfterSizeExpand", "createLayerAesthetics", "sharedMappers", "", "overallNumericDomains", "createLayerAesthetics$plot_builder_portable", "createLayerDryRunAesthetics", "createLayerPos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "createLayerPos$plot_builder_portable", "findBoundScale", "Ljetbrains/datalore/plot/base/Scale;", "getAdditiveExpand", "getMultiplicativeExpand", "prepareLayerAestheticMappers", "sharedNumericMappers", "prepareLayerAestheticMappers$plot_builder_portable", "rangeWithExpand", "range", "updateExpandedMinMax", "", "value", "expand", "expandedMinMax", "", "plot-builder-portable"})
public final class PlotUtil {
    public static final PlotUtil INSTANCE;

    @NotNull
    public final PositionAdjustment createLayerPos$plot_builder_portable(@NotNull GeomLayer layer, @NotNull Aesthetics aes) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        return layer.createPos(new PosProviderContext(aes){
            @NotNull
            private final Lazy groupCount$delegate;
            final /* synthetic */ Aesthetics $aes;

            @NotNull
            public Aesthetics getAesthetics() {
                return this.$aes;
            }

            public int getGroupCount() {
                Lazy lazy = this.groupCount$delegate;
                createLayerPos.1 var2_2 = this;
                Object var3_3 = null;
                boolean bl = false;
                return ((Number)lazy.getValue()).intValue();
            }
            {
                this.$aes = $captured_local_variable$0;
                this.groupCount$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Integer>(this){
                    final /* synthetic */ createLayerPos.1 this$0;

                    public final int invoke() {
                        Set<Integer> set2 = Sets.INSTANCE.newHashSet(this.this$0.$aes.groups());
                        return set2.size();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }));
            }
        });
    }

    @NotNull
    public final Pair<ClosedRange<Double>, ClosedRange<Double>> computeLayerDryRunXYRanges(@NotNull GeomLayer layer, @NotNull Aesthetics aes) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)aes, (String)"aes");
        ImmutableGeomContext geomCtx = new GeomContextBuilder().aesthetics(aes).build();
        Pair<ClosedRange<Double>, ClosedRange<Double>> rangesAfterPosAdjustment = this.computeLayerDryRunXYRangesAfterPosAdjustment(layer, aes, geomCtx);
        Pair<ClosedRange<Double>, ClosedRange<Double>> rangesAfterSizeExpand = this.computeLayerDryRunXYRangesAfterSizeExpand(layer, aes, geomCtx);
        ClosedRange<Double> rangeX = rangesAfterPosAdjustment.getFirst();
        if (rangeX == null) {
            rangeX = rangesAfterSizeExpand.getFirst();
        } else if (rangesAfterSizeExpand.getFirst() != null) {
            ClosedRange<Double> closedRange = rangesAfterSizeExpand.getFirst();
            Intrinsics.checkNotNull(closedRange);
            rangeX = rangeX.span(closedRange);
        }
        ClosedRange<Double> rangeY = rangesAfterPosAdjustment.getSecond();
        if (rangeY == null) {
            rangeY = rangesAfterSizeExpand.getSecond();
        } else if (rangesAfterSizeExpand.getSecond() != null) {
            ClosedRange<Double> closedRange = rangesAfterSizeExpand.getSecond();
            Intrinsics.checkNotNull(closedRange);
            rangeY = rangeY.span(closedRange);
        }
        return new Pair<ClosedRange<Double>, ClosedRange<Double>>(rangeX, rangeY);
    }

    private final ClosedRange<Double> combineRanges(List<Aes<Double>> aesList, Aesthetics aesthetics) {
        ClosedRange<Double> result = null;
        for (Aes<Double> aes : aesList) {
            ClosedRange<Double> range2 = aesthetics.range(aes);
            if (range2 == null) continue;
            ClosedRange<Double> closedRange = result;
            if (closedRange == null || (closedRange = closedRange.span(range2)) == null) {
                closedRange = range2;
            }
            result = closedRange;
        }
        return result;
    }

    private final Pair<ClosedRange<Double>, ClosedRange<Double>> computeLayerDryRunXYRangesAfterPosAdjustment(GeomLayer layer, Aesthetics aes, GeomContext geomCtx) {
        List<Aes<Double>> posAesX = Iterables.INSTANCE.toList(Aes.Companion.affectingScaleX((Iterable)layer.renderedAes()));
        List<Aes<Double>> posAesY = Iterables.INSTANCE.toList(Aes.Companion.affectingScaleY((Iterable)layer.renderedAes()));
        PositionAdjustment pos = this.createLayerPos$plot_builder_portable(layer, aes);
        if (pos.isIdentity()) {
            ClosedRange<Double> rangeX = this.combineRanges(posAesX, aes);
            ClosedRange<Double> rangeY = this.combineRanges(posAesY, aes);
            return new Pair<ClosedRange<Double>, ClosedRange<Double>>(rangeX, rangeY);
        }
        double adjustedMinX = 0.0;
        double adjustedMaxX = 0.0;
        double adjustedMinY = 0.0;
        double adjustedMaxY = 0.0;
        boolean rangesInited = false;
        int cardinality = posAesX.size() * posAesY.size();
        Double[] px = new Double[cardinality];
        Double[] py = new Double[cardinality];
        for (DataPointAesthetics p : aes.dataPoints()) {
            int i = -1;
            for (Aes<Double> aesX : posAesX) {
                Double valX = p.numeric(aesX);
                for (Aes<Double> aesY : posAesY) {
                    Double valY = p.numeric(aesY);
                    px[++i] = valX;
                    py[i] = valY;
                }
            }
            while (i >= 0) {
                if (px[i] != null && py[i] != null) {
                    Double x2 = px[i];
                    Double y2 = py[i];
                    if (SeriesUtil.INSTANCE.isFinite(x2) && SeriesUtil.INSTANCE.isFinite(y2)) {
                        Double d = x2;
                        Intrinsics.checkNotNull((Object)d);
                        double d2 = d;
                        Double d3 = y2;
                        Intrinsics.checkNotNull((Object)d3);
                        DoubleVector newLoc = pos.translate(new DoubleVector(d2, d3), p, geomCtx);
                        double adjustedX = newLoc.getX();
                        double adjustedY = newLoc.getY();
                        if (rangesInited) {
                            boolean bl = false;
                            adjustedMinX = Math.min(adjustedX, adjustedMinX);
                            bl = false;
                            adjustedMaxX = Math.max(adjustedX, adjustedMaxX);
                            bl = false;
                            adjustedMinY = Math.min(adjustedY, adjustedMinY);
                            bl = false;
                            adjustedMaxY = Math.max(adjustedY, adjustedMaxY);
                        } else {
                            adjustedMinX = adjustedMaxX = adjustedX;
                            adjustedMinY = adjustedMaxY = adjustedY;
                            rangesInited = true;
                        }
                    }
                }
                --i;
            }
        }
        ClosedRange<Comparable> xRange = rangesInited ? new ClosedRange<Comparable>(Double.valueOf(adjustedMinX), Double.valueOf(adjustedMaxX)) : null;
        ClosedRange<Comparable> yRange = rangesInited ? new ClosedRange<Comparable>(Double.valueOf(adjustedMinY), Double.valueOf(adjustedMaxY)) : null;
        return new Pair<ClosedRange<Double>, ClosedRange<Double>>(xRange, yRange);
    }

    private final Pair<ClosedRange<Double>, ClosedRange<Double>> computeLayerDryRunXYRangesAfterSizeExpand(GeomLayer layer, Aesthetics aesthetics, GeomContext geomCtx) {
        List<Aes<?>> renderedAes = layer.renderedAes();
        boolean computeExpandX = renderedAes.contains(Aes.Companion.getWIDTH());
        boolean computeExpandY = renderedAes.contains(Aes.Companion.getHEIGHT());
        ClosedRange<Double> rangeX = computeExpandX ? this.computeLayerDryRunRangeAfterSizeExpand(Aes.Companion.getX(), Aes.Companion.getWIDTH(), aesthetics, geomCtx) : null;
        ClosedRange<Double> rangeY = computeExpandY ? this.computeLayerDryRunRangeAfterSizeExpand(Aes.Companion.getY(), Aes.Companion.getHEIGHT(), aesthetics, geomCtx) : null;
        return new Pair<ClosedRange<Double>, Object>(rangeX, rangeY);
    }

    /*
     * WARNING - void declaration
     */
    private final ClosedRange<Double> computeLayerDryRunRangeAfterSizeExpand(Aes<Double> locationAes, Aes<Double> sizeAes, Aesthetics aesthetics, GeomContext geomCtx) {
        Iterator<Double> locations = aesthetics.numericValues(locationAes).iterator();
        Iterator<Double> sizes = aesthetics.numericValues(sizeAes).iterator();
        double resolution = geomCtx.getResolution(locationAes);
        double[] minMax = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        int n = 0;
        int n2 = aesthetics.dataPointCount();
        while (n < n2) {
            void i;
            if (!locations.hasNext()) {
                throw (Throwable)new IllegalStateException("Index is out of bounds: " + (int)i + " for " + locationAes);
            }
            if (!sizes.hasNext()) {
                throw (Throwable)new IllegalStateException("Index is out of bounds: " + (int)i + " for " + sizeAes);
            }
            Double loc = locations.next();
            Double size2 = sizes.next();
            if (SeriesUtil.INSTANCE.isFinite(loc) && SeriesUtil.INSTANCE.isFinite(size2)) {
                Double d = size2;
                Intrinsics.checkNotNull((Object)d);
                double expand = resolution * (d / (double)2);
                Double d2 = loc;
                Intrinsics.checkNotNull((Object)d2);
                this.updateExpandedMinMax(d2, expand, minMax);
            }
            ++i;
        }
        return minMax[0] <= minMax[1] ? new ClosedRange<Comparable>(Double.valueOf(minMax[0]), Double.valueOf(minMax[1])) : null;
    }

    private final void updateExpandedMinMax(double value, double expand, double[] expandedMinMax) {
        double d = value - expand;
        double d2 = expandedMinMax[0];
        boolean bl = false;
        expandedMinMax[0] = Math.min(d, d2);
        d = value + expand;
        d2 = expandedMinMax[1];
        bl = false;
        expandedMinMax[1] = Math.max(d, d2);
    }

    @NotNull
    public final Aesthetics createLayerDryRunAesthetics(@NotNull GeomLayer layer) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        HashMap dryRunMapperByAes = new HashMap();
        for (Aes<?> aes : layer.renderedAes()) {
            if (!aes.isNumeric()) continue;
            Aes<?> aes2 = aes;
            if (aes2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.base.Aes<kotlin.Double>");
            }
            ((Map)dryRunMapperByAes).put(aes2, Mappers.INSTANCE.getIDENTITY());
        }
        Map<Aes<?>, Function1<Double, Object>> mappers = this.prepareLayerAestheticMappers$plot_builder_portable(layer, dryRunMapperByAes);
        return this.createLayerAesthetics$plot_builder_portable(layer, mappers, MapsKt.emptyMap());
    }

    @NotNull
    public final Map<Aes<?>, Function1<Double, Object>> prepareLayerAestheticMappers$plot_builder_portable(@NotNull GeomLayer layer, @NotNull Map<Aes<Double>, ? extends Function1<? super Double, Double>> sharedNumericMappers) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(sharedNumericMappers, (String)"sharedNumericMappers");
        HashMap<Aes<Double>, ? extends Function1<? super Double, Double>> mappers = new HashMap<Aes<Double>, Function1<? super Double, Double>>(sharedNumericMappers);
        for (Aes<?> aes : layer.renderedAes()) {
            Map<Aes<Double>, ? extends Function1<? super Double, Double>> map2 = sharedNumericMappers;
            boolean bl = false;
            Object mapper2 = map2.get(aes);
            if (mapper2 == null) {
                if (Aes.Companion.isPositionalX(aes)) {
                    mapper2 = sharedNumericMappers.get(Aes.Companion.getX());
                } else if (Aes.Companion.isPositionalY(aes)) {
                    mapper2 = sharedNumericMappers.get(Aes.Companion.getY());
                }
            }
            if (mapper2 == null && layer.hasBinding(aes)) {
                mapper2 = layer.getScaleMap().get(aes).getMapper();
            }
            if (mapper2 == null) continue;
            ((Map)mappers).put(aes, mapper2);
        }
        return mappers;
    }

    @NotNull
    public final Aesthetics createLayerAesthetics$plot_builder_portable(@NotNull GeomLayer layer, @NotNull Map<Aes<?>, ? extends Function1<? super Double, ? extends Object>> sharedMappers, @NotNull Map<Aes<Double>, ? extends ClosedRange<Double>> overallNumericDomains) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter(sharedMappers, (String)"sharedMappers");
        Intrinsics.checkNotNullParameter(overallNumericDomains, (String)"overallNumericDomains");
        AestheticsBuilder aesBuilder = new AestheticsBuilder(0, 1, null);
        aesBuilder.group(layer.getGroup());
        Object object = overallNumericDomains;
        boolean bl = false;
        for (Map.Entry<Aes<Double>, ? extends ClosedRange<Double>> entry : object.entrySet()) {
            Iterator<Aes<?>> aes;
            Function1<Double, Object> function1 = entry;
            boolean bl2 = false;
            object = function1.getKey();
            function1 = entry;
            bl2 = false;
            ClosedRange<Double> closedRange = function1.getValue();
            Function1<Double, Object> function12 = sharedMappers.get(aes);
            if (function12 == null) continue;
            function1 = function12;
            bl2 = false;
            boolean bl3 = false;
            Function1<Double, Object> mapper2 = function1;
            boolean bl4 = false;
            Object object2 = mapper2.invoke((Object)closedRange.getLowerEnd());
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            Object object3 = mapper2.invoke((Object)closedRange.getUpperEnd());
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Double");
            }
            ClosedRange<Comparable> range2 = new ClosedRange<Comparable>((Double)object2, (Double)object3);
            aesBuilder.overallRange((Aes<Double>)((Object)aes), (ClosedRange<Double>)range2);
        }
        boolean hasPositionalConstants = false;
        for (Aes<?> aes : layer.renderedAes()) {
            if (!Aes.Companion.isPositional(aes) || !layer.hasConstant(aes)) continue;
            hasPositionalConstants = true;
            break;
        }
        DataFrame data = layer.getDataFrame();
        Integer dataPointCount = null;
        for (Aes aes : layer.renderedAes()) {
            Object v;
            Aes aes2;
            if (aes == null) {
                throw new NullPointerException("null cannot be cast to non-null type jetbrains.datalore.plot.base.Aes<kotlin.Any>");
            }
            Function1<Double, Object> mapperOption = sharedMappers.get(aes2);
            if (layer.hasConstant(aes2)) {
                v = layer.getConstant(aes2);
                aesBuilder.constantAes(aes2, this.asAesValue(aes2, v, mapperOption));
                continue;
            }
            if (layer.hasBinding(aes2)) {
                Preconditions.INSTANCE.checkState(mapperOption != null, "No scale mapper defined for aesthetic " + aes2);
                DataFrame.Variable transformVar = DataFrameUtil.INSTANCE.transformVarFor(aes2);
                Preconditions.INSTANCE.checkState(data.has(transformVar), "Undefined var " + transformVar + " for aesthetic " + aes2);
                List<Double> numericValues2 = data.getNumeric(transformVar);
                if (dataPointCount == null) {
                    dataPointCount = numericValues2.size();
                } else {
                    int range2 = numericValues2.size();
                    Preconditions.INSTANCE.checkState(dataPointCount == range2, "" + aes2 + " expected data size=" + dataPointCount + " was size=" + numericValues2.size());
                }
                if (dataPointCount == 0 && hasPositionalConstants) {
                    aesBuilder.constantAes(aes2, layer.getAestheticsDefaults().defaultValue(aes2));
                    continue;
                }
                Function1<Double, Object> function1 = mapperOption;
                if (function1 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type (kotlin.Double?) -> kotlin.Any?");
                }
                Function1 integerFunction = AestheticsBuilder.Companion.listMapper(numericValues2, (Function1)TypeIntrinsics.beforeCheckcastToFunctionOfArity(function1, (int)1));
                aesBuilder.aes(aes2, integerFunction);
                continue;
            }
            v = layer.getDefault(aes2);
            aesBuilder.constantAes(aes2, this.asAesValue(aes2, v, mapperOption));
        }
        if (dataPointCount != null && dataPointCount > 0) {
            aesBuilder.dataPointCount(dataPointCount);
        } else if (hasPositionalConstants) {
            aesBuilder.dataPointCount(1);
        }
        return aesBuilder.build();
    }

    private final <T> T asAesValue(Aes<?> aes, T dataValue, Function1<? super Double, ? extends T> mapperOption) {
        Object object;
        if (aes.isNumeric() && mapperOption != null) {
            T t = dataValue;
            if (!(t instanceof Double)) {
                t = null;
            }
            if ((object = mapperOption.invoke((Object)((Double)t))) == null) {
                throw (Throwable)new IllegalArgumentException("Can't map " + dataValue + " to aesthetic " + aes);
            }
        } else {
            object = dataValue;
        }
        return object;
    }

    @Nullable
    public final ClosedRange<Double> rangeWithExpand(@NotNull GeomLayer layer, @NotNull Aes<Double> aes, @Nullable ClosedRange<Double> range2) {
        double upperExpand;
        double lowerExpand;
        double upperEndpoint;
        double lowerEndpoint;
        block6: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
                Intrinsics.checkNotNullParameter(aes, (String)"aes");
                if (range2 == null) {
                    return null;
                }
                double mulExp = this.getMultiplicativeExpand(layer, aes);
                double addExp = this.getAdditiveExpand(layer, aes);
                lowerEndpoint = ((Number)range2.getLowerEnd()).doubleValue();
                upperEndpoint = ((Number)range2.getUpperEnd()).doubleValue();
                double length = upperEndpoint - lowerEndpoint;
                upperExpand = lowerExpand = addExp + length * mulExp;
                if (!layer.rangeIncludesZero(aes)) break block6;
                if (lowerEndpoint == 0.0 || upperEndpoint == 0.0) break block7;
                boolean bl = false;
                bl = false;
                if (Math.signum(lowerEndpoint) != Math.signum(upperEndpoint)) break block6;
            }
            if (lowerEndpoint >= 0.0) {
                lowerExpand = 0.0;
            } else {
                upperExpand = 0.0;
            }
        }
        return new ClosedRange<Comparable>(Double.valueOf(lowerEndpoint - lowerExpand), Double.valueOf(upperEndpoint + upperExpand));
    }

    private final double getMultiplicativeExpand(GeomLayer layer, Aes<Double> aes) {
        Scale<?> scale;
        Scale<?> scale2 = scale = this.findBoundScale(layer, aes);
        return scale2 != null ? scale2.getMultiplicativeExpand() : 0.0;
    }

    private final double getAdditiveExpand(GeomLayer layer, Aes<Double> aes) {
        Scale<?> scale;
        Scale<?> scale2 = scale = this.findBoundScale(layer, aes);
        return scale2 != null ? scale2.getAdditiveExpand() : 0.0;
    }

    private final Scale<?> findBoundScale(GeomLayer layer, Aes<?> aes) {
        if (layer.hasBinding(aes)) {
            return layer.getScaleMap().get(aes);
        }
        if (Aes.Companion.isPositional(aes)) {
            boolean horizontal = Aes.Companion.isPositionalX(aes);
            for (Aes<?> rendered : layer.renderedAes()) {
                if (!layer.hasBinding(rendered) || (!horizontal || !Aes.Companion.isPositionalX(rendered)) && (horizontal || !Aes.Companion.isPositionalY(rendered))) continue;
                return layer.getScaleMap().get(aes);
            }
        }
        return null;
    }

    private PlotUtil() {
    }

    static {
        PlotUtil plotUtil;
        INSTANCE = plotUtil = new PlotUtil();
    }
}

