/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.base.gcommon.base.Strings;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.Plot;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.guide.TooltipAnchor;
import jetbrains.datalore.plot.builder.layout.LegendBoxInfo;
import jetbrains.datalore.plot.builder.layout.PlotLayout;
import jetbrains.datalore.plot.builder.theme.Theme;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u00011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0016J\u0014\u0010\u001e\u001a\u00020\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0006J\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0006J\u0014\u0010%\u001a\u00020\u00002\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0014\u0010&\u001a\u00020\u00002\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\tJ\u000e\u0010)\u001a\u00020(2\u0006\u0010\u001d\u001a\u00020\tJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\fJ\u000e\u0010,\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0006J\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\u0014J\u0010\u0010/\u001a\u00020(2\b\u00100\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\u000fj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u000fj\b\u0012\u0004\u0012\u00020\u0016`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Ljetbrains/datalore/plot/builder/PlotBuilder;", "", "myTheme", "Ljetbrains/datalore/plot/builder/theme/Theme;", "(Ljetbrains/datalore/plot/builder/theme/Theme;)V", "hasLiveMap", "", "myAxisEnabled", "myAxisTitleBottom", "", "myAxisTitleLeft", "myCoordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "myInteractionsEnabled", "myLayersByTile", "Ljava/util/ArrayList;", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "Lkotlin/collections/ArrayList;", "myLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayout;", "myLegendBoxInfos", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "myScaleXProto", "Ljetbrains/datalore/plot/base/Scale;", "", "myScaleYProto", "myTitle", "addLegendBoxInfo", "v", "addTileLayers", "tileLayers", "axisEnabled", "b", "build", "Ljetbrains/datalore/plot/builder/Plot;", "interactionsEnabled", "scaleXProto", "scaleYProto", "setAxisTitleBottom", "", "setAxisTitleLeft", "setCoordProvider", "coordProvider", "setLiveMap", "setPlotLayout", "layout", "setTitle", "title", "MyPlot", "plot-builder-portable"})
public final class PlotBuilder {
    private final ArrayList<List<GeomLayer>> myLayersByTile;
    private String myTitle;
    private CoordProvider myCoordProvider;
    private PlotLayout myLayout;
    private String myAxisTitleLeft;
    private String myAxisTitleBottom;
    private final ArrayList<LegendBoxInfo> myLegendBoxInfos;
    private Scale<Double> myScaleXProto;
    private Scale<Double> myScaleYProto;
    private boolean myAxisEnabled;
    private boolean myInteractionsEnabled;
    private boolean hasLiveMap;
    private final Theme myTheme;

    public final void setTitle(@Nullable String title) {
        this.myTitle = title;
    }

    public final void setAxisTitleLeft(@NotNull String v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.myAxisTitleLeft = v;
    }

    public final void setAxisTitleBottom(@NotNull String v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.myAxisTitleBottom = v;
    }

    @NotNull
    public final PlotBuilder setCoordProvider(@NotNull CoordProvider coordProvider) {
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        this.myCoordProvider = coordProvider;
        return this;
    }

    @NotNull
    public final PlotBuilder addTileLayers(@NotNull List<? extends GeomLayer> tileLayers) {
        Intrinsics.checkNotNullParameter(tileLayers, (String)"tileLayers");
        this.myLayersByTile.add(new ArrayList(tileLayers));
        return this;
    }

    @NotNull
    public final PlotBuilder setPlotLayout(@NotNull PlotLayout layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        this.myLayout = layout;
        return this;
    }

    @NotNull
    public final PlotBuilder addLegendBoxInfo(@NotNull LegendBoxInfo v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.myLegendBoxInfos.add(v);
        return this;
    }

    @NotNull
    public final PlotBuilder scaleXProto(@NotNull Scale<Double> scaleXProto) {
        Intrinsics.checkNotNullParameter(scaleXProto, (String)"scaleXProto");
        this.myScaleXProto = scaleXProto;
        return this;
    }

    @NotNull
    public final PlotBuilder scaleYProto(@NotNull Scale<Double> scaleYProto) {
        Intrinsics.checkNotNullParameter(scaleYProto, (String)"scaleYProto");
        this.myScaleYProto = scaleYProto;
        return this;
    }

    @NotNull
    public final PlotBuilder axisEnabled(boolean b) {
        this.myAxisEnabled = b;
        return this;
    }

    @NotNull
    public final PlotBuilder interactionsEnabled(boolean b) {
        this.myInteractionsEnabled = b;
        return this;
    }

    @NotNull
    public final PlotBuilder setLiveMap(boolean b) {
        this.hasLiveMap = b;
        return this;
    }

    @NotNull
    public final Plot build() {
        return new MyPlot(this);
    }

    public PlotBuilder(@NotNull Theme myTheme) {
        Intrinsics.checkNotNullParameter((Object)myTheme, (String)"myTheme");
        this.myTheme = myTheme;
        this.myLayersByTile = new ArrayList();
        this.myLegendBoxInfos = new ArrayList();
        this.myAxisEnabled = true;
        this.myInteractionsEnabled = true;
    }

    public static final /* synthetic */ Scale access$getMyScaleXProto$p(PlotBuilder $this) {
        Scale<Double> scale = $this.myScaleXProto;
        if (scale == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myScaleXProto");
        }
        return scale;
    }

    public static final /* synthetic */ void access$setMyScaleXProto$p(PlotBuilder $this, Scale scale) {
        $this.myScaleXProto = scale;
    }

    public static final /* synthetic */ Scale access$getMyScaleYProto$p(PlotBuilder $this) {
        Scale<Double> scale = $this.myScaleYProto;
        if (scale == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myScaleYProto");
        }
        return scale;
    }

    public static final /* synthetic */ void access$setMyScaleYProto$p(PlotBuilder $this, Scale scale) {
        $this.myScaleYProto = scale;
    }

    public static final /* synthetic */ void access$setMyTitle$p(PlotBuilder $this, String string) {
        $this.myTitle = string;
    }

    public static final /* synthetic */ void access$setMyAxisTitleLeft$p(PlotBuilder $this, String string) {
        $this.myAxisTitleLeft = string;
    }

    public static final /* synthetic */ void access$setMyAxisTitleBottom$p(PlotBuilder $this, String string) {
        $this.myAxisTitleBottom = string;
    }

    public static final /* synthetic */ CoordProvider access$getMyCoordProvider$p(PlotBuilder $this) {
        CoordProvider coordProvider = $this.myCoordProvider;
        if (coordProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myCoordProvider");
        }
        return coordProvider;
    }

    public static final /* synthetic */ void access$setMyCoordProvider$p(PlotBuilder $this, CoordProvider coordProvider) {
        $this.myCoordProvider = coordProvider;
    }

    public static final /* synthetic */ void access$setMyLayout$p(PlotBuilder $this, PlotLayout plotLayout) {
        $this.myLayout = plotLayout;
    }

    public static final /* synthetic */ void access$setHasLiveMap$p(PlotBuilder $this, boolean bl) {
        $this.hasLiveMap = bl;
    }

    public static final /* synthetic */ void access$setMyAxisEnabled$p(PlotBuilder $this, boolean bl) {
        $this.myAxisEnabled = bl;
    }

    public static final /* synthetic */ void access$setMyInteractionsEnabled$p(PlotBuilder $this, boolean bl) {
        $this.myInteractionsEnabled = bl;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u00106\u001a\u00020\u0010H\u0014J\b\u00107\u001a\u00020\u0010H\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u00108\u001a\u00020\u0010H\u0014J\b\u00109\u001a\u00020 H\u0014J\u0016\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00152\u0006\u0010;\u001a\u00020<H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010%\u001a\u0004\u0018\u00010&X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010'R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020&0)X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020&0)X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010+R\u0014\u0010.\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\bR\u0016\u00100\u001a\u0004\u0018\u00010$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0016\u00103\u001a\u0004\u0018\u00010&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006="}, d2={"Ljetbrains/datalore/plot/builder/PlotBuilder$MyPlot;", "Ljetbrains/datalore/plot/builder/Plot;", "b", "Ljetbrains/datalore/plot/builder/PlotBuilder;", "(Ljetbrains/datalore/plot/builder/PlotBuilder;)V", "axisTitleBottom", "", "getAxisTitleBottom", "()Ljava/lang/String;", "axisTitleLeft", "getAxisTitleLeft", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "getCoordProvider", "()Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "hasLiveMap", "", "isAxisEnabled", "()Z", "isInteractionsEnabled", "legendBoxInfos", "", "Ljetbrains/datalore/plot/builder/layout/LegendBoxInfo;", "getLegendBoxInfos", "()Ljava/util/List;", "myAxisTitleBottom", "myAxisTitleLeft", "myAxisXTitleEnabled", "myAxisYTitleEnabled", "myLayersByTile", "Ljetbrains/datalore/plot/builder/GeomLayer;", "myLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayout;", "myLegendBoxInfos", "myTitle", "myTooltipAnchor", "Ljetbrains/datalore/plot/builder/guide/TooltipAnchor;", "myTooltipMinWidth", "", "Ljava/lang/Double;", "scaleXProto", "Ljetbrains/datalore/plot/base/Scale;", "getScaleXProto", "()Ljetbrains/datalore/plot/base/Scale;", "scaleYProto", "getScaleYProto", "title", "getTitle", "tooltipAnchor", "getTooltipAnchor", "()Ljetbrains/datalore/plot/builder/guide/TooltipAnchor;", "tooltipMinWidth", "getTooltipMinWidth", "()Ljava/lang/Double;", "hasAxisTitleBottom", "hasAxisTitleLeft", "hasTitle", "plotLayout", "tileLayers", "tileIndex", "", "plot-builder-portable"})
    private static final class MyPlot
    extends Plot {
        @NotNull
        private final Scale<Double> scaleXProto;
        @NotNull
        private final Scale<Double> scaleYProto;
        private final String myTitle;
        private final String myAxisTitleLeft;
        private final String myAxisTitleBottom;
        private final boolean myAxisXTitleEnabled;
        private final boolean myAxisYTitleEnabled;
        private final TooltipAnchor myTooltipAnchor;
        private final Double myTooltipMinWidth;
        @NotNull
        private final CoordProvider coordProvider;
        private final List<List<GeomLayer>> myLayersByTile;
        private final PlotLayout myLayout;
        private final List<LegendBoxInfo> myLegendBoxInfos;
        private final boolean hasLiveMap;
        private final boolean isAxisEnabled;
        private final boolean isInteractionsEnabled;

        @Override
        @NotNull
        protected Scale<Double> getScaleXProto() {
            return this.scaleXProto;
        }

        @Override
        @NotNull
        protected Scale<Double> getScaleYProto() {
            return this.scaleYProto;
        }

        @Override
        @NotNull
        protected CoordProvider getCoordProvider() {
            return this.coordProvider;
        }

        @Override
        protected boolean isAxisEnabled() {
            return this.isAxisEnabled;
        }

        @Override
        public boolean isInteractionsEnabled() {
            return this.isInteractionsEnabled;
        }

        @Override
        @NotNull
        protected String getTitle() {
            Preconditions.INSTANCE.checkArgument(this.hasTitle(), "No title");
            String string = this.myTitle;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        @Override
        @NotNull
        protected String getAxisTitleLeft() {
            Preconditions.INSTANCE.checkArgument(this.hasAxisTitleLeft(), "No left axis title");
            String string = this.myAxisTitleLeft;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        @Override
        @NotNull
        protected String getAxisTitleBottom() {
            Preconditions.INSTANCE.checkArgument(this.hasAxisTitleBottom(), "No bottom axis title");
            String string = this.myAxisTitleBottom;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        @Override
        @NotNull
        protected List<LegendBoxInfo> getLegendBoxInfos() {
            return this.myLegendBoxInfos;
        }

        @Override
        @Nullable
        public TooltipAnchor getTooltipAnchor() {
            return this.myTooltipAnchor;
        }

        @Override
        @Nullable
        public Double getTooltipMinWidth() {
            return this.myTooltipMinWidth;
        }

        @Override
        protected boolean hasTitle() {
            return !Strings.INSTANCE.isNullOrEmpty(this.myTitle);
        }

        @Override
        protected boolean hasAxisTitleLeft() {
            return this.myAxisYTitleEnabled && !Strings.INSTANCE.isNullOrEmpty(this.myAxisTitleLeft);
        }

        @Override
        protected boolean hasAxisTitleBottom() {
            return this.myAxisXTitleEnabled && !Strings.INSTANCE.isNullOrEmpty(this.myAxisTitleBottom);
        }

        @Override
        protected boolean hasLiveMap() {
            return this.hasLiveMap;
        }

        @Override
        @NotNull
        protected List<GeomLayer> tileLayers(int tileIndex) {
            return this.myLayersByTile.get(tileIndex);
        }

        @Override
        @NotNull
        protected PlotLayout plotLayout() {
            PlotLayout plotLayout = this.myLayout;
            Intrinsics.checkNotNull((Object)plotLayout);
            return plotLayout;
        }

        public MyPlot(@NotNull PlotBuilder b) {
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            super(b.myTheme);
            this.scaleXProto = PlotBuilder.access$getMyScaleXProto$p(b);
            this.scaleYProto = PlotBuilder.access$getMyScaleYProto$p(b);
            this.myTitle = b.myTitle;
            this.myAxisTitleLeft = b.myAxisTitleLeft;
            this.myAxisTitleBottom = b.myAxisTitleBottom;
            this.myAxisXTitleEnabled = b.myTheme.axisX().showTitle();
            this.myAxisYTitleEnabled = b.myTheme.axisY().showTitle();
            this.myTooltipAnchor = b.myTheme.tooltip().anchor();
            this.myTooltipMinWidth = b.myTheme.tooltip().minWidth();
            this.coordProvider = PlotBuilder.access$getMyCoordProvider$p(b);
            this.myLayersByTile = new ArrayList(b.myLayersByTile);
            this.myLayout = b.myLayout;
            this.myLegendBoxInfos = new ArrayList(b.myLegendBoxInfos);
            this.hasLiveMap = b.hasLiveMap;
            this.isAxisEnabled = b.myAxisEnabled;
            this.isInteractionsEnabled = b.myInteractionsEnabled;
        }
    }
}

