/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder;

import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.Scale;
import jetbrains.datalore.plot.base.scale.ScaleUtil;
import jetbrains.datalore.plot.builder.guide.AxisComponent;
import jetbrains.datalore.plot.builder.layout.AxisLayoutInfo;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ,\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Ljetbrains/datalore/plot/builder/AxisUtil;", "", "()V", "applyLayoutInfo", "", "axis", "Ljetbrains/datalore/plot/builder/guide/AxisComponent;", "info", "Ljetbrains/datalore/plot/builder/layout/AxisLayoutInfo;", "applyTheme", "theme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "setBreaks", "scale", "Ljetbrains/datalore/plot/base/Scale;", "", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "isHorizontal", "", "plot-builder-portable"})
public final class AxisUtil {
    public static final AxisUtil INSTANCE;

    public final void applyLayoutInfo(@NotNull AxisComponent axis, @NotNull AxisLayoutInfo info) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        axis.getTickLabelOffsets().set(info.getTickLabelAdditionalOffsets());
        axis.getTickLabelRotationDegree().set(info.getTickLabelRotationAngle());
        if (info.getTickLabelHorizontalAnchor() != null) {
            axis.getTickLabelHorizontalAnchor().set(info.getTickLabelHorizontalAnchor());
        }
        if (info.getTickLabelVerticalAnchor() != null) {
            axis.getTickLabelVerticalAnchor().set(info.getTickLabelVerticalAnchor());
        }
        axis.getTickLabelSmallFont().set(info.getTickLabelSmallFont());
    }

    public final void applyTheme(@NotNull AxisComponent axis, @NotNull AxisTheme theme) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        axis.tickLabelsEnabled().set(theme.showTickLabels());
        axis.tickMarksEnabled().set(theme.showTickMarks());
        axis.axisLineEnabled().set(theme.showLine());
        axis.getLineWidth().set(theme.lineWidth());
        axis.getTickMarkLength().set(theme.tickMarkLength());
        axis.getTickMarkPadding().set(theme.tickMarkPadding());
        axis.getTickMarkWidth().set(theme.tickMarkWidth());
    }

    public final void setBreaks(@NotNull AxisComponent axis, @NotNull Scale<Double> scale, @NotNull CoordinateSystem coord, boolean isHorizontal) {
        Intrinsics.checkNotNullParameter((Object)axis, (String)"axis");
        Intrinsics.checkNotNullParameter(scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        axis.getBreaks().set(ScaleUtil.INSTANCE.axisBreaks(scale, coord, isHorizontal));
        axis.getLabels().set(ScaleUtil.INSTANCE.labels(scale));
    }

    private AxisUtil() {
    }

    static {
        AxisUtil axisUtil;
        INSTANCE = axisUtil = new AxisUtil();
    }
}

