/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.regression;

import java.util.List;
import jetbrains.datalore.base.gcommon.base.Preconditions;
import jetbrains.datalore.plot.base.stat.math3.ForsythePolynomialGenerator;
import jetbrains.datalore.plot.base.stat.math3.PolynomialFunction;
import jetbrains.datalore.plot.base.stat.math3.PolynomialFunctionKt;
import jetbrains.datalore.plot.base.stat.math3.TDistribution;
import jetbrains.datalore.plot.base.stat.regression.EvalResult;
import jetbrains.datalore.plot.base.stat.regression.RegressionEvaluator;
import jetbrains.datalore.plot.base.stat.regression.RegressionUtilKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B5\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0016R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/base/stat/regression/PolynomialRegression;", "Ljetbrains/datalore/plot/base/stat/regression/RegressionEvaluator;", "xs", "", "", "ys", "confidenceLevel", "deg", "", "(Ljava/util/List;Ljava/util/List;DI)V", "meanX", "n", "p", "Ljetbrains/datalore/plot/base/stat/math3/PolynomialFunction;", "sumXX", "sy", "tcritical", "calcPolynomial", "xVals", "", "yVals", "coefficient", "evalX", "Ljetbrains/datalore/plot/base/stat/regression/EvalResult;", "x", "Companion", "plot-base-portable"})
public final class PolynomialRegression
extends RegressionEvaluator {
    private final PolynomialFunction p;
    private final int n;
    private final double meanX;
    private final double sumXX;
    private final double sy;
    private final double tcritical;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    private final PolynomialFunction calcPolynomial(int deg, double[] xVals, double[] yVals) {
        ForsythePolynomialGenerator fpg = new ForsythePolynomialGenerator(xVals);
        PolynomialFunction res = new PolynomialFunction(new double[]{0.0});
        int n = 0;
        int n2 = deg;
        if (n <= n2) {
            while (true) {
                void i;
                PolynomialFunction p = fpg.getPolynomial((int)i);
                double s2 = this.coefficient(p, xVals, yVals);
                res = res.plus(PolynomialFunctionKt.times(s2, p));
                if (i == n2) break;
                ++i;
            }
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    private final double coefficient(PolynomialFunction p, double[] xVals, double[] yVals) {
        double ww = 0.0;
        double w = 0.0;
        int n = 0;
        int n2 = xVals.length;
        while (n < n2) {
            void i;
            double x2 = xVals[i];
            double y2 = yVals[i];
            double pval = p.value(x2);
            ww += pval * pval;
            w += y2 * pval;
            ++i;
        }
        return w / ww;
    }

    @Override
    @NotNull
    public EvalResult evalX(double x2) {
        PolynomialRegression polynomialRegression = this;
        boolean bl = false;
        boolean bl2 = false;
        PolynomialRegression $this$run = polynomialRegression;
        boolean bl3 = false;
        double d = x2 - $this$run.meanX;
        int n = 2;
        boolean bl4 = false;
        double dxSquare = Math.pow(d, n);
        d = 1.0 / (double)$this$run.n + dxSquare / $this$run.sumXX;
        n = 0;
        double se = $this$run.sy * Math.sqrt(d);
        double halfConfidenceInterval = this.tcritical * se;
        double yHat = this.p.value(x2);
        return new EvalResult(yHat, yHat - halfConfidenceInterval, yHat + halfConfidenceInterval, se);
    }

    /*
     * WARNING - void declaration
     */
    public PolynomialRegression(@NotNull List<Double> xs, @NotNull List<Double> ys, double confidenceLevel, int deg) {
        PolynomialRegression $this$run;
        double d;
        void $this$sumByDouble$iv;
        void xVals;
        Intrinsics.checkNotNullParameter(xs, (String)"xs");
        Intrinsics.checkNotNullParameter(ys, (String)"ys");
        super(xs, ys, confidenceLevel);
        Preconditions.INSTANCE.checkArgument(deg >= 2, "Degree of polynomial must be at least 2");
        Pair<double[], double[]> pair2 = RegressionUtilKt.averageByX(xs, ys);
        double[] dArray = (double[])pair2.component1();
        double[] yVals = (double[])pair2.component2();
        this.n = ((void)xVals).length;
        Preconditions.INSTANCE.checkArgument(this.n > deg, "The number of valid data points must be greater than deg");
        this.p = this.calcPolynomial(deg, (double[])xVals, yVals);
        this.meanX = ArraysKt.average((double[])xVals);
        pair2 = xVals;
        PolynomialRegression polynomialRegression = this;
        boolean $i$f$sumByDouble = false;
        double sum$iv = 0.0;
        void var12_13 = $this$sumByDouble$iv;
        int n = ((void)var12_13).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var17_23 = element$iv = var12_13[i];
            d = sum$iv;
            boolean bl = false;
            void var20_26 = it - this.meanX;
            int n2 = 2;
            boolean bl2 = false;
            double d2 = Math.pow((double)var20_26, n2);
            sum$iv = d + d2;
        }
        polynomialRegression.sumXX = d = sum$iv;
        double df = (double)(this.n - deg) - 1.0;
        PolynomialRegression polynomialRegression2 = this;
        boolean bl = false;
        boolean bl3 = false;
        PolynomialRegression polynomialRegression3 = polynomialRegression2;
        polynomialRegression = this;
        boolean bl4 = false;
        Iterable $this$sumByDouble$iv2 = ArraysKt.zip((double[])xVals, (double[])yVals);
        boolean $i$f$sumByDouble2 = false;
        double sum$iv2 = 0.0;
        for (Object element$iv : $this$sumByDouble$iv2) {
            void x2;
            void $dstr$x$y;
            Pair pair3 = (Pair)element$iv;
            double d3 = sum$iv2;
            boolean bl5 = false;
            double d4 = ((Number)$dstr$x$y.component1()).doubleValue();
            double y2 = ((Number)$dstr$x$y.component2()).doubleValue();
            double d5 = y2 - $this$run.p.value((double)x2);
            int n3 = 2;
            boolean bl6 = false;
            double d6 = Math.pow(d5, n3);
            sum$iv2 = d3 + d6;
        }
        double sse = sum$iv2;
        double d7 = sse / df;
        boolean bl7 = false;
        polynomialRegression.sy = d = Math.sqrt(d7);
        polynomialRegression2 = this;
        bl = false;
        bl3 = false;
        $this$run = polynomialRegression2;
        polynomialRegression = this;
        boolean bl8 = false;
        double alpha = 1.0 - confidenceLevel;
        polynomialRegression.tcritical = d = new TDistribution(df, 0.0, 2, null).inverseCumulativeProbability(1.0 - alpha / 2.0);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/base/stat/regression/PolynomialRegression$Companion;", "", "()V", "canBeComputed", "", "xs", "", "", "ys", "deg", "", "plot-base-portable"})
    public static final class Companion {
        public final boolean canBeComputed(@NotNull List<Double> xs, @NotNull List<Double> ys, int deg) {
            Intrinsics.checkNotNullParameter(xs, (String)"xs");
            Intrinsics.checkNotNullParameter(ys, (String)"ys");
            Pair<double[], double[]> pair2 = RegressionUtilKt.averageByX(xs, ys);
            double[] xVals = (double[])pair2.component1();
            return xVals.length > deg;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

