/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat.math3;

import jetbrains.datalore.plot.base.stat.math3.AbstractRealDistribution;
import jetbrains.datalore.plot.base.stat.math3.Beta;
import jetbrains.datalore.plot.base.stat.math3.Gamma;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0012\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0014\u0010\u000b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0007\u00a8\u0006\u001b"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/TDistribution;", "Ljetbrains/datalore/plot/base/stat/math3/AbstractRealDistribution;", "degreesOfFreedom", "", "solverAbsoluteAccuracy", "(DD)V", "getDegreesOfFreedom", "()D", "isSupportConnected", "", "()Z", "isSupportLowerBoundInclusive", "isSupportUpperBoundInclusive", "numericalMean", "getNumericalMean", "numericalVariance", "getNumericalVariance", "getSolverAbsoluteAccuracy", "supportLowerBound", "getSupportLowerBound", "supportUpperBound", "getSupportUpperBound", "cumulativeProbability", "x", "density", "probability", "Companion", "plot-base-portable"})
public final class TDistribution
extends AbstractRealDistribution {
    private final double degreesOfFreedom;
    private final double solverAbsoluteAccuracy;
    private static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY;
    private static final long serialVersionUID;
    public static final Companion Companion;

    @Override
    public double getNumericalMean() {
        double df = this.degreesOfFreedom;
        return df > 1.0 ? 0.0 : Double.NaN;
    }

    @Override
    public double getNumericalVariance() {
        double df = this.degreesOfFreedom;
        if (df > (double)2) {
            return df / (df - (double)2);
        }
        return df > 1.0 && df <= (double)2 ? Double.POSITIVE_INFINITY : Double.NaN;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    @Override
    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public double probability(double x2) {
        return 0.0;
    }

    @Override
    public double density(double x2) {
        double n = this.degreesOfFreedom;
        double nPlus1Over2 = (n + 1.0) / (double)2;
        double d = Math.PI;
        boolean bl = false;
        boolean bl2 = false;
        double d2 = 1.0 + x2 * x2 / n;
        bl = false;
        d2 = Gamma.INSTANCE.logGamma(nPlus1Over2) - 0.5 * (Math.log(d) + Math.log(n)) - Gamma.INSTANCE.logGamma(n / (double)2) - nPlus1Over2 * Math.log(d2);
        bl = false;
        return Math.exp(d2);
    }

    @Override
    public double cumulativeProbability(double x2) {
        double ret = 0.0;
        if (x2 == 0.0) {
            ret = 0.5;
        } else {
            double t = Beta.regularizedBeta$default(Beta.INSTANCE, this.degreesOfFreedom / (this.degreesOfFreedom + x2 * x2), 0.5 * this.degreesOfFreedom, 0.5, 0.0, 0, 24, null);
            ret = x2 < 0.0 ? 0.5 * t : 1.0 - 0.5 * t;
        }
        return ret;
    }

    public final double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    @JvmOverloads
    public TDistribution(double degreesOfFreedom, double solverAbsoluteAccuracy) {
        this.degreesOfFreedom = degreesOfFreedom;
        this.solverAbsoluteAccuracy = solverAbsoluteAccuracy;
        if (this.degreesOfFreedom <= 0.0) {
            String string = "NotStrictlyPositive - DEGREES_OF_FREEDOM: " + this.degreesOfFreedom;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ TDistribution(double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d2 = DEFAULT_INVERSE_ABSOLUTE_ACCURACY;
        }
        this(d, d2);
    }

    @JvmOverloads
    public TDistribution(double degreesOfFreedom) {
        this(degreesOfFreedom, 0.0, 2, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
        serialVersionUID = -5852615386664158222L;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Ljetbrains/datalore/plot/base/stat/math3/TDistribution$Companion;", "", "()V", "DEFAULT_INVERSE_ABSOLUTE_ACCURACY", "", "getDEFAULT_INVERSE_ABSOLUTE_ACCURACY", "()D", "serialVersionUID", "", "plot-base-portable"})
    public static final class Companion {
        public final double getDEFAULT_INVERSE_ABSOLUTE_ACCURACY() {
            return DEFAULT_INVERSE_ABSOLUTE_ACCURACY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

